
<html>
	<head>
		<title>Bootstrap-Material DateTimePicker</title>
		<meta http-equiv="content-type" content="text/html; charset=UTF-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.2/css/bootstrap.min.css" />

		<link rel="stylesheet"
			  href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-material-design/0.5.10/css/bootstrap-material-design.min.css"/>
		<link rel="stylesheet"
			  href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-material-design/0.5.10/css/ripples.min.css"/>


		<link rel="stylesheet" href="<?=base_url('assets/adminlte/material/bootstrap-material-datetimepicker.css');?>">
		<link href='http://fonts.googleapis.com/css?family=Roboto:400,500' rel='stylesheet' type='text/css'>
		<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

		<script src="https://code.jquery.com/jquery-1.12.3.min.js" integrity="sha256-aaODHAgvwQW1bFOGXMeX+pC4PZIPsvn2h1sArYOhgXQ=" crossorigin="anonymous"></script>
		<script type="text/javascript" src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.2/js/bootstrap.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-material-design/0.5.10/js/ripples.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-material-design/0.5.10/js/material.min.js"></script>
		<script type="text/javascript" src="https://rawgit.com/FezVrasta/bootstrap-material-design/master/dist/js/material.min.js"></script>
		<script type="text/javascript" src="http://momentjs.com/downloads/moment-with-locales.min.js"></script>
		<script type="text/javascript" src="<?=base_url('assets/adminlte/material/bootstrap-material-datetimepicker.js');?>"></script>


		<style>
			body 
			{
				padding-top: 70px;
				font-family: 'Roboto', sans-serif;
			}
			h2 
			{
				padding: 0 20px 10px 20px;
				font-size: 20px;
				font-weight: 400;
			}
			.form-control-wrapper 
			{
				margin: 10px 20px;
			}
			code 
			{
				padding: 10px;
				background: #eee!important;
				display: block;
				color: #000;
			}
			code > p 
			{
				font-weight: bold;
				color: #000;
				font-size: 1.5em;
			}
			@media(max-width: 300px)
			{
				.well { margin : 0}
			}
		</style>
		
	</head>
	<body>
		<div class="container well">
			<div class="row">
				<div class="col-md-6">
					<h1>Bootstrap Material DatePicker</h1>
				</div>
			</div>
		</div>
		<div class="container well">
			<div class="row">
				<div class="col-md-6">
					<h2>Date Picker</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="form-control-wrapper">
						<input type="text" id="date" class="form-control floating-label" placeholder="Date">
					</div>
				</div>
				<div class="col-md-6">
					<code>
						<p>Code</p>
						$('#date').bootstrapMaterialDatePicker({ weekStart : 0, time: false });
					</code>
				</div>
			</div>
		</div>
		<div class="container well">
			<div class="row">
				<div class="col-md-6">
					<h2>Time Picker</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="form-control-wrapper">
						<input type="text" id="time" class="form-control floating-label" placeholder="Time">
					</div>
				</div>
				<div class="col-md-6">
					<code>
						<p>Code</p>
						$('#time').bootstrapMaterialDatePicker({ date: false });
					</code>
				</div>
			</div>
		</div>
		<div class="container well">
			<div class="row">
				<div class="col-md-6">
					<h2>Date Time Picker</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="form-control-wrapper">
						<input type="text" id="date-format" class="form-control floating-label" placeholder="Begin Date Time">
					</div>
				</div>
				<div class="col-md-6">
					<code>
						<p>Code</p>
						$('#date-format').bootstrapMaterialDatePicker({ format : 'dddd DD MMMM YYYY - HH:mm' });
					</code>
				</div>
			</div>
		</div>
		<div class="container well">
			<div class="row">
				<div class="col-md-6">
					<h2>French Locales (Week starts at Monday)</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="form-control-wrapper">
						<input type="text" id="date-fr" class="form-control floating-label" value="18/03/2015 08:00" placeholder="Date de dbut">
					</div>
				</div>
				<div class="col-md-6">
					<code>
						<p>Code</p>
						$('#date-fr').bootstrapMaterialDatePicker({ format : 'DD/MM/YYYY HH:mm', lang : 'fr', weekStart : 1, cancelText : 'ANNULER' });
					</code>
				</div>
			</div>
		</div>
		<div class="container well">
			<div class="row">
				<div class="col-md-6">
					<h2>Min Date set</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="form-control-wrapper">
						<input type="text" id="min-date" class="form-control floating-label" placeholder="Start Date">
					</div>
				</div>
				<div class="col-md-6">
					<code>
						<p>Code</p>
						$('#min-date').bootstrapMaterialDatePicker({ format : 'DD/MM/YYYY HH:mm', minDate : new Date() });
					</code>
				</div>
			</div>
		</div>
		<div class="container well">
			<div class="row">
				<div class="col-md-6">
					<h2>Events</h2>
				</div>
			</div>
			<div class="row">
				<div class="col-md-6">
					<div class="row">
						<div class="col-md-12">
							<div class="form-control-wrapper">
								<input type="text" id="date-start" class="form-control floating-label" placeholder="Start Date">
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<div class="form-control-wrapper">
								<input type="text" id="date-end" class="form-control floating-label" placeholder="End Date">
							</div>
						</div>
					</div>
				</div>
				<div class="col-md-6">
					<div class="row">
						<div class="col-md-12">
							<code>
								<p>Code</p>
								$('#date-end').bootstrapMaterialDatePicker({ weekStart : 0 });<br />
								$('#date-start').bootstrapMaterialDatePicker({ weekStart : 0 }).on('change', function(e, date)<br />
								{<br />
									$('#date-end').bootstrapMaterialDatePicker('setMinDate', date);<br />
								});
							</code>
						</div>
					</div>
				</div>
			</div>
		</div>
		<script type="text/javascript">
		$(document).ready(function()
		{
			$('#date').bootstrapMaterialDatePicker
			({
				time: false,
				clearButton: true
			});

			$('#time').bootstrapMaterialDatePicker
			({
				date: false,
				shortTime: false,
				format: 'HH:mm'
			});

			$('#date-format').bootstrapMaterialDatePicker
			({
				format: 'dddd DD MMMM YYYY - HH:mm'
			});
			$('#date-fr').bootstrapMaterialDatePicker
			({
				format: 'DD/MM/YYYY HH:mm',
				lang: 'fr',
				weekStart: 1, 
				cancelText : 'ANNULER',
				nowButton : true,
				switchOnClick : true
			});

			$('#date-end').bootstrapMaterialDatePicker
			({
				weekStart: 0, format: 'DD/MM/YYYY HH:mm'
			});
			$('#date-start').bootstrapMaterialDatePicker
			({
				weekStart: 0, format: 'DD/MM/YYYY HH:mm', shortTime : true
			}).on('change', function(e, date)
			{
				$('#date-end').bootstrapMaterialDatePicker('setMinDate', date);
			});

			$('#min-date').bootstrapMaterialDatePicker({ format : 'DD/MM/YYYY HH:mm', minDate : new Date() });

			$.material.init()
		});
		</script>
	</body>
</html>
