<?php defined("BASEPATH")or exit("NO DIRECT ACCESS IS ALLOWED");?>

<?php

class StudentpaymentsModel extends CI_Model{
    public function __construct() {
        parent::__construct();
    }
    public function student_payment_check_count($category,$class,$subject,$courseid,$class_id,$student){
        $query=$this->db->select(['id'])->from('v2_payment_course_student')
        ->where('category_id',$category)
        ->where('class_id',$class)
        ->where('subject_id',$subject)
        ->where('course_id',$courseid)
          ->where('class_id',$class_id)
        ->where('student_id',$student)
        ->get();
        return $query->num_rows();
    }
    public function insert_payment($data_category){

        $this->db->insert('v2_payment_course_student', $data_category);
        $data_category['id'] = $this->db->insert_id();
        return $data_category['id'];
    }
    public function insert_payment_detail($data_category){

        $this->db->insert('v2_payment_course_student_detail', $data_category);
        $data_category['id'] = $this->db->insert_id();
        return $data_category['id'];
    }
    public function subject_code_get($cateid, $clid,$subid){
        $query  = $this->db->select(['subject.subject','subject.subject_code','category.category','category.category_code','class.class','class.class_code'])
        ->from('subject')
        ->join('category','subject.category_id=category.id')
        ->join('class','subject.class_id=class.id')
        ->where('subject.category_id', $cateid)
        ->where('subject.class_id', $clid)
        ->where('subject.id', $subid)
        ->get();
        //echo $this->db->last_query();die;
        return $query->row();
    }
    public function student_payments_list_detail($payid){
        $query  = $this->db->select(['pay2.id','(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id)as course_id_tag',
            '(select CONCAT(first_name, " ", last_name) from master_user  where pay2.student_id=master_user.id) as student',
            '(select CONCAT(mobile, ",", email) from master_user  where pay2.student_id=master_user.id) as student_contact',
            '(select category from category where category.id=pay2.category_id)as category',
            '(select subject from subject where subject.id=pay2.subject_id)as subject',
            '(select class from class where class.id=pay2.class_id)as class','subject_code','pay2_det.amount_recieved_from_st',
            'pay2_det.mode_of_payment',
            'pay2_det.payment_status','pay2_det.no_of_class_alot','pay2_det.payment_recive_date','pay2_det.approved'
        ])
        ->from('v2_payment_course_student as pay2')
        ->join('v2_payment_course_student_detail as pay2_det','pay2_det.pay_id=pay2.id')
        ->where('pay2_det.pay_id',$payid)
        ->order_by("pay2.id","desc")->get();
        // echo $this->db->last_query();die;
        return $query->result();
    }
    public function student_payments_list($limit, $offset){
        $offset = ($offset-1)*$limit;
        $query  = $this->db->select(['pay2.id','(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id)as course_id_tag',
            '(select CONCAT(first_name, " ", last_name) from master_user  where pay2.student_id=master_user.id) as student',
            '(select CONCAT(mobile, ",", email) from master_user  where pay2.student_id=master_user.id) as student_contact',
            '(select category from category where category.id=pay2.category_id)as category',
            '(select subject from subject where subject.id=pay2.subject_id)as subject',
            '(select class from class where class.id=pay2.class_id)as class','subject_code',
            'pay_detail.amount_recieved_from_st','pay_detail.mode_of_payment','pay_detail.payment_status',
            'pay_detail.no_of_class_alot','pay_detail.payment_recive_date'
        ])
        ->from('v2_payment_course_student as pay2')
        ->join('v2_payment_course_student_detail as pay_detail','pay2.id=pay_detail.pay_id')
        ->order_by("pay2.id","desc")->limit($limit, $offset)->get();
        //echo $this->db->last_query();die;
        return $query->result();
    }
    // Count Num ROWS
    public function student_payments_list_num_rows(){
        $query  = $this->db->select(['pay2.id','(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id)as course_id_tag',
            '(select CONCAT(first_name, " ", last_name) from master_user  where pay2.student_id=master_user.id) as student',
            '(select CONCAT(mobile, ",", email) from master_user  where pay2.student_id=master_user.id) as student_contact',
            '(select category from category where category.id=pay2.category_id)as category',
            '(select subject from subject where subject.id=pay2.subject_id)as subject',
            '(select class from class where class.id=pay2.class_id)as class','subject_code',
            'pay_detail.amount_recieved_from_st','pay_detail.mode_of_payment','pay_detail.payment_status',
            'pay_detail.no_of_class_alot','pay_detail.payment_recive_date'
        ])
        ->from('v2_payment_course_student as pay2')
        ->join('v2_payment_course_student_detail as pay_detail','pay2.id=pay_detail.pay_id')
        ->order_by("pay2.id","desc")->get();
        //echo $this->db->last_query();die;
        return $query->num_rows();
    }

    public function update_admin_reply_to_user($field,$value,$editid){
        $this->db->set($field,$value);
        $this->db->where('id',$editid);
        $this->db->update('v2_student_request_program_chat');
        return true;
    }
    public function approve_apyment($listid){
        $this->db->set('approved','1');
        $this->db->where('v2_payment_course_student_detail.id',$listid);
        $this->db->update('v2_payment_course_student_detail');
        return true;
    }

}
