<?php defined('BASEPATH') or exit('No direct Access is Allowed'); ?>
<?php
class Subjectmodel extends CI_Model{

	public function __construct() {
        parent::__construct();
    }
	public function subject_list($limit, $offset){
		
		$offset = ($offset-1)*$limit;
		$query  = $this->db->select(['subject.*','category.category','category.category_code','class.class','class.class_code'])
		->from('subject')
		->join('category','subject.category_id=category.id')
		->join('class','subject.class_id=class.id')
		->limit($limit, $offset)
		->get();
		//echo $this->db->last_query();die;
		return $query->result();
	}
	
	
	
	 public function subject_code_lists(){
          $query		=	  $this->db->select(['subject.id','subject.subject','subject.subject_code','class.class_code',
		  'category.category_code'])
		  ->from('subject')
		  ->join('category','category.id=subject.category_id')
		  ->join('class','class.id=subject.class_id')
		  ->order_by("category.id", "asc")->get();
		//echo "<pre>"; print_r($query->result_array());die;
		  
          $return 	= 	array();
          if($query->num_rows() > 0) {
              $return[''] = ('Select subject code');
              foreach($query->result_array() as $row) {
                  $return[$row['id']] = strtoupper($row['category_code'].$row['class_code'].$row['subject_code']);
              }
          }
          return $return;
      }
	
	public function num_rows(){
	    
	    $query  = $this->db->select(['subject.*','category.category','category.category_code','class.class','class.class_code'])
	    ->from('subject')
	    ->join('category','subject.category_id=category.id')
	    ->join('class','subject.class_id=class.id')
	    ->get();
		return $query->num_rows();
	}
	public function insert_subject($data_subject){
	
		$this->db->insert('subject', $data_subject);
		$data_subject['id'] = $this->db->insert_id();
    	return $data_subject['id'];	
	}
	
	public function update_subject($data_subject,$list_id){
	
		$this->db->where('id',$list_id);
		$this->db->update('subject', $data_subject);
		return true;
	}
	
	public function view_subject($list_id){
	
	    $query  = $this->db->select(['subject.*','category.category','category.category_code','class.class','class.class_code'])
	    ->from('subject')
	    ->join('category','subject.category_id=category.id')
	    ->join('class','subject.class_id=class.id')->where('subject.id',$list_id)->get();
		return $query->row();
	}
	public function count_subject($category,$class,$subject){
	    $query=$this->db->select(['*'])->from('subject')->where('category_id',$category)->where('class_id',$class)
	    ->where('subject',$subject)->get();
	    return $query->num_rows();
	}
	public function count_subject_code($category,$class,$subject_code){
	    $query=$this->db->select(['*'])->from('subject')->where('category_id',$category)->where('class_id',$class)
	    ->where('subject_code',$subject_code)->get();
	    return $query->num_rows();
	}
	
	public function delete_subject($list_id){
	
		$this->db->where('id', $list_id);
		$this->db->delete('subject');
	}
	public function count_subject_check($subject,$class){
	    $query  = $this->db->select(['*'])->from('subject')->where('subject',$subject)->where('class_id',$class)->get();
	    return $query->num_rows();
	}
	function getclass(){
	    $response = array();
	    // Select record
	    $this->db->select('*');
	    $q = $this->db->get('class');
	    $response = $q->result_array();
	    
	    return $response;
	}
	
	// Get City departments
	function get_class_subject($postData){
	    $response = array();
	    
	    // Select record
	    $this->db->select('id,subject');
	    $this->db->where('class_id', $postData['classes']);
	    $q = $this->db->get('subject');
	    $response = $q->result_array();
	    
	    return $response;
	}
	
	// Get Department user
	function get_class_subject_faculty($postData){
	    // echo "<pre>";print_r($postData['subject']);die;
	    $response     = array();
	    $this->db->select('*');
	    $this->db->where('subject_id', $postData['subject']);
	    $q            = $this->db->get('v2_faculty');
	    $response     = $q->result_array();
	    return $response;
	}
	public function search($data_taskpo){
	    
	    $condition	=	$data_taskpo['seach_term'];
	    $order		=	$data_taskpo['order_by'];
		$sql		= 
	    $query=$this->db->select(['subject.*','category.category','category.category_code','class.class','class.class_code'])
		  ->join('category','category.id=subject.category_id')
		  ->join('class','class.id=subject.class_id')
	        ->from('subject'); 
			
			
	        
	        if($condition=='or' && !empty($order)){
	            
	            if(!empty($data_taskpo['category'])){
	                $this->db->or_like('category.id',$data_taskpo['category'])->order_by('category.category',$order);
	            }
	          
			     if(!empty($data_taskpo['class'])){
	                $this->db->or_like('class.id', $data_taskpo['class']);
	            }
		
				 if(!empty($data_taskpo['subject'])){
	                $this->db->or_like('subject.id', $data_taskpo['subject']);
	            }
				
								
				if(!empty($data_taskpo['subject_code'])){
	                $this->db->or_like('subject.subject_code', $data_taskpo['subject_code'])
	                ->order_by('subject.id',$order);
	            }
	        }
	        
	        if($condition=='or' && empty($order)){
	            
	            if(!empty($data_taskpo['category'])){
	                $this->db->or_like('category.id', $data_taskpo['category']);
	            }
				
	            if(!empty($data_taskpo['class'])){
	                $this->db->or_like('class.id', $data_taskpo['class']);
	            }
				if(!empty($data_taskpo['subject'])){
	                $this->db->or_like('subject.id', $data_taskpo['subject']);
	            }
				
				if(!empty($data_taskpo['subject_code'])){
	                $this->db->or_like('subject.id', $data_taskpo['subject_code']);
	            }
				
				
				
	        }
	        
	        if($condition=='and' && !empty($order)){
	            
	            if(!empty($data_taskpo['category']))	{
	                $this->db->like('category.id',$data_taskpo['category'])->order_by('category.category',$order);
	            }
	           
				if(!empty($data_taskpo['class'])){
	                $this->db->like('class.id',$data_taskpo['class'])->order_by('class.class', $order);
	            }
				
				if(!empty($data_taskpo['subject'])){
	                $this->db->like('subject.id',$data_taskpo['subject'])->order_by('subject.subject', $order);
	            }
				if(!empty($data_taskpo['subject_code'])){
	                $this->db->like('subject.id',$data_taskpo['subject_code'])->order_by('subject.subject_code', $order);
	            }
				
	        }
	        
	        if($condition=='and' && empty($order)){
	            
	            if(!empty($data_taskpo['category']))	{
	                $this->db->like('category.id',$data_taskpo['category']);
	            }
	           
				if(!empty($data_taskpo['class']))		{
	                $this->db->like('class.id',$data_taskpo['class'])	;
	            }  
				if(!empty($data_taskpo['subject']))		{
	                $this->db->like('subject.id',$data_taskpo['subject'])	;
	            }  
				if(!empty($data_taskpo['subject_code']))		{
	                $this->db->like('subject.id',$data_taskpo['subject_code'])	;
	            }  
				
	        }
	        
	        $query=$this->db->get();
	       // echo $this->db->last_query();die;
	        if($query->num_rows()>0){
	            return $query->result();
	        }
	        else{
	            return $query->result();
	        }
	}
	
}
?>
