<?php defined('BASEPATH') or exit('No direct Access is Allowed'); ?>
<?php
class Facultymodel extends CI_Model{

	public function __construct() {
        parent::__construct();
    }
	public function faculty_list($limit, $offset){

		$offset = ($offset-1)*$limit;
		$query  = $this->db->select(['v2_faculty.*','category.category','category.category_code','class.class','class.class_code',
		    'subject.subject','subject.subject_code','master_user.first_name','master_user.last_name','master_user.email','master_user.userid'])
		->from('v2_faculty')
		->join('category','v2_faculty.category_id=category.id')
		->join('class','v2_faculty.class_id=class.id')
		->join('subject','v2_faculty.subject_id=subject.id')
		->join('master_user','v2_faculty.teacher_id=master_user.id')
		->limit($limit, $offset)
		->get();
		//echo $this->db->last_query();die;
		return $query->result();
	}

	public function faculty_code_lists(){
          $query  =	 $this->db->select(['category.category','category.category_code','class.class','class.class_code',
		    'subject.subject','subject.subject_code','v2_faculty.category_id','v2_faculty.class_id','v2_faculty.subject_id'])
		  ->from('v2_faculty')
		  ->join('category','v2_faculty.category_id=category.id')
		  ->join('class','v2_faculty.class_id=class.id')
		  ->join('subject','v2_faculty.subject_id=subject.id')
		  ->order_by('category.id', "asc")->get();
			//echo "<pre>"; print_r($query->result_array());die;

          $return 	= 	array();
          if($query->num_rows() > 0) {
              $return[''] = ('Select subject code');
              foreach($query->result_array() as $row) {
                  $return[$row['category_id'].','.$row['class_id'].','.$row['subject_id']] = strtoupper($row['category_code'].$row['class_code'].$row['subject_code']);
              }
          }
          return $return;
      }
	public function num_rows(){
	    $query  = $this->db->select(['v2_faculty.*','category.category','category.category_code','class.class','class.class_code',
	        'subject.subject','subject.subject_code','master_user.first_name','master_user.last_name','master_user.email'])
	        ->from('v2_faculty')
	        ->join('category','v2_faculty.category_id=category.id')
	        ->join('class','v2_faculty.class_id=class.id')
	        ->join('subject','v2_faculty.subject_id=subject.id')
	        ->join('master_user','v2_faculty.teacher_id=master_user.id')
	        ->limit($limit, $offset)
	        ->get();
		return $query->num_rows();
	}
	public function insert_faculty($data_faculty){

		$this->db->insert('v2_faculty', $data_faculty);
		$data_faculty['id'] = $this->db->insert_id();
    	return $data_faculty['id'];
	}

	public function update_faculty($data_faculty,$list_id){

		$this->db->where('id',$list_id);
		$this->db->update('v2_faculty', $data_faculty);
		return true;
	}


	public function view_faculty($list_id){

	    $query  = $this->db->select(['v2_faculty.*','category.category','category.category_code','class.class','class.class_code',
	        'subject.subject','subject.subject_code','master_user.first_name','master_user.last_name','master_user.email'])
	        ->from('v2_faculty')
	        ->join('category','v2_faculty.category_id=category.id')
	        ->join('class','v2_faculty.class_id=class.id')
	        ->join('subject','v2_faculty.subject_id=subject.id')
	        ->join('master_user','v2_faculty.teacher_id=master_user.id')
	         ->where('v2_faculty.id',$list_id)->get();
		return $query->row();
	}
	/* public function count_faculty($faculty){

		$query=$this->db->select(['*'])->from('v2_faculty')->where('faculty',$faculty)->get();
		return $query->num_rows();
	} */

	public function delete_faculty($list_id){

		$this->db->where('id', $list_id);
		$this->db->delete('v2_faculty');
	}
	public function count_faculty($category,$class,$subject,$teacher){
	    $query=$this->db->select(['*'])->from('v2_faculty')->where('category_id',$category)->where('class_id',$class)
	    ->where('subject_id',$subject)->where('teacher_id',$teacher)->get();
	    return $query->num_rows();
	}
	public function count_faculty_code($category,$class,$subject,$faculty_code){
	    $query=$this->db->select(['*'])->from('v2_faculty')->where('category_id',$category)->where('class_id',$class)
	    ->where('subject_id',$subject)->where('faculty_code',$faculty_code)->get();
	    return $query->num_rows();
	}
	public function teacher_lists(){
	    $query		=	  $this->db->select(['*'])->from('master_user')->where('category','1')
	    ->where('is_confirmed','1')->where('admin_approve','1')
	    ->order_by("id", "desc")->get();
	    $return 	= 	array();
	    if($query->num_rows() > 0) {
	        $return[''] = ('Select Teacher');
	        foreach($query->result_array() as $row) {
	            $return[$row['id']] = ucfirst($row['first_name']).' '.ucfirst($row['last_name'].' <img src="'.base_url($row["profile_image"]).'">'.' '.ucfirst($row['email']));
	        }
	    }
	    return $return;
	}
	public function search($data_taskpo){

	    $condition	=	$data_taskpo['seach_term'];
	    $order		=	$data_taskpo['order_by'];
		$sql		=
	    $query=$this->db->select(['v2_faculty.*','category.category','category.category_code','class.class','class.class_code',
		    'subject.subject','subject.subject_code','master_user.email'])
			->join('category','v2_faculty.category_id=category.id')
			->join('class','v2_faculty.class_id=class.id')
			->join('subject','v2_faculty.subject_id=subject.id')
			->join('master_user','v2_faculty.teacher_id=master_user.id')
	        ->from('v2_faculty');

			if($condition=='or' && !empty($order)){

	            if(!empty($data_taskpo['category'])){
	                $this->db->or_like('category.id',$data_taskpo['category'])->order_by('category.category',$order);
	            }

				if(!empty($data_taskpo['class_code'])){
	                $this->db->or_like('class.id', $data_taskpo['class'])
	                ->order_by('class.class',$order);
	            }

				if(!empty($data_taskpo['subject'])){
	                $this->db->or_like('subject.id', $data_taskpo['subject'])
	                ->order_by('subject.subject',$order);
	            }

				if(!empty($data_taskpo['subject_code'])){
					$ds1=explode(',',$data_taskpo['subject_code']);
	                $this->db->or_like('v2_faculty.category_id', $ds1[0]);
					$this->db->or_like('v2_faculty.class_id', $ds1[1]);
					$this->db->or_like('v2_faculty.subject_id',$ds1[2]);
	                $this->db->order_by('v2_faculty.id',$order);
	            }
	        }

	        if($condition=='or' && empty($order)){

	            if(!empty($data_taskpo['category'])){
	                $this->db->or_like('category.id', $data_taskpo['category']);
	            }

	            if(!empty($data_taskpo['class_code'])){
	                $this->db->or_like('class.id', $data_taskpo['class']);
	            }

				if(!empty($data_taskpo['subject'])){
	                $this->db->or_like('subject.id', $data_taskpo['subject']);
	            }
				if(!empty($data_taskpo['subject_code'])){
	                //$this->db->or_like('subject.id', $data_taskpo['subject_code']);
					$ds1=explode(',',$data_taskpo['subject_code']);
	                $this->db->or_like('v2_faculty.category_id', $ds1[0]);
					$this->db->or_like('v2_faculty.class_id', $ds1[1]);
					$this->db->or_like('v2_faculty.subject_id',$ds1[2]);
	            }



	        }

	        if($condition=='and' && !empty($order)){

	            if(!empty($data_taskpo['category']))	{
	                $this->db->like('category.id',$data_taskpo['category'])->order_by('category.category',$order);
	            }

				if(!empty($data_taskpo['class'])){
	                $this->db->like('class.id',$data_taskpo['class'])->order_by('class.class', $order);
	            }

				if(!empty($data_taskpo['subject'])){
	                $this->db->like('subject.id',$data_taskpo['subject'])->order_by('subject.subject', $order);
	            }
				if(!empty($data_taskpo['subject_code'])){
	                //$this->db->like('subject.id',$data_taskpo['subject_code'])->order_by('subject.subject_code', $order);
					$ds1=explode(',',$data_taskpo['subject_code']);
	                $this->db->like('v2_faculty.category_id', $ds1[0]);
					$this->db->like('v2_faculty.class_id', $ds1[1]);
					$this->db->like('v2_faculty.subject_id',$ds1[2]);
	                $this->db->order_by('v2_faculty.id',$order);
	            }

	        }

	        if($condition=='and' && empty($order)){

	            if(!empty($data_taskpo['category']))	{
	                $this->db->like('category.id',$data_taskpo['category']);
	            }

				if(!empty($data_taskpo['class_code']))		{
	                $this->db->like('class.id',$data_taskpo['class'])	;
	            }
				if(!empty($data_taskpo['subject']))		{
	                $this->db->like('subject.id',$data_taskpo['subject'])	;
	            }
				if(!empty($data_taskpo['subject_code']))		{
	               // $this->db->like('subject.id',$data_taskpo['subject_code'])	;
				   $ds1=explode(',',$data_taskpo['subject_code']);
	                $this->db->like('v2_faculty.category_id', $ds1[0]);
					$this->db->like('v2_faculty.class_id', $ds1[1]);
					$this->db->like('v2_faculty.subject_id',$ds1[2]);
	            }

	        }

	        $query=$this->db->get();
	        //echo $this->db->last_query();die;
	        if($query->num_rows()>0){
	            return $query->result();
	        }
	        else{
	            return $query->result();
	        }
	}

}
?>
