<?php defined('BASEPATH') or exit('No direct Access is Allowed'); ?>
<?php
class Classmodel extends CI_Model{

	public function __construct() {
        parent::__construct();
    }
	public function class_list($limit, $offset){
		
		$offset = ($offset-1)*$limit;
		$query  = $this->db->select(['class.*','category.category','category.category_code'])
		->from('class')->join('category','class.category_id=category.id')->limit($limit, $offset)->get();
		//echo $this->db->last_query();die;
		return $query->result();
	}
	
	
	public function class_code_lists(){
		  $query   =	 $this->db->select(['class.id','class.class','class.class_code','category.category',
		   'category.category_code'])
		  ->from('class')
		  ->join('category','category.id=class.category_id')->order_by("category.id", "asc")->get();
	    $return 	= 	array();
	    if($query->num_rows() > 0) {
	        $return[''] = ('Select class code');
	        foreach($query->result_array() as $row) {
	            $return[$row['id']] = strtoupper($row['category_code'].$row['class_code']);
	        }
	    }
	    return $return;
    }
	
	public function num_rows(){
	    $query  = $this->db->select(['class.*','category.category','category.category_code'])
	    ->from('class')->join('category','class.category_id=category.id')->get();
		return $query->num_rows();
	}
	public function insert_class($data_class){
	
		$this->db->insert('class', $data_class);
		$data_class['id'] = $this->db->insert_id();
    	return $data_class['id'];	
	}
	
	public function update_class($data_class,$list_id){
	
		$this->db->where('id',$list_id);
		$this->db->update('class', $data_class);
		return true;
	}
	
	public function view_class($list_id){
	
	    $query  = $this->db->select(['class.*','category.category','category.category_code'])
	    ->from('class')->join('category','class.category_id=category.id')->where('class.id',$list_id)->get();
		return $query->row();
	}
	public function count_class($category,$class){
	    $query=$this->db->select(['*'])->from('class')->where('category_id',$category)->where('class',$class)->get();
		return $query->num_rows();
	}
	public function count_class_code($category,$class_code){
	    $query=$this->db->select(['*'])->from('class')->where('category_id',$category)->where('class_code',$class_code)->get();
	    return $query->num_rows();
	}
	
	public function delete_class($list_id){
	
		$this->db->where('id', $list_id);
		$this->db->delete('class');
	}
	public function category1_lists(){
	    
	    $query		=	  $this->db->select(['id','category'])->from('category')->order_by("id", "desc")->get();
	    $return 	= 	array();
	    if($query->num_rows() > 0) {
	        $return[''] = ('Category');
	        foreach($query->result_array() as $row) {
	            $return[$row['id']] = strtoupper($row['category']);
	        }
	    }
	    return $return;
	}
	function getclass(){
	    $response = array();
	    // Select record
	    $this->db->select('*');
	    $q = $this->db->get('class');
	    $response = $q->result_array();
	    
	    return $response;
	}
	
	// Get City departments
	function get_class_subject($postData){
	    $response = array();
	    
	    // Select record
	    $this->db->select('id,subject');
	    $this->db->where('class_id', $postData['classes']);
	    $q = $this->db->get('subject');
	    $response = $q->result_array();
	    
	    return $response;
	}
	
	// Get Department user
	function get_class_subject_faculty($postData){
	    // echo "<pre>";print_r($postData['subject']);die;
	    $response     = array();
	    $this->db->select('*');
	    $this->db->where('subject_id', $postData['subject']);
	    $q            = $this->db->get('v2_faculty');
	    $response     = $q->result_array();
	    return $response;
	}
	public function search($data_taskpo){
	    
	    $condition	=	$data_taskpo['seach_term'];
	    $order		=	$data_taskpo['order_by'];
		$sql		= 
	    $query=$this->db->select(['class.*','category.category','category.category_code'])->join('category','category.id=class.category_id')
	        ->from('class'); 
			
	        
	        if($condition=='or' && !empty($order)){
	           
	            if(!empty($data_taskpo['class'])){
	                $this->db->or_like('class.id', $data_taskpo['class']);
	            }
			
				 if(!empty($data_taskpo['class_code'])){
	                $this->db->or_like('class.id', $data_taskpo['class_code'])
	                ->order_by('class.class_code',$order);
	            }
				
				 if(!empty($data_taskpo['category'])){
	                $this->db->or_like('category.id',$data_taskpo['category'])->order_by('category.category',$order);
	            }
				
	        }
	        
	        if($condition=='or' && empty($order)){
	            if(!empty($data_taskpo['class'])){
	                $this->db->or_like('class.id', $data_taskpo['class']);
	            }
				if(!empty($data_taskpo['class_code'])){
	                $this->db->or_like('class.id', $data_taskpo['class_code']);
	            }
				if(!empty($data_taskpo['category'])){
	                $this->db->or_like('category.id', $data_taskpo['category']);
	            }
				
	        }
	        
	        if($condition=='and' && !empty($order)){
	            
	           if(!empty($data_taskpo['class'])){
	                $this->db->like('class.id',$data_taskpo['class'])->order_by('class.class', $order);
	            }
	            if(!empty($data_taskpo['class_code'])){
	                $this->db->like('class.id',$data_taskpo['class_code'])->order_by('class.class_code', $order);
	            }
				
				if(!empty($data_taskpo['category']))	{
	                $this->db->like('category.id',$data_taskpo['category'])->order_by('category.category',$order);
	            }
	        }
	        
	        if($condition=='and' && empty($order)){
	           	           
				if(!empty($data_taskpo['class']))		{
	                $this->db->like('class.id',$data_taskpo['class'])	;
	            }  
				
	            if(!empty($data_taskpo['class_code']))		{
	                $this->db->like('class.id',$data_taskpo['class_code'])	;
	            }   
				if(!empty($data_taskpo['category']))	{
	                $this->db->like('category.id',$data_taskpo['category']);
	            }
 
	        }
	        
	        $query=$this->db->get();
			//echo $this->db->last_query();die;
	        if($query->num_rows()>0){
	            return $query->result();
	        }
	        else{
	            return $query->result();
	        }
	}
}
?>
