<?php defined('BASEPATH') or exit('No direct Access is Allowed'); ?>
<?php
class Chaptermodel extends CI_Model{

	public function __construct() {
        parent::__construct();
    }
	public function chapter_list($limit, $offset){
		
		$offset = ($offset-1)*$limit;
		$query  = $this->db->select(['chapter.*','category.category','category.category_code','class.class','class.class_code',
		'subject.subject','subject.subject_code'])
	    ->from('chapter')
		->join('category','chapter.category_id=category.id')
		->join('class','chapter.class_id=class.id')
		->join('subject','chapter.subject_id=subject.id')
		//->order_by("chapter", "asc")
    	->limit($limit, $offset)
		->get();
		//echo $this->db->last_query();die;
		return $query->result();
	}
	 public function chapter_code_lists(){
          $query		=	  $this->db->select(['chapter.id','chapter.chapter','chapter.chapter_code','category.category','category.category_code','class.class','class.class_code',
		'subject.subject','subject.subject_code'])
		  ->from('chapter')
		  ->join('category','chapter.category_id=category.id')
		  ->join('class','chapter.class_id=class.id')
		  ->join('subject','chapter.subject_id=subject.id')
		  ->order_by("category.id", "asc")->get();
		//echo "<pre>"; print_r($query->result_array());die;
		  
          $return 	= 	array();
          if($query->num_rows() > 0) {
              $return[''] = ('Select chapter code');
              foreach($query->result_array() as $row) {
                  $return[$row['id']] = strtoupper($row['category_code'].$row['class_code'].$row['subject_code'].$row['chapter_code']);
              }
          }
          return $return;
      }
	
	
	public function num_rows(){
	    $query  = $this->db->select(['chapter.*','category.category','category.category_code','class.class','class.class_code',
		'subject.subject','subject.subject_code'])
	    ->from('chapter')
		->join('category','chapter.category_id=category.id')
		->join('class','chapter.class_id=class.id')
		->join('subject','chapter.subject_id=subject.id')
		->get();
		return $query->num_rows();
	}

	public function insert_chapter($data_chapter){
	
		$this->db->insert('chapter', $data_chapter);
		$data_chapter['id'] = $this->db->insert_id();
		//echo $this->db->last_query();die;
    	return $data_chapter['id'];	
		
	}
	
	public function update_chapter($data_chapter,$list_id){
	
		$this->db->where('id',$list_id);
		$this->db->update('chapter', $data_chapter);
		return true;
	}
	
	public function view_chapter($list_id){
	
		$query=$this->db->select(['*'])->from('chapter')->where('id',$list_id)->get();
		return $query->row();
	}
	public function count_chapter($chapter){
	
		$query=$this->db->select(['*'])->from('chapter')->where('chapter',$chapter)->get();
		return $query->num_rows();
	}
	
	public function delete_chapter($list_id){
	
		$this->db->where('id', $list_id);
		$this->db->delete('chapter');
	}
	function getclass(){
	    $response = array();
	    // Select record
	    $this->db->select('*');
	    $q = $this->db->get('class');
	    $response = $q->result_array();
	    
	    return $response;
	}
	
	// Get City departments
	function get_class_subject($postData){
	    $response = array();
	    
	    // Select record
	    $this->db->select('id,subject');
	    $this->db->where('class_id', $postData['classes']);
	    $q = $this->db->get('subject');
	    $response = $q->result_array();
	    
	    return $response;
	}
	
	// Get Department user
	function get_class_subject_faculty($postData){
	    // echo "<pre>";print_r($postData['subject']);die;
	    $response     = array();
	    $this->db->select('*');
	    $this->db->where('subject_id', $postData['subject']);
	    $q            = $this->db->get('v2_faculty');
	    $response     = $q->result_array();
	    return $response;
	}
	public function subject_lists(){
	    $query		=	  $this->db->select(['id','subject'])->from('subject')->order_by("id", "desc")->get();
	    $return 	= 	array();
	    if($query->num_rows() > 0) {
	        $return[''] = ('Select subject');
	        foreach($query->result_array() as $row) {
	            $return[$row['id']] = strtoupper($row['subject']);
	        }
	    }
	    return $return;
	}
		public function search($data_taskpo){
	    
	    $condition	=	$data_taskpo['seach_term'];
	    $order		=	$data_taskpo['order_by'];
		$sql		= 
	    $query=$this->db->select(['chapter.*','category.category','category.category_code','class.class','class.class_code',
		'subject.subject','subject.subject_code'])
		->join('category','chapter.category_id=category.id')
		->join('class','chapter.class_id=class.id')
		->join('subject','chapter.subject_id=subject.id')
	      ->from('chapter'); 
			
	        
	        if($condition=='or' && !empty($order)){
	            
	             if(!empty($data_taskpo['category'])){
	                $this->db->or_like('category.id',$data_taskpo['category'])->order_by('category.category',$order);
	            }
	          
				if(!empty($data_taskpo['class'])){
	                $this->db->or_like('class.id', $data_taskpo['class'])
	                ->order_by('class.class',$order);
	            }
				
				if(!empty($data_taskpo['subject'])){
	                $this->db->or_like('subject.id', $data_taskpo['subject'])
	                ->order_by('subject.subject',$order);
	            }
				
				if(!empty($data_taskpo['chapter'])){
	                $this->db->or_like('chapter.id', $data_taskpo['chapter'])
	                ->order_by('chapter.chapter',$order);
	            }
				if(!empty($data_taskpo['chapter_code'])){
	                $this->db->or_like('chapter.id', $data_taskpo['chapter_code'])
	                ->order_by('chapter.chapter_code',$order);
	            }
	        }
	        
	        if($condition=='or' && empty($order)){
	            
	            if(!empty($data_taskpo['category'])){
	                $this->db->or_like('category.id', $data_taskpo['category']);
	            }
				
	            if(!empty($data_taskpo['class'])){
	                $this->db->or_like('class.id', $data_taskpo['class']);
	            }
				
				if(!empty($data_taskpo['subject'])){
	                $this->db->or_like('subject.subject', $data_taskpo['subject']);
	            }
				if(!empty($data_taskpo['chapter'])){
	                $this->db->or_like('chapter.id', $data_taskpo['chapter']);
	            }
				if(!empty($data_taskpo['chapter_code'])){
	                $this->db->or_like('chapter.id', $data_taskpo['chapter_code']);
	            }
	        }
	        
	        if($condition=='and' && !empty($order)){
	            
	            if(!empty($data_taskpo['category']))	{
	                $this->db->like('category.id',$data_taskpo['category'])->order_by('category.category',$order);
	            }
	           
				if(!empty($data_taskpo['class'])){
	                $this->db->like('class.id',$data_taskpo['class'])->order_by('class.class', $order);
	            }
				
				if(!empty($data_taskpo['subject'])){
	                $this->db->like('subject.id',$data_taskpo['subject'])->order_by('subject.subject', $order);
	            }
				if(!empty($data_taskpo['chapter'])){
	                $this->db->like('chapter.id',$data_taskpo['chapter'])->order_by('chapter.chapter', $order);
	            }
				if(!empty($data_taskpo['chapter_code'])){
	                $this->db->like('chapter.id',$data_taskpo['chapter_code'])->order_by('chapter.chapter_code', $order);
	            }
				
	        }
	        
	        if($condition=='and' && empty($order)){
	            
	            if(!empty($data_taskpo['category']))	{
	                $this->db->like('category.id',$data_taskpo['category']);
	            }
	           
				if(!empty($data_taskpo['class']))		{
	                $this->db->like('class.id',$data_taskpo['class'])	;
	            }  
				if(!empty($data_taskpo['subject']))		{
	                $this->db->like('subject.id',$data_taskpo['subject'])	;
	            }  
				if(!empty($data_taskpo['chapter']))		{
	                $this->db->like('chapter.id',$ddata_taskpo['chapter'])	;
	            }  
				if(!empty($data_taskpo['chapter_code']))		{
	                $this->db->like('chapter.id',$data_taskpo['chapter_code'])	;
	            }  
	        }
	        
	        $query=$this->db->get();
	        //echo $this->db->last_query();die;
	        if($query->num_rows()>0){
	            return $query->result();
	        }
	        else{
	            return $query->result();
	        }
	}
}
?>
