<?php defined("BASEPATH")or exit("NO DIRECT ACCESS IS ALLOWED"); ?>
<?php

class StudentModel extends CI_Model{
    protected $limit, $offset;
  public function __construct(){
    parent::__construct();
    date_default_timezone_set('Asia/Kolkata');
    //error_reporting(-1);
   // SET GLOBAL sql_mode=(SELECT REPLACE(@@sql_mode,'ONLY_FULL_GROUP_BY',''));
    ///echo $this->db->last_query();die;
    // echo "<pre>";print_r($query->row());die;
    /* select DATE_FORMAT(class_date,"%d-%M-%Y") from class_mgmt where class_date > DATE_SUB( NOW( ) , INTERVAL 31 DAY ) */
    // date_default_timezone_set('Asia/Kolkata');
    //$config['time_reference'] = 'gmt';# Default should be GMT
    //$this->db->simple_query('SET SESSION group_concat_max_len=100000');
  }
  public function class_remarks_update($v2_cs_stu_id,$class_id,$student_remarks_json){
    $this->db->set('remarks_student',$student_remarks_json);
    $this->db->where('id',$v2_cs_stu_id);
    $this->db->where('class_id',$class_id);
    $this->db->update('v2_course_student_data');
    return true;
  }
  public function class_remarks_data($v2_cs_stu_id,$class_id){
    $query  =  $this->db->select('remarks_student')->from('v2_course_student_data')->where('id',$v2_cs_stu_id)->where('class_id',$class_id)->get();
    $res    =  $query->row();
    //echo $this->db->last_query();die;
    return $res;
  }

  public function upcoming_classes_list($limit,$offset,$user_id){
    $array  = array('create','modify');
    $offset = ($offset-1)*$limit;
    $this->db->simple_query("SET time_zone='UTC+05:30'");
    $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url','st.remarks_student',
        'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
        '(select class from class where class.id=clsd.class_id)as class',
        '(select subject from subject where subject.id=clsd.subject_id)as subject',
        'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
        'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
        '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
        '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
        'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
        'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
        'clsd.course_id','(select concat(master_user.first_name," ",master_user.last_name) from master_user where master_user.id=(select v2_faculty.teacher_id from v2_faculty where v2_faculty.id=(select class_presenter from v2_course_presenter_data where st.class_id=v2_course_presenter_data.class_id))) as presenter'

    ])
    ->from('v2_course_student_data as st')
    ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
    ->where('attendee_id',$user_id)
    ->where('DATE(class_date) >= DATE_SUB(NOW(), INTERVAL +1 day)')
    ->where('class_date  < NOW() + INTERVAL 15 DAY')
    ->where_in('clsd.method',$array)
    ->order_by('DATE(clsd.class_date)','asc')
    ->order_by('TIME(clsd.class_start_time)','asc')
    ->limit($limit, $offset)->get();
    //echo $this->db->last_query();die;
    return $query->result();

  }
  public function upcoming_classes_num_row($user_id){
$array  = array('create','modify');
    $this->db->simple_query("SET time_zone='UTC+05:30'");
    $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url',
        'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
        '(select class from class where class.id=clsd.class_id)as class',
        '(select subject from subject where subject.id=clsd.subject_id)as subject',
        'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
        'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
        '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
        '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
        'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
        'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
        'clsd.course_id'
    ])
    ->from('v2_course_student_data as st')
    ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
    ->where('attendee_id',$user_id)
    ->where('DATE(class_date) >= DATE_SUB(NOW(), INTERVAL +1 day)')
    ->where('class_date  < NOW() + INTERVAL 15 DAY')
    ->where_in('clsd.method',$array)
    ->order_by('DATE(clsd.class_date)','asc')
    ->order_by('TIME(clsd.class_start_time)','asc')
    ->get();
    //echo $this->db->last_query();die;
    return $query->num_rows();

  }

  public function past_classes_list($limit,$offset,$user_id){
    $array  = array('create','modify');
    $offset = ($offset-1)*$limit;
    $this->db->simple_query("SET time_zone='UTC+05:30'");
    $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url','st.remarks_student',
        'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
        '(select class from class where class.id=clsd.class_id)as class',
        '(select subject from subject where subject.id=clsd.subject_id)as subject',
        'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
        'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
        '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
        '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
        'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
        'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
        'clsd.course_id','(select concat(master_user.first_name," ",master_user.last_name) from master_user where master_user.id=(select v2_faculty.teacher_id from v2_faculty where v2_faculty.id=(select class_presenter from v2_course_presenter_data where st.class_id=v2_course_presenter_data.class_id))) as presenter'

    ])
    ->from('v2_course_student_data as st')
    ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
    ->where('attendee_id',$user_id)
    ->where_in('clsd.method',$array)
    ->where('TIMESTAMP(class_date,class_start_time) <= NOW()')
  //  TIMESTAMP(`d`, `t`)
    //->where('class_date  > NOW() + INTERVAL 15 DAY')
    ->order_by('DATE(clsd.class_date)','desc')
    ->order_by('TIME(clsd.class_start_time)','desc')
    ->limit($limit, $offset)->get();
    //echo $this->db->last_query();die;
    return $query->result();

  }
  public function past_classes_num_row($user_id){
$array  = array('create','modify');
    $this->db->simple_query("SET time_zone='UTC+05:30'");
    $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url',
        'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
        '(select class from class where class.id=clsd.class_id)as class',
        '(select subject from subject where subject.id=clsd.subject_id)as subject',
        'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
        'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
        '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
        '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
        'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
        'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
        'clsd.course_id'
    ])
    ->from('v2_course_student_data as st')
    ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
    ->where('attendee_id',$user_id)
    ->where('TIMESTAMP(class_date,class_start_time) <= NOW()')
    ->where_in('clsd.method',$array)
    //->where('DATE(class_date) <= NOW()')
    //->where('class_date  > NOW() + INTERVAL 15 DAY')
    ->order_by('DATE(clsd.class_date)','desc')
    ->order_by('TIME(clsd.class_start_time)','desc')
    ->get();
    //echo $this->db->last_query();die;
    return $query->num_rows();

  }


  public function user_profile($ss_id){
        $id          =  substr($ss_id, 16);
        $hashtag     =  substr($ss_id, 0,16);
        $query       =  $this->db->select(['first_name','last_name','email','category','info','profile_image'])->from('master_user')
                        ->where('id',$id)->where('hashtag',$hashtag)->get();
        return $query->row();
  }

   public function student_info($userid){
  $query=$this->db->select(['master_user.*','mus.school_name',
  'mus.school_address','mus.parent_fname','mus.parent_lname','mus.parent_email',
  'mus.parent_mobile','mus.current_class' ,'mus.dob','mus.country as country_id','mus.state as state_id',
  'mus.city as city_id','mus.pin_code',
  '(select name from countries where countries.id=mus.country) as country',
  '(select name from cities where cities.id=mus.city) as city',
  '(select name from states where states.id=mus.state) as state'
    ])
    //id	user_id	school_name	school_address	parent_fname	parent_lname	parent_email	parent_mobile	current_class	dob	country	state	city	pin_code

    ->from('master_user')
    ->join('mu_student_info as mus','master_user.id=mus.user_id','left')
    ->where('master_user.id',$userid)
    ->get();
    //echo "<pre>";echo $this->db->last_query();die;
    return $query->row();
}

  public function program_offered_list($limit, $offset){
        $offset     =   ($offset-1)*$limit;
        $query      =   $this->db->select(['class.id','class.class','(select category from category where class.category_id=category.id)as category'])
                        ->from('class')->limit($limit, $offset)->get();
        return $query->result();
  }
  public function program_offered_list_num_rows(){
      $query        =   $this->db->select(['class.id','class.class','(select category from category where class.category_id=category.id)as category'])
                        ->from('class')->get();
      return $query->num_rows();
  }
  public function program_offered_subject_list_num_rows_count(){
      $query        =   $this->db->select(['subject.id'])
          ->from('subject')->join('class','subject.class_id=class.id')->join('category','subject.category_id=category.id')
          ->where("subject.category_id", '1')->get();
          return $query->num_rows();
  }
  public function program_offered_subject_list($limit, $offset,$program_id){
      $offset       =   ($offset-1)*$limit;
      $query        =   $this->db->select(['subject.id','subject.subject','subject.description','subject.class_id','subject.category_id',
                        'class.class','class.class_code',
                        'category.category','category.category_code','subject.subject_code'])
                        ->from('subject')->join('class','subject.class_id=class.id')->join('category','subject.category_id=category.id')
                        ->where("subject.class_id", $program_id)
                        ->limit($limit, $offset)->get();
      return $query->result();
  }

  public function program_offered_subject_list_num_rows($program_id){
      $query        =   $this->db->select(['subject.id','subject.subject','subject.description','subject.class_id','subject.category_id',
          'class.class','class.class_code',
          'category.category','category.category_code','subject.subject_code'])
                        ->from('subject')->join('class','subject.class_id=class.id')->join('category','subject.category_id=category.id')
                        ->where("subject.class_id", $program_id)->get();
      return $query->num_rows();
  }
  public function program_offered_subject_list_byid($program_id){
      $query        =   $this->db->select(['subject.id','subject.subject','subject.description','subject.class_id','subject.category_id',
                        'class.class','class.class_code',
                        'category.category','category.category_code','subject.subject_code'])
                        ->from('subject')->join('class','subject.class_id=class.id')->join('category','subject.category_id=category.id')
                        ->where("subject.class_id", $program_id)
                        ->get();
      return $query->result();
  }
  public function v2_student_request_program_chat_list_mnth($user_id,$month,$year,$classid){
      $query        =   $this->db->select(['pr.*','pr_chat.id as chat_id','pr_chat.request_program_id','pr_chat.user_message','pr_chat.admin_reply',
                        'pr_chat.user_msg_date','pr_chat.admin_reply_date','pr_chat.create_at as chat_create','pr_chat.update_at as chat_update'])
                        ->from('v2_student_request_program as pr')
                        ->join('v2_student_request_program_chat as pr_chat','pr_chat.request_program_id=pr.id')
                        ->where("pr.user_id", $user_id)
                        ->where("pr.month", $month)
                        ->where("pr.year", $year)
                        ->where("pr.class_id", $classid)
                        ->get();
                        //echo $this->db->last_query();die;
      return $query->result();
  }

  public function insert_v2_student_request_program($data){
      $this->db->insert('v2_student_request_program', $data);
      $data['id'] = $this->db->insert_id();
      return $data['id'];
  }
  public function insert_v2_student_request_program_chat($data){
      $this->db->insert('v2_student_request_program_chat', $data);
      $data['id'] = $this->db->insert_id();
      return $data['id'];
  }
  public function v2_student_request_program_chat_list($limit, $offset,$user_id){
      $offset       =   ($offset-1)*$limit;
      $query        =   $this->db->select(['pr.*',
          'class.class','category.category','subject.subject'])
          ->from('v2_student_request_program as pr')
          ->join('class','pr.class_id=class.id')
          ->join('category','pr.category_id=category.id')
          ->join('subject','pr.subject_id=subject.id')
          ->where("pr.user_id", $user_id)
          ->limit($limit, $offset)
          ->order_by('pr.id','desc')
          ->get();
          //   echo $this->db->last_query();die;
      return $query->result();
  }
  public function v2_student_request_program_chat_num_rows($user_id){
      $query        =   $this->db->select(['pr.*',
          'class.class','category.category','subject.subject'])
          ->from('v2_student_request_program as pr')
          ->join('class','pr.class_id=class.id')
          ->join('category','pr.category_id=category.id')
          ->join('subject','pr.subject_id=subject.id')
          ->where("pr.user_id", $user_id)
          ->order_by('pr.id','desc')
          ->get();
      return $query->num_rows();
  }
  public function chat_list_subject_($user_id,$request_program_id){
     $query        =   $this->db->select(['pr.*','pr_chat.id as chat_id','pr_chat.request_program_id','pr_chat.user_message','pr_chat.admin_reply',
       'pr_chat.user_msg_date','pr_chat.admin_reply_date','pr_chat.create_at as chat_create','pr_chat.update_at as chat_update',
       'class.class','category.category','subject.subject'])
       ->from('v2_student_request_program as pr')
       ->join('v2_student_request_program_chat as pr_chat','pr_chat.request_program_id=pr.id')
       ->join('class','pr.class_id=class.id')
       ->join('category','pr.category_id=category.id')
       ->join('subject','pr.subject_id=subject.id')
       ->where("pr.user_id", $user_id)
       ->where("pr.id", $request_program_id)

       ->limit($limit, $offset)
       ->order_by('pr.id','desc')
       ->get();
       return $query->result();
       //  echo $this->db->last_query();die;
  }

  public function course_enrolled_list($user_id,$limit, $offset){
      $offset = ($offset-1)*$limit;
$array  = array('create','modify');
      $this->db->simple_query('SET sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
      $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength',
          'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
          '(select class from class where class.id=clsd.class_id)as class',
          '(select subject from subject where subject.id=clsd.subject_id)as subject',
          'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
          'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
          '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
          '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
          'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
          'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
          'clsd.course_id'
      ])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->group_by('clsd.course_id')
      ->where_in('clsd.method',$array)
      ->order_by('clsd.class_date','asc')
      ->limit($limit, $offset)->get();
      //echo $this->db->last_query();die;
      return $query->result();
  }

  public function course_enrolled_list_num_rows($user_id){
    $array  = array('create','modify');
      $this->db->simple_query('SET sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
      $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength',
          'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
          '(select class from class where class.id=clsd.class_id)as class',
          '(select subject from subject where subject.id=clsd.subject_id)as subject',
          'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
          'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
          '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
          '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
          'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
          'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
          'clsd.course_id'
      ])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where_in('clsd.method',$array)
      ->group_by('clsd.course_id')
      ->order_by('clsd.class_date','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function course_enrolled_list_num_rows_running($user_id){
    $array  = array('create','modify');
      $this->db->simple_query('SET sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->join('v2_course_new as v2','v2.id=clsd.course_id')
      ->where('attendee_id',$user_id)
      ->where("DATE(v2.course_start_date)<=DATE(NOW())")
      ->where("DATE(v2.course_end_date)>=DATE(NOW())")
      ->where_in('clsd.method',$array)
      ->group_by('clsd.course_id')
      ->order_by('clsd.class_date','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function course_enrolled_list_num_rows_completed($user_id){
    $array  = array('create','modify');
      $this->db->simple_query('SET sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->join('v2_course_new as v2','v2.id=clsd.course_id')
      ->where('attendee_id',$user_id)
      ->where_in('clsd.method',$array)
      ->where("DATE(v2.course_end_date)<DATE(NOW())")
      ->group_by('clsd.course_id')
      ->order_by('clsd.class_date','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }

  public function course_enrolled_detail($limit,$offset,$user_id,$courseid){
      $offset = ($offset-1)*$limit;
      $array  = array('create','modify');
      $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url',
          'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
          '(select class from class where class.id=clsd.class_id)as class',
          '(select subject from subject where subject.id=clsd.subject_id)as subject',
          'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
          'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
          '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
          '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
          'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
          'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
          'clsd.course_id','(select concat(master_user.first_name," ",master_user.last_name) from master_user where master_user.id=(select v2_faculty.teacher_id from v2_faculty where v2_faculty.id=(select class_presenter from v2_course_presenter_data where st.class_id=v2_course_presenter_data.class_id))) as presenter'
      ])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where_in('clsd.method',$array)
      ->where('clsd.course_id',$courseid)
      ->order_by('clsd.class_date','asc')
      ->limit($limit, $offset)->get();
      //echo $this->db->last_query();die;
      return $query->result();
  }

  public function course_enrolled_detail_num_rows($user_id,$courseid){
    $array  = array('create','modify');
      $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url',
          'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
          '(select class from class where class.id=clsd.class_id)as class',
          '(select subject from subject where subject.id=clsd.subject_id)as subject',
          'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
          'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
          '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
          '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
          'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
          'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
          'clsd.course_id'
      ])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where_in('clsd.method',$array)
      ->where('clsd.course_id',$courseid)
      ->order_by('clsd.class_date','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function class_scheduled_list($user_id,$limit, $offset){
    $array  = array('create','modify');
      $offset = ($offset-1)*$limit;
      $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength',
          'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
          '(select class from class where class.id=clsd.class_id)as class',
          '(select subject from subject where subject.id=clsd.subject_id)as subject',
          'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
          'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
          '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
          '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
          'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
          'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
          'clsd.course_id'
      ])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where_in('clsd.method',$array)
      ->order_by('DATE(clsd.class_date)','asc')
      ->order_by('TIME(clsd.class_start_time)','asc')
      ->limit($limit, $offset)->get();
      //echo $this->db->last_query();die;
      return $query->result();
  }

  public function class_scheduled_list_num_rows($user_id){
    $array  = array('create','modify');
      $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength',
          'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
          '(select class from class where class.id=clsd.class_id)as class',
          '(select subject from subject where subject.id=clsd.subject_id)as subject',
          'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
          'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
          '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
          '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
          'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
          'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
          'clsd.course_id'
      ])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where_in('clsd.method',$array)
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }

  public function class_payment_list($payid){
        $offset = ($offset-1)*$limit;
        $query  = $this->db->select(['pay2.id','course_id',
            '(select course_start_date from v2_course_new where pay2.course_id=v2_course_new.id) as course_start_date',
            '(select course_end_date from v2_course_new where pay2.course_id=v2_course_new.id) as course_end_date',
            '(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id) as course_id_tag',
            '(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id)as course_id_tag',
            '(select CONCAT(first_name, " ", last_name) from master_user  where pay2.student_id=master_user.id) as student',
            '(select category from category where category.id=pay2.category_id)as category',
            '(select subject from subject where subject.id=pay2.subject_id)as subject',
            '(select class from class where class.id=pay2.class_id)as class','subject_code',
            'pay_detail.amount_recieved_from_st','pay_detail.mode_of_payment','pay_detail.payment_status',
            'pay_detail.no_of_class_alot','pay_detail.payment_recive_date',
			'(select per_class_amount*class_count from v2_course_new where pay2.course_id=v2_course_new.id)as total_course_amount',
			'(select total_course_amount - amount_recieved_from_st from v2_course_new where pay2.course_id=v2_course_new.id)as due_course_amount'

        ])
        ->from('v2_payment_course_student as pay2')->where('student_id',$payid)
        ->join('v2_payment_course_student_detail as pay_detail','pay2.id=pay_detail.pay_id')
        ->join('v2_course_presenter_data','v2_course_presenter_data.class_id=pay2.id')
        ->group_by('course_id')
        ->order_by("pay2.id","desc")->limit($limit, $offset)->get();
		//echo $this->db->last_query();die;
        return $query->result();

    }
    public function class_payment_list_num_rows(){
        $query  = $this->db->select(['pay2.id','(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id)as course_id_tag',
        '(select CONCAT(first_name, " ", last_name) from master_user  where pay2.student_id=master_user.id) as student',
        '(select category from category where category.id=pay2.category_id)as category',
        '(select subject from subject where subject.id=pay2.subject_id)as subject',
        '(select class from class where class.id=pay2.class_id)as class','subject_code',
        'pay_detail.amount_recieved_from_st','pay_detail.mode_of_payment','pay_detail.payment_status',
        'pay_detail.no_of_class_alot','pay_detail.payment_recive_date',
		'(select per_class_amount*class_count from v2_course_new where pay2.course_id=v2_course_new.id)as total_course_amount',
		'(select total_course_amount - amount_recieved_from_st from  v2_course_new where pay2.course_id=v2_course_new.id)as due_course_amount'
    ])
    ->from('v2_payment_course_student as pay2')
    ->join('v2_payment_course_student_detail as pay_detail','pay2.id=pay_detail.pay_id')
    ->order_by("pay2.id","desc")->get();
    //echo $this->db->last_query();die;
    return $query->num_rows();
    }


  public function total_class_today($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("DATE(clsd.class_date)=CURDATE()")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function total_class_today_remaining($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("TIME(clsd.class_end_time)>CURRENT_TIME()")
      ->where("DATE(clsd.class_date)=CURDATE()")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function total_class_today_completed($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("TIME(clsd.class_end_time)<CURRENT_TIME()")
      ->where("DATE(clsd.class_date)=CURDATE()")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }

  public function total_class_this_week($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("WEEKOFYEAR(clsd.class_date)= WEEKOFYEAR(NOW())")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function total_class_this_week_completed($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("WEEKOFYEAR(clsd.class_date)= WEEKOFYEAR(NOW())")
      ->where("TIME(clsd.class_end_time)<NOW()")
      ->where("DATE(clsd.class_date)<=CURDATE()")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function total_class_this_week_remaining($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("WEEKOFYEAR(clsd.class_date)= WEEKOFYEAR(NOW())")
      ->where("TIME(clsd.class_start_time)>NOW()")
      ->where("DATE(clsd.class_date)>=CURDATE()")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function total_class_next_week($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("WEEKOFYEAR(clsd.class_date)= WEEKOFYEAR(NOW())+1")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }


  public function total_class_this_month($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("MONTH(clsd.class_date)= MONTH(NOW())")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function total_class_this_month_completed($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("MONTH(clsd.class_date)= MONTH(NOW())")
      ->where("DATE(clsd.class_date)<CURDATE()")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function total_class_this_month_remaining($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("MONTH(clsd.class_date)= MONTH(NOW())")
      ->where("DATE(clsd.class_date)>=CURDATE()")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }

  public function total_class_next_month($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("MONTH(clsd.class_date)= MONTH(NOW())+1")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }
  public function total_class_this_year($user_id){
      $query  = $this->db->select(['st.id'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("YEAR(clsd.class_date)= YEAR(NOW())")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      ///echo $this->db->last_query();die;
      return $query->num_rows();
  }


  public function current_class_counter($user_id){
      $query  = $this->db->select(['clsd.class_date','clsd.class_start_time','clsd.class_end_time','st.attendee_url'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("DATE(clsd.class_date)=CURDATE()")
      ->where("TIME(clsd.class_end_time)>=CURRENT_TIME()")
      ->where("TIME(clsd.class_start_time)<=CURRENT_TIME()")
      ->order_by('DATE(clsd.class_date)','asc')
      ->get();
      // echo $this->db->last_query();die;
      return $query->row();
  }
  public function total_class_today_rows($user_id){
      $query  = $this->db->select(['clsd.id','clsd.class_date','clsd.class_start_time','clsd.class_end_time','st.attendee_url'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("DATE(clsd.class_date)=CURDATE()")
      ->where("TIME(clsd.class_end_time)>=CURRENT_TIME()")
      ->order_by('TIME(clsd.class_start_time)','asc')
      ->get();
      // echo $this->db->last_query();die;
      return $query->result();
  }
  public function current_class_rows($user_id){
      $query  = $this->db->select(['clsd.id','clsd.class_date','clsd.class_start_time','clsd.class_end_time','st.attendee_url'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("DATE(clsd.class_date)=CURDATE()")
      ->where("TIME(clsd.class_end_time)>=CURRENT_TIME()")
      ->order_by('TIME(clsd.class_start_time)','asc')
      ->limit('1')
      ->get();
      // echo $this->db->last_query();die;
      return $query->row();
  }
  public function next_class_rows($user_id){
      $query  = $this->db->select(['clsd.id','clsd.class_date','clsd.class_start_time','clsd.class_end_time','st.attendee_url'])
      ->from('v2_course_student_data as st')
      ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
      ->where('attendee_id',$user_id)
      ->where("DATE(clsd.class_date)=CURDATE()")
      ->where("TIME(clsd.class_start_time)>=CURRENT_TIME()")
      ->order_by('TIME(clsd.class_start_time)','asc')
      ->limit('1')
      ->get();
      //echo $this->db->last_query();die;
      return $query->row();
  }
  public function check_password($id){
    $query  = $this->db->select(['password'])
    ->from('master_user')
    ->where('id',$id)
    ->get();
    //echo $this->db->last_query();die;
    return $query->row();
  }
  public function update_password($id,$hash){
    $this->db->set('password',$hash);
    $this->db->where('id',$id);
    $this->db->update('master_user');
    //echo $this->db->last_query();die;
    return true;
  }

  public function subject_booked_list($ssid){
      $query  =   $this->db->select(['id','user_id','subject_id','request_date','is_see_by_admin','request_status'])
      ->from('st_class_request_list')->where("st_class_request_list.user_id", $ssid)->get();
      return $query->result();
  }
  public function count_course_total(){
      $query=$this->db->select(['id'])->from('course')->get();
      return $query->num_rows();
  }
  public function count_class_total(){
      $query=$this->db->select(['id'])->from('class')->get();
      return $query->num_rows();
  }

  public function complete_profile_student($id,$data_remarks){
		$this->db->where('id',$id);
		$this->db->set('info', $data_remarks);
        $this->db->update('master_user');
		return true;
	}
  public function update_profile_pic($id,$path){
  //  echo $id.$path;die;
      $this->db->set('profile_image', $path);
      $this->db->where('id', $id);
      $this->db->update('master_user');
      return true;
  }

  public function update_master_user($id,$array){
  //  echo $id.$path;die;
      $this->db->where('id', $id);
      $this->db->update('master_user',$array);
      return true;
  }
  public function find_duplicate_student_info($userid){
  //  echo $id.$path;die;

    $query =  $this->db->select('*')->from('mu_student_info')->where('user_id', $userid)->get();
    return  $query->num_rows();
  }
  public function update_extra_info($id,$array){

      $this->db->where('user_id', $id);
      $this->db->update('mu_student_info',$array);
      //echo $this->db->last_query();die;
      return true;
  }
  public function insert_extra_info($array){
      $this->db->insert('mu_student_info',$array);
      return $this->db->insert_id();
  }

  public function activity_list($limit, $offset){
		$offset = ($offset-1)*$limit;
		$query  = $this->db->select(['*'])->from('activity')
		//->order_by("activity", "asc")
    	->limit($limit, $offset)
		->get();
		//echo $this->db->last_query();die;
		return $query->result();
	}
	public function upcoming_class($user_id){
	    $date  =   date("Y-m-d");
	    //$start = date("Y-m-d", strtotime('+31 day' . $date));
	    //$this->db->query("SET time_zone='+5:30'");
	    $this->db->simple_query("SET time_zone='UTC+05:30'");
	       $sql="select in_course_enrolled.id,class_mgmt.id as classid,class_mgmt.class_id,in_course_enrolled.course_duration,
    class_date, course_time,course_end_time from in_course_enrolled join class_mgmt on in_course_enrolled.course_id=class_mgmt.course_id
    where DATE(class_date) >= DATE_SUB(NOW(), INTERVAL +1 day) and DATE_ADD(NOW(), INTERVAL +1 MONTH) and in_course_enrolled.user_id=$user_id
    order by DATE(class_date) asc ";
	     /* $sql="select in_course_enrolled.id,class_mgmt.id as classid,class_mgmt.class_id,in_course_enrolled.course_duration,class_date,
        course_time,course_end_time from in_course_enrolled join class_mgmt on in_course_enrolled.course_id=class_mgmt.course_id
        where DATE(class_date) >= NOW() and DATE_ADD(NOW(), INTERVAL +1 MONTH) and in_course_enrolled.user_id=5 order by DATE(class_date) asc";  */
	   /*  $sql="select in_course_enrolled.id,class_mgmt.id as classid,class_mgmt.class_id,in_course_enrolled.course_duration,class_date,course_time,course_end_time
        from in_course_enrolled join class_mgmt on in_course_enrolled.course_id=class_mgmt.course_id where DATE(class_date)
        BETWEEN NOW() AND NOW() + INTERVAL 31 DAY and in_course_enrolled.user_id=5 order by DATE(class_date) asc"; */
	   /*  $sql            =     "select in_course_enrolled.id,class_mgmt.id as classid,class_mgmt.class_id,in_course_enrolled.course_duration,class_date,course_time,course_end_time from in_course_enrolled join class_mgmt on
        in_course_enrolled.course_id=class_mgmt.course_id
        where DATE(class_date) BETWEEN NOW() - INTERVAL 30 DAY AND NOW() and in_course_enrolled.user_id=$user_id  order by DATE(class_date) asc ";
	     */
	   /*  $sql            =     "select in_course_enrolled.id,class_mgmt.id as classid,class_mgmt.class_id,in_course_enrolled.course_duration,class_date,course_time,course_end_time from in_course_enrolled join class_mgmt on
        in_course_enrolled.course_id=class_mgmt.course_id
        where DATE(class_date) > DATE(DATE_SUB( NOW( ) , INTERVAL 30 DAY )) and in_course_enrolled.user_id=$user_id  order by DATE(class_date) asc "; */
	    /* $sql            =     "select in_course_enrolled.id,class_mgmt.id as classid,class_mgmt.class_id,in_course_enrolled.course_duration,class_date,course_time,course_end_time from in_course_enrolled join class_mgmt on
        in_course_enrolled.course_id=class_mgmt.course_id
        where DATE(class_date) > DATE(DATE_SUB( NOW( ) , INTERVAL 30 DAY )) and in_course_enrolled.user_id=$user_id  order by DATE(class_date) asc "; */
	    $res  = $this->db->query($sql)->result();
	    //echo $this->db->last_query();die;
	    return $res;
	}
	public function count_upcoming_class($user_id){
	    $date  =   date("Y-m-d");
	    //$start = date("Y-m-d", strtotime('+31 day' . $date));
	    //$this->db->query("SET time_zone='+5:30'");
	    $this->db->simple_query("SET time_zone='UTC+05:30'");
	    $sql="select in_course_enrolled.id,class_mgmt.id as classid,class_mgmt.class_id,in_course_enrolled.course_duration,
    class_date, course_time,course_end_time from in_course_enrolled join class_mgmt on in_course_enrolled.course_id=class_mgmt.course_id
    where DATE(class_date) >= DATE_SUB(NOW(), INTERVAL +1 day) and DATE_ADD(NOW(), INTERVAL +1 MONTH) and in_course_enrolled.user_id=$user_id
    order by DATE(class_date) asc ";
	    $res  = $this->db->query($sql)->num_rows();
	    //echo $this->db->last_query();die;
	    return $res;
	}


	public function requested_course_status_list($limit, $offset,$user_id){
	    $offset = ($offset-1)*$limit;
	    $query  = $this->db->select(['id','request_date','is_see_by_admin','request_status',
	    '(select subject from subject where subject.id=st_class_request_list.subject_id)as subject',
	        '(select subject.id from subject where subject.id=st_class_request_list.subject_id)as subject_id',
	    '(select class.class from subject join class on class.id=subject.class_id where subject.id=st_class_request_list.subject_id )as class',
	        '(select class.id from subject join class on class.id=subject.class_id where subject.id=st_class_request_list.subject_id )as class_id'
	    ])
	    ->from('st_class_request_list')->where('user_id',$user_id)->where('st_class_request_list.request_status','1')->limit($limit, $offset)->get();
	        //echo $this->db->last_query();die;
	        return $query->result();
	}

	public function requested_course_status_list_num_rows($user_id){
	    $query  = $this->db->select(['id','request_date','is_see_by_admin','request_status',
	        '(select subject from subject where subject.id=st_class_request_list.subject_id)as subject',
	        '(select subject.id from subject where subject.id=st_class_request_list.subject_id)as subject_id',
	        '(select class.class from subject join class on class.id=subject.class_id where subject.id=st_class_request_list.subject_id )as class',
	        '(select class.id from subject join class on class.id=subject.class_id where subject.id=st_class_request_list.subject_id )as class_id'
	    ])
	    ->from('st_class_request_list')->where('user_id',$user_id)->where('st_class_request_list.request_status','1')->get();
	    //echo $this->db->last_query();die;
	    return $query->num_rows();
	}


	public function num_rows(){
	    $query=$this->db->select(['*'])->from('activity')->get();
	    return $query->num_rows();
	}
	public function insert_book_class($data){
		$this->db->insert('st_class_request_list', $data);
		$data['id'] = $this->db->insert_id();
    	return $data['id'];
	}
	public function fetch_book_class_detail_by_user($user_id){
	    $query=$this->db->select(['id','user_id','subject_id','request_date','is_see_by_admin','request_status'])->from('st_class_request_list')->where('user_id',$user_id)->get();
	    return $query->result_array();
	}
	public function book_duplicacy($user_id,$subject_id){
		$query=$this->db->select(['id'])->from('st_class_request_list')->where('user_id',$user_id)
			->where('subject_id',$subject_id)->get();
		return $query->num_rows();
	}
	public function unbook_class($user_id,$subject_id,$status){
	    $this->db->where('user_id', $user_id);
	    $this->db->where('subject_id', $subject_id);
	    $this->db->set('request_status',$status);
	    $this->db->update('st_class_request_list');
	    return true;
	}

	public function view_activity($list_id){
		$query=$this->db->select(['*'])->from('activity')->where('id',$list_id)->get();
		return $query->row();
	}
	public function count_activity($activity){
		$query=$this->db->select(['*'])->from('activity')->where('activity',$activity)->get();
		return $query->num_rows();
	}
	public function delete_activity($list_id){
		$this->db->where('id', $list_id);
		$this->db->delete('activity');
	}

  ############################################################################################
  public function chapter_lister(){
    $query=$this->db->select(['chapter.id','chapter.subject_id','chapter.chapter'])->from('chapter')
    //->join("topic", "topic.chapter_id=chapter.id",'left')
      ->limit($limit, $offset)
    ->get();//echo $this->db->last_query();die;
    return $query->result();
  }
  public function chapter_num_rows(){
		$query=$this->db->select(['*'])->from('chapter')->get();
		return $query->num_rows();
	}
	public function course_num_rows(){
		$query=$this->db->select(['*'])->from('course')->get();
		return $query->num_rows();
	}
	public function course_list($limit, $offset){
		$offset = ($offset-1)*$limit;
		$query=$this->db->select(['course.id','course.course_hash','(select subject from subject where subject.id=course.subject_id )as subject_id','(select class.class from subject join class on class.id=subject.class_id where subject.id=course.subject_id )as class_id','course.course_time','course_from','course_to','course_duration','extend_duration','course.student_count'])->from('course')//->order_by("activity", "asc")
    	->limit($limit, $offset)
		->get();//echo $this->db->last_query();die;
		return $query->result();
	}




  public function class_lists(){
    $query		=	  $this->db->select(['id','class'])->from('class')->order_by("id", "desc")->get();
    $return 	= 	array();
    if($query->num_rows() > 0) {
    $return[''] = ('Select Class');
      foreach($query->result_array() as $row) {
        $return[$row['id']] = strtoupper($row['class']);
      }
    }
        return $return;
  }
  public function subject_with_class_lists(){
    $query		=	  $this->db->select(['subject.id','subject','class'])->from('subject')->join('class','class.id=subject.class_id')->order_by("subject.id", "asc")->get();
    //echo $this->db->last_query();die;
    $return 	= 	array();
    if($query->num_rows() > 0) {
    $return[''] = ('Select Class-Subject');
      foreach($query->result_array() as $row) {
        $return[$row['id']] = $row['class']. '-' .$row['subject'];
      }
    }
        return $return;
  }
  public function subject_lists(){
    $query		=	  $this->db->select(['id','subject'])->from('subject')->order_by("id", "desc")->get();
    $return 	= 	array();
    if($query->num_rows() > 0) {
    $return[''] = ('Select subject');
      foreach($query->result_array() as $row) {
        $return[$row['id']] = strtoupper($row['subject']);
      }
    }
        return $return;
  }
  public function chapter_lists(){
    $query		=	  $this->db->select(['id','chapter'])->from('chapter')->order_by("id", "desc")->get();
    $return 	= 	array();
    if($query->num_rows() > 0) {
    $return[''] = ('Select chapter');
      foreach($query->result_array() as $row) {
        $return[$row['id']] = strtoupper($row['chapter']);
      }
    }
        return $return;
  }
  public function topic_lists(){
    $query		=	  $this->db->select(['id','topic'])->from('topic')->order_by("id", "desc")->get();
    $return 	= 	array();
    if($query->num_rows() > 0) {
    $return[''] = ('Select topic');
      foreach($query->result_array() as $row) {
        $return[$row['id']] = strtoupper($row['topic']);
      }
    }
        return $return;
  }

  public function getCountry($page){
    $offset = 10*$page;
    $limit = 10;
    $sql = "select * from countries limit $offset ,$limit";
    $result = $this->db->query($sql)->result();
    return $result;
  }
  //////////////////////////////
  public function get_class(){
    $query		=		$this->db->get('class');
    $result		= 	$query->result();
    $data			=		array();
    foreach($result as $r){
      $data['value']	=		$r->id;
      $data['label']	=		$r->class;
      $json[]					=		$data;
    }
    echo json_encode($json);
  }

  public function get_subject(){
      $result		=		$this->db->where('class_id',$_POST['id'])->get('subject')->result();
      $data			=		array();
    foreach($result as $r){
      $data['value']		=		$r->id;
      $data['label']		=		$r->subject;
      $json[]						=		$data;
    }
    echo json_encode($json);
  }

  public function get_chapter(){
      $result		=		$this->db->where('subject_id',$_POST['id'])->get('chapter')->result();
      $data			=		array();
    foreach($result as $r){
      $data['value']		=		$r->id;
      $data['label']		=		$r->chapter;
      $json[]						=		$data;
    }
    echo json_encode($json);
  }

  public function get_topic(){
      $result		=		$this->db->where('chapter_id',$_POST['id'])->get('topic')->result();
      $data			=		array();
    foreach($result as $r){
      $data['value']		=		$r->id;
      $data['label']		=		$r->topic;
      $json[]						=		$data;
    }
    echo json_encode($json);
  }
  ###########################################################################################
  function getcategory(){
    $response = array();
    $this->db->select('*')->where("id", '1');
    $q = $this->db->get('category');
   //echo $this->db->last_query();die;
    $response = $q->result_array();
    return $response;
}

function getclass(){
    $response = array();
    $this->db->select('*');
    $q = $this->db->get('class');
    $response = $q->result_array();
    return $response;
}
function get_category_class($postData){
    $response = array();
    $this->db->select('*');
    $this->db->where('category_id', $postData['category']);

    $q = $this->db->get('class');
    $response = $q->result_array();
    return $response;
}
function get_subject2(){
    $response = array();
    $q=$this->db->select(['*','(select class_code from class where class.id=subject.class_id)as class_code',
    '(select category_code from category where category.id=subject.category_id)as category_code'])->from('subject')->get();
    //$q = $this->db->get('subject');
  //  echo $this->db->last_query();die;
    $response = $q->result_array();
    //echo "<pre>";print_r($response);die;
    return $response;
}
function get_class_subject($postData){
    $response = array();
    $this->db->select('*');
    $this->db->where('class_id', $postData['classes']);
    $q = $this->db->get('subject');
    $response = $q->result_array();
    return $response;
}
// Get City departments
function get_subject_chapter($postData){
    $response = array();
    $this->db->select('*');
    $this->db->where('subject_id', $postData['subject']);
    $q = $this->db->get('chapter');
    $response = $q->result_array();
    return $response;
}
function get_chapter_topic($postData){
    $response = array();
    $this->db->select('*');
    $this->db->where('chapter_id', $postData['chapter']);
    $q = $this->db->get('topic');
    $response = $q->result_array();
    return $response;
}
function get_class_subject_course_maded_list($postData){
    // echo "<pre>";print_r($postData['subject']);die;
    $response     = array();
    $query  = $this->db->select(['v2_course_new.*','category.category','class.class','subject.subject'])
        ->from('v2_course_new')
        ->join('category','v2_course_new.category_id=category.id')
        ->join('class','v2_course_new.class_id=class.id')
        ->join('subject','v2_course_new.subject_id=subject.id')
        ->where('subject_id', $postData['subject'])->get();
        // $this->db->select('*');
        // $this->db->where('subject_id', $postData['subject']);
        //$q            = $this->db->get('v2_faculty');
        $response     = $query->result_array();
        return $response;
}

	public function subject_code_lists(){
		$query		=	  $this->db->select(['subject.id','subject.subject','subject.subject_code','class.class_code',
		'category.category_code'])
		->from('subject')
		->join('category','category.id=subject.category_id')
		->join('class','class.id=subject.class_id')
		->order_by("subject.id", "asc")->get();
	  //echo "<pre>"; print_r($query->result_array());die;

		$return 	= 	array();
		if($query->num_rows() > 0) {
			$return[''] = ('Select subject code');
			foreach($query->result_array() as $row) {
				$return[$row['id']] = strtoupper($row['category_code'].$row['class_code'].$row['subject_code']);
			}
		}
		return $return;
	}

	public function program_offered_search($data_taskpo){

			$query =   $this->db->select(['class.id','class.class','(select category from category where class.category_id=category.id) as category'])
                        ->from('class');

				if(!empty($data_taskpo['class'])){
					$this->db->where('class.id', $data_taskpo['class']);
				}

				if(!empty($data_taskpo['category'])){
					$this->db->where('class.category_id',$data_taskpo['category']);
				}

			$query=$this->db->get();
			//echo $this->db->last_query();die;
			if($query->num_rows()>0){
				return $query->result();
			}
			else{
				return $query->result();
			}
		}
    public function requested_course_status_list_search($data_taskpo){

	    $query=$this->db->select(['v2_student_request_program.*','category.category','class.class','subject.subject'])
		  ->join('category','category.id = v2_student_request_program.category_id')
          ->join('class','class.id = v2_student_request_program.class_id')
          ->join('subject','subject.id = v2_student_request_program.subject_id')
          ->from('v2_student_request_program');

        if(!empty($data_taskpo['category'])){
            $this->db->where('v2_student_request_program.category_id',$data_taskpo['category']);
        }
        if(!empty($data_taskpo['class'])){
            $this->db->where('v2_student_request_program.class_id', $data_taskpo['class']);
        }
        if(!empty($data_taskpo['subject'])){
            $this->db->where('v2_student_request_program.subject_id', $data_taskpo['subject']);
        }
        $query=$this->db->get();
        //echo $this->db->last_query();die;
        if($query->num_rows()>0){
            return $query->result();
        }
        else{
            return $query->result();
        }
    }

    public function requested_course_status_list_search2($subject_code1){
        $query=$this->db->select(['v2_student_request_program.*','category.category','class.class','subject.subject'])
        ->join('category','category.id = v2_student_request_program.category_id')
        ->join('class','class.id = v2_student_request_program.class_id')
        ->join('subject','subject.id = v2_student_request_program.subject_id')
        ->from('v2_student_request_program')->where('v2_student_request_program.subject_id',$subject_code1);
         //echo "<pre>"; print_r($query->result_array());die;
        $query=$this->db->get();
	     //echo $this->db->last_query();die;
	        if($query->num_rows()>0){
                return $query->result();
            }
            else{
	            return $query->result();
	        }

    }
    public function course_enrolled_list_search($data_taskpo){

	    $query=$this->db->select(['v2_course_new.*','category.category','class.class','subject.subject'])
		  ->join('category','category.id = v2_course_new.category_id')
          ->join('class','class.id = v2_course_new.class_id')
          ->join('subject','subject.id = v2_course_new.subject_id')
          ->from('v2_course_new');

        if(!empty($data_taskpo['category'])){
            $this->db->where('v2_course_new.category_id',$data_taskpo['category']);
        }
        if(!empty($data_taskpo['class'])){
            $this->db->where('v2_course_new.class_id', $data_taskpo['class']);
        }
        if(!empty($data_taskpo['subject'])){
            $this->db->where('v2_course_new.subject_id', $data_taskpo['subject']);
        }
        $query=$this->db->get();
        //echo $this->db->last_query();die;
        if($query->num_rows()>0){
            return $query->result();
        }
        else{
            return $query->result();
        }
    }

    public function course_enrolled_list_search2($user_id,$subject_code1){
        $query=$this->db->select(['v2_course_new.*','category.category','class.class','subject.subject'])
		  ->join('category','category.id = v2_course_new.category_id')
          ->join('class','class.id = v2_course_new.class_id')
          ->join('subject','subject.id = v2_course_new.subject_id')
          ->from('v2_course_new')->where('v2_course_new.subject_id',$subject_code1)
          ->where('v2_course_new.id',$user_id);
        //echo "<pre>"; print_r($query->result_array());die;
        $query=$this->db->get();
	   //echo $this->db->last_query();die;
	        if($query->num_rows()>0){
                return $query->result();
            }
            else{
	            return $query->result();
	        }

    }

public function payment_list_search($data_taskpo,$payid){

        $query  = $this->db->select(['pay2.id','course_id',
        '(select course_start_date from v2_course_new where pay2.course_id=v2_course_new.id) as course_start_date',
        '(select course_end_date from v2_course_new where pay2.course_id=v2_course_new.id) as course_end_date',
        '(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id) as course_id_tag',
        '(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id)as course_id_tag',
        '(select CONCAT(first_name, " ", last_name) from master_user  where pay2.student_id=master_user.id) as student',
        '(select category from category where category.id=pay2.category_id)as category',
        '(select subject from subject where subject.id=pay2.subject_id)as subject',
        '(select class from class where class.id=pay2.class_id)as class','subject_code',
        'pay_detail.amount_recieved_from_st','pay_detail.mode_of_payment','pay_detail.payment_status',
        'pay_detail.no_of_class_alot','pay_detail.payment_recive_date',
        '(select per_class_amount*class_count from v2_course_new where pay2.course_id=v2_course_new.id)as total_course_amount',
        '(select total_course_amount - amount_recieved_from_st from v2_course_new where pay2.course_id=v2_course_new.id)as due_course_amount'

         ])

        ->join('v2_payment_course_student_detail as pay_detail','pay2.id=pay_detail.pay_id')
        ->join('v2_course_presenter_data','v2_course_presenter_data.class_id=pay2.id')
        ->from('v2_payment_course_student as pay2')->where("category_id", '1')->where('student_id',$payid);

        if(!empty($data_taskpo['category'])){
            $this->db->where('pay2.category_id',$data_taskpo['category']);
        }
        if(!empty($data_taskpo['class'])){
            $this->db->where('pay2.class_id', $data_taskpo['class']);
        }
        if(!empty($data_taskpo['subject'])){
            $this->db->where('pay2.subject_id', $data_taskpo['subject']);
        }
        if(!empty($data_taskpo['course_id'])){
            $this->db->where('pay2.course_id', $data_taskpo['course_id']);
        }
        $query=$this->db->get();
        //echo $this->db->last_query();die;
        if($query->num_rows()>0){
            return $query->result();
        }
        else{
            return $query->result();
        }
    }
    public function payment_list_search2($subject_code1,$payid){
        $query  = $this->db->select(['pay2.id','course_id',
        '(select course_start_date from v2_course_new where pay2.course_id=v2_course_new.id) as course_start_date',
        '(select course_end_date from v2_course_new where pay2.course_id=v2_course_new.id) as course_end_date',
        '(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id) as course_id_tag',
        '(select course_id_tag from v2_course_new where pay2.course_id=v2_course_new.id)as course_id_tag',
        '(select CONCAT(first_name, " ", last_name) from master_user  where pay2.student_id=master_user.id) as student',
        '(select category from category where category.id=pay2.category_id)as category',
        '(select subject from subject where subject.id=pay2.subject_id)as subject',
        '(select class from class where class.id=pay2.class_id)as class','subject_code',
        'pay_detail.amount_recieved_from_st','pay_detail.mode_of_payment','pay_detail.payment_status',
        'pay_detail.no_of_class_alot','pay_detail.payment_recive_date',
        '(select per_class_amount*class_count from v2_course_new where pay2.course_id=v2_course_new.id)as total_course_amount',
        '(select total_course_amount - amount_recieved_from_st from v2_course_new where pay2.course_id=v2_course_new.id)as due_course_amount'

         ])

        ->join('v2_payment_course_student_detail as pay_detail','pay2.id=pay_detail.pay_id')
        ->join('v2_course_presenter_data','v2_course_presenter_data.class_id=pay2.id')
        ->from('v2_payment_course_student as pay2')->where('pay2.subject_id',$subject_code1)->where('student_id',$payid)->where("category_id", '1');

        //echo "<pre>"; print_r($query->result_array());die;
        $query=$this->db->get();
	   //echo $this->db->last_query();die;
	        if($query->num_rows()>0){
                return $query->result();
            }
            else{
	            return $query->result();
            }

    }

	 public function update_teacher_master($data_teacher_master,$user_id){
    $this->db->where('id',$user_id);
        $this->db->update('master_user', $data_teacher_master);
         //echo $this->db->last_query();die;
    return true;
  }

    public function update_teacher_basic($data_teacher_basic,$user_id){
    $this->db->where('user_id',$user_id);
        $this->db->update('student_extra_detail', $data_teacher_basic);
       //echo $this->db->last_query();die;
    return true;
  }


    public function current_class($user_id){
      $query  = $this->db->select(['v2_course_student_data.attendee_id','v2_course_class_detail.class_date', 'v2_course_class_detail.class_tag_id', 'v2_course_class_detail.class_start_time', 'v2_course_class_detail.class_end_time',
                                  'class.class_code','subject.subject'])
      ->from('v2_course_student_data')
      ->join('v2_course_class_detail', 'v2_course_class_detail.id = v2_course_student_data.class_id')
      ->join('class','v2_course_class_detail.class_id=class.id')
      ->join('subject','v2_course_class_detail.subject_id=subject.id')
      ->where("TIME(v2_course_class_detail.class_date) <= CURRENT_TIME() and attendee_id= 3")
      ->order_by('TIME(v2_course_class_detail.class_date)','desc')
      ->get();
      //echo $this->db->last_query();die;
      return $query->result();
    }

      public function professor_list($user_id){
        $query  = $this->db->select(['master_user.id','master_user.first_name','master_user.last_name','master_user.profile_image',
        '(select class from class where class.id=v2_faculty.class_id)as class',
        '(select subject from subject where subject.id=v2_faculty.subject_id) as subject' ])
        ->from('master_user')
        ->join('v2_faculty', 'v2_faculty.teacher_id = master_user.id')
        ->where("v2_faculty.teacher_id= $user_id")
        ->get();
        //  echo $this->db->last_query();die;
        return $query->result();
      }

      public function course_lists($user_id){
        $this->db->simple_query('SET sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
        $query  = $this->db->select(['v2_course_new.id','v2_course_new.faculty_code','v2_course_new.course_id_tag','v2_course_new.course_start_date','v2_course_new.course_end_date','master_user.first_name','master_user.last_name','v2_course_class_detail.class_strength',
                   '(select class from class where class.id=v2_course_new.class_id)as class',
                  '(select subject from subject where subject.id=v2_course_new.subject_id) as subject'
      ])
        ->from('v2_course_new')
        ->join('master_user', 'v2_course_new.faculty_code = master_user.id')
        ->join('v2_course_class_detail', 'v2_course_new.id = v2_course_class_detail.course_id')
        ->where("v2_course_new.faculty_code= $user_id")
        ->group_by('v2_course_new.id')
        ->get();
        //  echo $this->db->last_query();die;
        return $query->result();
      }

      public function course_enrolled_detail_api($user_id){

        $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url',
            'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
            '(select class from class where class.id=clsd.class_id)as class',
            '(select subject from subject where subject.id=clsd.subject_id)as subject',
            'clsd.subject_code','clsd.class_duration_min','clsd.class_end_time',
            'clsd.class_start_time','clsd.class_extend_time_min',
            '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
            '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
            'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
            'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
            'clsd.course_id'
        ])
        ->from('v2_course_student_data as st')
        ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
        ->where('attendee_id',$user_id)
        ->order_by('clsd.class_date','asc')->get();
        //echo $this->db->last_query();die;
        return $query->result();
    }
    public function upcoming_classes_search($data_taskpo){

        $condition	=	$data_taskpo['seach_term'];
        $order		  =	$data_taskpo['order_by'];
        //echo "<pre>";print_r($data_taskpo);die;

        $array  = array('create','modify');
        $offset = ($offset-1)*$limit;
        $this->db->simple_query("SET time_zone='UTC+05:30'");
        $this->db->simple_query('SET sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
        $query  = $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url','st.remarks_student',
            'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
            '(select class from class where class.id=clsd.class_id)as class',
            '(select subject from subject where subject.id=clsd.subject_id)as subject',
            'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
            'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
            '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
            '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
            'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
            'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
            'clsd.course_id','(select concat(master_user.first_name," ",master_user.last_name) from master_user where master_user.id=(select v2_faculty.teacher_id from v2_faculty where v2_faculty.id=(select class_presenter from v2_course_presenter_data where st.class_id=v2_course_presenter_data.class_id))) as presenter'

        ])
        ->from('v2_course_student_data as st')
        ->join('v2_course_class_detail as clsd','clsd.id=st.class_id')
        ->where('attendee_id',$user_id)
        ->where('DATE(class_date) >= DATE_SUB(NOW(), INTERVAL +1 day)')
        ->where('class_date  < NOW() + INTERVAL 30 DAY')
        ->where_in('clsd.method',$array);

        //->where('class_date  > NOW() + INTERVAL 15 DAY')
        //->order_by('DATE(clsd.class_date)','desc')
        //->order_by('TIME(clsd.class_start_time)','desc')

        if($condition=='or' && !empty($order)){
          if(!empty($data_taskpo['subject']))		{$this->db->or_like('clsd.subject_id',$data_taskpo['subject'])->order_by('clsd.subject_id',$order);}
          if(!empty($data_taskpo['date']))			{$this->db->or_where_in('clsd.class_date',$data_taskpo['date'])->order_by('date(clsd.class_date)',$order);}
        }

        if($condition=='or' && empty($order)){
          if(!empty($data_taskpo['subject']))		{$this->db->or_like('clsd.subject_id',$data_taskpo['subject']);}
          if(!empty($data_taskpo['date']))			{$this->db->or_where_in('clsd.class_date',$data_taskpo['date']);}
        }

        if($condition=='and' && !empty($order)){
          if(!empty($data_taskpo['subject']))		{$this->db->like('clsd.subject_id',$data_taskpo['subject'])->order_by('clsd.subject_id',$order);}
          if(!empty($data_taskpo['date']))			{$this->db->where_in('clsd.class_date',$data_taskpo['date'])->order_by('date(clsd.class_date)',$order);}
        }

        if($condition=='and' && empty($order)){
          if(!empty($data_taskpo['subject']))		{$this->db->like('clsd.subject_id',$data_taskpo['subject']);}
          if(!empty($data_taskpo['date']))			{$this->db->where_in('clsd.class_date',$data_taskpo['date']);}
        }
      //  $this->db->group_by('date(clsd.class_date)');
        $this->db->group_by('st.class_id');
          //$this->db->order_by('date(time)','asc');
        $query=$this->db->get();
        ///echo $this->db->last_query();die;
        if($query->num_rows()>0){
            return $query->result();
        }
        else{
            return $query->result();
        }
      }
    public function past_classes_search($data_taskpo){

    		$condition	=	$data_taskpo['seach_term'];
    		$order		  =	$data_taskpo['order_by'];

        $array  = array('create','modify');
        $offset = ($offset-1)*$limit;
        $this->db->simple_query("SET time_zone='UTC+05:30'");
        $this->db->simple_query('SET sql_mode=(SELECT REPLACE(@@sql_mode,"ONLY_FULL_GROUP_BY",""))');
       $this->db->select(['st.id','st.class_id','st.attendee_id','st.attendee_url','clsd.class_tag_id','clsd.class_strength','clsd.recording_url','st.remarks_student',
            'DATE_FORMAT(clsd.class_date,"%e-%M-%Y")as class_date','(select category from category where category.id=clsd.category_id)as category',
            '(select class from class where class.id=clsd.class_id)as class',
            '(select subject from subject where subject.id=clsd.subject_id)as subject',
            'clsd.subject_code','clsd.class_duration_min','TIME_FORMAT(clsd.class_end_time,"%h:%i %p")as class_end_time',
            'TIME_FORMAT(clsd.class_start_time,"%h:%i %p")as class_start_time','clsd.class_extend_time_min',
            '(select v2_course_new.course_id_tag from v2_course_new where clsd.course_id=v2_course_new.id)as course_id_tag',
            '(select v2_course_new.class_count from v2_course_new where clsd.course_id=v2_course_new.id)as class_count',
            'DATE_FORMAT((select v2_course_new.course_start_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_start_date',
            'DATE_FORMAT((select v2_course_new.course_end_date from v2_course_new where clsd.course_id=v2_course_new.id),"%e-%M-%Y")as course_end_date',
            'clsd.course_id','(select concat(master_user.first_name," ",master_user.last_name) from master_user where master_user.id=(select v2_faculty.teacher_id from v2_faculty where v2_faculty.id=(select class_presenter from v2_course_presenter_data where st.class_id=v2_course_presenter_data.class_id))) as presenter'

        ])
        ->from('v2_course_student_data as st')
        ->join('v2_course_class_detail as clsd','st.class_id=clsd.id','left')
        ->where('attendee_id',$user_id)
        ->where_in('clsd.method',$array)
        ->where('TIMESTAMP(class_date,class_start_time) <= NOW()');
        //->where('class_date  > NOW() + INTERVAL 15 DAY')
        //->order_by('DATE(clsd.class_date)','desc')
        //->order_by('TIME(clsd.class_start_time)','desc')

    		if($condition=='or' && !empty($order)){
    			if(!empty($data_taskpo['subject']))		{$this->db->or_like('clsd.subject_id',$data_taskpo['subject'])->order_by('clsd.subject_id',$order);}
    			if(!empty($data_taskpo['date']))			{$this->db->or_where_in('clsd.class_date',$data_taskpo['date'])->order_by('date(clsd.class_date)',$order);}
    		}

    		if($condition=='or' && empty($order)){
    			if(!empty($data_taskpo['subject']))		{$this->db->or_like('clsd.subject_id',$data_taskpo['subject']);}
    			if(!empty($data_taskpo['date']))			{$this->db->or_where_in('clsd.class_date',$data_taskpo['date']);}
    		}

    		if($condition=='and' && !empty($order)){
    			if(!empty($data_taskpo['subject']))		{$this->db->like('clsd.subject_id',$data_taskpo['subject'])->order_by('clsd.subject_id',$order);}
    			if(!empty($data_taskpo['date']))			{$this->db->where_in('clsd.class_date',$data_taskpo['date'])->order_by('date(clsd.class_date)',$order);}
    		}

    		if($condition=='and' && empty($order)){
    			if(!empty($data_taskpo['subject']))		{$this->db->like('clsd.subject_id',$data_taskpo['subject']);}
    			if(!empty($data_taskpo['date']))			{$this->db->where_in('clsd.class_date',$data_taskpo['date']);}
    		}
      //  $this->db->group_by('date(clsd.class_date)');
        $this->db->group_by('st.class_id');
    			//$this->db->order_by('date(time)','asc');
    		$query=$this->db->get();
    		///echo $this->db->last_query();die;
    		if($query->num_rows()>0){
    				return $query->result();
    		}
    		else{
    				return $query->result();
    		}
    	}

}
