<?php defined("BASEPATH")or exit("NO DIRECT ACCESS IS ALLOWED");?>
<?php
class Studentpayments extends MY_Controller{
    public function __construct(){
        parent::__construct();
        $this->load->model('admin/student_master/StudentpaymentsModel','studentpayments_model');
        $this->load->model('admin/Adminltemodel','adminlte_model');

        $this->load->library(['form_validation','bcrypt','email','session','pagination']);
        $this->load->helper(['html','form','url','security','string']);
        $this->load->model('CommonModel','common_model');
        //$this->load->model('AdminlteModel','adminlte_model');
        if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
        if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
        if($this->session->userdata('ss_id') ){return redirect('student/signin');}
        $list_id					=		$this->session->userdata('ad_id');
        $this->admin_data	        =		$this->adminlte_model->user_profile($list_id);

        //echo $this->session->userdata('ad_id');die;
        error_reporting(0);
        date_default_timezone_set('Asia/Kolkata');
    }
    public function index(){
        $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
        if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
        $config = [
            'base_url'					=>	site_url('admin/student_master/studentpayments/index'),
            'total_rows'				=>	$this->studentpayments_model->student_payments_list_num_rows(),
            'per_page'					=>	$perpage,
            'display_pages'			    =>	TRUE,
            'use_page_numbers'	        => 	TRUE,
            'uri_segment'				=>	5,
            'num_links'					=>	10,
            'page_query_string'         => 	FALSE,
            'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
            'full_tag_close'		    =>	"</ul>",
            'first_tag_open'		    =>	'<li>',
            'first_tag_close'		    =>	'</li>',
            'last_tag_open'			    =>	'<li>',
            'last_tag_close'		    =>	'</li>',
            'next_tag_open'			    =>	'<li>',
            'next_tag_close'		    =>	'</li>',
            'prev_tag_open'			    =>	'<li>',
            'prev_tag_close'		    =>	'</li>',
            'num_tag_open'			    =>	'<li>',
            'num_tag_close'			    =>	'</li>',
            'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
            'cur_tag_close'			    =>	'</a></li>',
        ];
        $this->pagination->initialize($config);
        $page 		=   ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
        $list 		=   $this->studentpayments_model->student_payments_list($config['per_page'],$page,$search);
        $links		=	$this->pagination->create_links();

        $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add category',
            'list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
        $this->load->view('adminlte/panel/sidebar');
        $this->load->view('adminlte/student_master/student_payment_info_course');
        $this->load->view('adminlte/panel/footer');
    }
    function student_payment_check_count(){
        $course_id			         =		strtolower($this->input->post('course_id'));
        $category_id	             =		strtolower($this->input->post('category'));
        $class_id			         =		strtolower($this->input->post('class'));
        $subject_id			         =		strtolower($this->input->post('subject'));
        $student			         =		strtolower($this->input->post('student'));
        $count 				         = 	    $this->studentpayments_model->student_payment_check_count($category_id,$class_id,$subject_id,$course_id,$student);
        if($count > 0){
            $this->form_validation->set_message('student_payment_check_count', 'The {field} field have already record you are enter,
                This person already Payed for this course');
            return FALSE;
        }
        else {
            return TRUE;
        }
    }
    public function create(){

        /* [category] => 1[class] => 1 [subject] => 4[course_id] => 2[per_class_amount] => 150[total_classes] => 2
        [full_course_amount] => 300[select_all] => Select All classes[class_select] =>
        [class_id_list] => Array ([0] => 17)
        [total_classes_remain] => 1[current_course_amount] => 150
        [student] => 5 [no_of_class_alot] => 1
        [amount_to_be_payed] => 150
        [amount_recieved_from_st] => 150 [coupon_code] => 4
        [payment_recive_date] => 05/30/2018
        [mode_of_payment] => paytm
        [payment_status] => partial */

        $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add category','menu_auth'=>$this->menu_auth]);
        $this->load->view('adminlte/panel/sidebar');
        $this->form_validation->set_error_delimiters('<p category="font-bold col-pink">', '</p>');
        $this->form_validation->set_rules('category'	                  , 'category'	        , 'required|xss_clean|trim');
        $this->form_validation->set_rules('class'                         , 'Class'	            , 'required|xss_clean|trim');
        $this->form_validation->set_rules('subject'	                      , 'Subject'	        , 'required|xss_clean|trim');
        $this->form_validation->set_rules('course_id'		              , 'Course Name'	    , 'required|xss_clean|trim');
        $this->form_validation->set_rules('student'		                  , 'Student'	        , 'required|xss_clean|trim');
        $this->form_validation->set_rules('amount_recieved_from_st'		  , 'Student fee'	    , 'required|xss_clean|trim');
        $this->form_validation->set_rules('mode_of_payment'		          , 'Mode of Payment'	, 'required|xss_clean|trim');
        $this->form_validation->set_rules('payment_status'		          , 'Payment Status'	, 'required|xss_clean|trim');
        $this->form_validation->set_rules('no_of_class_alot'		      , 'Classes Alotted'	, 'required|xss_clean|trim');
        $this->form_validation->set_rules('payment_recive_date'		      , 'Payment recieved date'	, 'required|xss_clean|trim');
        $this->form_validation->set_rules('per_class_amount'		      , 'per class amount'	, 'required|xss_clean|trim');

        $category                       =     $this->adminlte_model->getcategory();
        $student_lists                  =     $this->adminlte_model->student_lists();
        $coupon_lists                   =     $this->adminlte_model->coupon_lists();

        if($this->form_validation->run()==false){
            $this->load->view('adminlte/student_master/add_st_payments',['category'=>$category,'student'=>$student_lists,'coupon'=>$coupon_lists]);
        }
        else{
           // echo "<pre>";print_r($_POST);die;
            $dt 				         = 	    new DateTime();
            $course_id			         =		strtolower($this->input->post('course_id'));
            $category_id	             =		strtolower($this->input->post('category'));
            $class_id			         =		strtolower($this->input->post('class'));
            $subject_id			         =		strtolower($this->input->post('subject'));
            $student			         =		strtolower($this->input->post('student'));
            $amount_recieved_from_st     =		strtolower($this->input->post('amount_recieved_from_st'));
            $mode_of_payment			 =		strtolower($this->input->post('mode_of_payment'));
            $payment_status			     =		strtolower($this->input->post('payment_status'));
            $no_of_class_alot			 =		strtolower($this->input->post('no_of_class_alot'));
            $per_class_amount            =      strtolower($this->input->post('per_class_amount'));
            $payment_recive_date		 =		date('Y-m-d',strtotime($this->input->post('payment_recive_date')));

            $sub			             =		$this->studentpayments_model->subject_code_get($category_id,$class_id,$subject_id);

             $data_payment		         =		array('course_id'=>$course_id,'category_id'=>$category_id,'class_id'=>$class_id,
                'subject_id'=>$subject_id,'subject_code'=>$sub->category_code.$sub->class_code.$sub->subject_code,'student_id'=>$student
                 );
            $insert_id			         =		$this->studentpayments_model->insert_payment($data_payment);

            $data_payment_detail		 =		array('pay_id'=>$insert_id,'amount_recieved_from_st'=>$amount_recieved_from_st,
                'payment_recive_date'=>$payment_recive_date,
                'mode_of_payment'=>$mode_of_payment,'payment_status'=>$payment_status,'no_of_class_alot'=>$no_of_class_alot
            );
            $insert_pay_id			     =		$this->studentpayments_model->insert_payment_detail($data_payment_detail);

            $class_list                  =       $this->adminlte_model->class_list_for_courseid($course_id);
            //print_r($student_ls);die;
           // echo "<pre>";print_r($class_list);die;
           $d   =   1;
            foreach($class_list as $class){
                if($d>$no_of_class_alot){
                    break;
                }else{
                    require_once APPPATH. '/plugins/wiziq/classCode/AddAttendee.php';
                    $secretAcessKey					 =		"yOEQY4Y6HJG2Swp2CZ+q2A==";
                    $access_key						 =		"7DpOH0SG9m8=";
                    $webServiceUrl 				     =		"http://classapi.wiziqxt.com/apimanager.ashx";
                    $attendee 				    =	new AddAttendee();
                    $xml 						= 	new SimpleXMLElement('<attendee_list></attendee_list>');

                    $attendee_id			    =	  "<![CDATA[".$student."]]>";
                    $student_id				    =	  $this->adminlte_model->student_name($student);
                    $screen_name			    =	  "<![CDATA[".$student_id->first_name.' '.$student_id->last_name."]]>";
                    $language_culture_name	    =	  "<![CDATA["."en-us"."]]>";

                    $person                     =    $xml->addChild('attendee');
                    $person->addChild('attendee_id', "$attendee_id");
                    $person->addChild('screen_name', "$screen_name");
                    $person->addChild('language_culture_name', "$language_culture_name");

                    //print_r($xml->asXML());die;

                    $XMLAttendee1				=	str_replace('<?xml version="1.0"?>',"",$xml->asXML());
                    $XMLAttendee2				=	str_replace("&lt;","<",$XMLAttendee1);
                    $attendee->XMLAttendee	    =	str_replace("&gt;",">",$XMLAttendee2);
                   // print_r($attendee->XMLAttendee);die;
                    $attendee->class_id			=	trim($class->class_tag_id);//"386549";
                    $response2            	    = 	$attendee->InsertAttendee($secretAcessKey,$access_key,$webServiceUrl);
                    // $response3				    =   json_encode($response2);
                   // print_r($response2);

                    //$response['method'];
                    //$response['attendee_class_id'];
                    //$response['add_attendees_status'];
                    //$response['attendee_urls'];

                  foreach($response2['attendee_urls']as $data){
                     $test_url    =	explode("<=>",$data);

                     $att_data   = array('class_id'=>$class->id,'attendee_id'=>$test_url[0],'attendee_url'=>$test_url[1],

                         'payed_by_student'=>$per_class_amount);
                     $inse_id     = $this->adminlte_model->insert_v2_course_student_data($att_data);
                     $fetch_strength    =   $this->adminlte_model->fetch_class_strength_detail_respect_to_class($class->id);
                     $now_class_strength    =   $fetch_strength->class_strength+1;
                     $this->adminlte_model->update_v2_course_class_detail_34($class->id,$now_class_strength);
                     }

                //return redirect("master/Activity/edit/$insert_id");
                }
            $d++;
        }
       // die;
        $this->session->set_flashdata('message', "<i category='icon fa fa-check'></i>Payment Added Successfully");
       return redirect("admin/student_master/Studentpayments/index");
        }
        $this->load->view('adminlte/panel/footer');

    }
    public function approve($list_id) {
        $this->studentpayments_model->approve_apyment($list_id);
        $this->session->set_flashdata('message', "<i attendee='icon fa fa-check'></i>Payment Approve Successfully!");
        redirect('admin/student_master/studentpayments/index');
    }
    public function pay_detail_students($id){

        $data 		                = 	$this->studentpayments_model->student_payments_list_detail($id);

        $student                    =   strtoupper($data[0]->student);
        $course_id_tag              =   strtoupper($data[0]->course_id_tag);
        $category                   =   strtoupper($data[0]->category);
        $class                      =   strtoupper($data[0]->class);
        $subject                    =   strtoupper($data[0]->subject);
        $subject_code               =   strtoupper($data[0]->subject_code);
        $student_contact            =   strtoupper($data[0]->student_contact);

        $html	       =   "<h2>Chat History |  {$student} | {$course_id_tag} | {$category} | {$class} | {$subject} | {$subject_code}  | {$student_contact}</h2>
						<table id='example2' class='table table-bordered table-hover  table-responsive' style='font-family: sans-serif;font-size: 12px;'>
							<thead>
								<tr style='background-color: #428bca99 !important;color: #fff !important;'>
									<th>Amount recived</th>
									<th>Payment Mode</th>
									<th>Payment Status</th>
									<th>CLass ALot</th>
                                    <th>Pay Date</th>
                                    <th>Approved</th>
								</tr>
							</thead>
							<tbody style='height:50px;'>";
        foreach($data as $data1){
            $date1    =   date("d-M-Y",strtotime($data1->payment_recive_date));
            $html.="
					<tr>
						<td>{$data1->amount_recieved_from_st}</td>
						<td>{$data1->mode_of_payment}</td>
						<td>{$data1->payment_status}</td>
						<td>{$data1->no_of_class_alot}</td>
						<td>{$date1}</td>
                        <td>{$data1->approved}</td>
					</tr>
            ";
        }
        $html	.= "		</tbody>
						</table>
					";
        echo $html;
    }
}
