<?php defined("BASEPATH")or exit("NO DIRECT ACCESS IS ALLOWED");?>
<?php
class Studentinfo extends MY_Controller{
    public function __construct(){
        parent::__construct();
        $this->load->model('admin/student_master/StudentinfoModel','studentinfo_model');
        $this->load->model('admin/Adminltemodel','adminlte_model');

        $this->load->library(['form_validation','bcrypt','email','session','pagination']);
        $this->load->helper(['html','form','url','security','string']);
        $this->load->model('CommonModel','common_model');
        //$this->load->model('AdminlteModel','adminlte_model');
        if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
        if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
        if($this->session->userdata('ss_id') ){return redirect('student/signin');}
        $list_id					=		$this->session->userdata('ad_id');
        $this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
        //echo $this->session->userdata('ad_id');die;
        error_reporting(0);
        date_default_timezone_set('Asia/Kolkata');
    }
    public function index(){
        return redirect('admin/student_master/Studentinfo/student_query');
    }
    public function student_query(){
        $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
        if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
        $config = [
            'base_url'					=>	site_url('admin/student_master/Studentinfo/student_query'),
            'total_rows'				=>	$this->studentinfo_model->conversation_with_st_for_course_num_rows(),
            'per_page'					=>	$perpage,
            'display_pages'			    =>	TRUE,
            'use_page_numbers'	        => 	TRUE,
            'uri_segment'				=>	5,
            'num_links'					=>	10,
            'page_query_string'         => 	FALSE,
            'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
            'full_tag_close'		    =>	"</ul>",
            'first_tag_open'		    =>	'<li>',
            'first_tag_close'		    =>	'</li>',
            'last_tag_open'			    =>	'<li>',
            'last_tag_close'		    =>	'</li>',
            'next_tag_open'			    =>	'<li>',
            'next_tag_close'		    =>	'</li>',
            'prev_tag_open'			    =>	'<li>',
            'prev_tag_close'		    =>	'</li>',
            'num_tag_open'			    =>	'<li>',
            'num_tag_close'			    =>	'</li>',
            'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
            'cur_tag_close'			    =>	'</a></li>',
        ];
        $this->pagination->initialize($config);
        $page 		=   ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
        $list 		=   $this->studentinfo_model->conversation_with_st_for_course($config['per_page'],$page,$search);
        $links		=	$this->pagination->create_links();

        $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Conversation List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
        $this->load->view('adminlte/panel/sidebar');
        $this->load->view('adminlte/student_master/student_query_list');
        $this->load->view('adminlte/panel/footer');
    }
    public function student_query_chat_answer($program_request){
        $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
        if($this->input->post('perpage')==""){$perpage=50;}		else{$perpage		=	$this->input->post('perpage');}
        $config = [
            'base_url'					=>	site_url("admin/student_master/Studentinfo/student_query_chat_answer/{$program_request}"),
            'total_rows'				=>	$this->studentinfo_model->conversation_with_st_for_course_detail_num_rows($program_request),
            'per_page'					=>	$perpage,
            'display_pages'			    =>	TRUE,
            'use_page_numbers'	        => 	TRUE,
            'uri_segment'				=>	6,
            'num_links'					=>	10,
            'page_query_string'         => 	FALSE,
            'full_tag_open'			    =>	"<ul attendee='pagination pagination-sm'>",
            'full_tag_close'		    =>	"</ul>",
            'first_tag_open'		    =>	'<li>',
            'first_tag_close'		    =>	'</li>',
            'last_tag_open'			    =>	'<li>',
            'last_tag_close'		    =>	'</li>',
            'next_tag_open'			    =>	'<li>',
            'next_tag_close'		    =>	'</li>',
            'prev_tag_open'			    =>	'<li>',
            'prev_tag_close'		    =>	'</li>',
            'num_tag_open'			    =>	'<li>',
            'num_tag_close'			    =>	'</li>',
            'cur_tag_open'			    =>	'<li attendee="page-item active"><a attendee="page-link">',
            'cur_tag_close'			    =>	'</a></li>',
        ];
        $this->pagination->initialize($config);
        $page 		=   ($this->uri->segment(6)) ? $this->uri->segment(6) : 1;
        $list 		=   $this->studentinfo_model->conversation_with_st_for_course_detail($config['per_page'],$page,$program_request);
        $links		=	$this->pagination->create_links();

        $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Conversation List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
        $this->load->view('adminlte/panel/sidebar');
        $this->load->view('adminlte/student_master/student_query_list_chat_answer');
        $this->load->view('adminlte/panel/footer');
    }
    public function admin_reply_chat_user(){
     $pr_id         =   $this->input->post('pr_id');
     $id            =   $this->input->post('id');
     $admin_reply   =   $this->input->post('admin_reply');

     $this->studentinfo_model->update_admin_reply_to_user('admin_reply',$admin_reply,$id);
     $this->studentinfo_model->update_admin_reply_to_user('admin_reply_date',date('Y-m-d'),$id);

     return redirect("admin/student_master/Studentinfo/student_query_chat_answer/{$pr_id}");
    }
}
