<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Topic extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Topicmodel','topic_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');
		
		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		$this->load->model('AdminlteModel','adminlte_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}
	public function index(){
	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/topic_index'),
	        'total_rows'				=>	$this->topic_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'full_tag_open'			    =>	"<ul class='pagination pagination-sm no-margin'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		=   $this->topic_model->topic_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();
		$category        =      $this->adminlte_model->getcategory();
		$topic_code_lists  =  $this->topic_model->topic_code_lists();
		
		
		 $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'class List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->load->view('adminlte/master/topic/topic',['category'=>$category,'class'=>$class,'subject'=>$subject,'chapter'=>$chapter,'topic'=>$topic_lists,'topic_code'=>$topic_code_lists]);
	    $this->load->view('adminlte/panel/footer');
	}
	/// topic Check
	function topic_check($topic){
	    $activity			=	str_replace(" ","-",$topic);
	    $count 				= 	$this->topic_model->count_topic($topic);
	    if($count > 0){
	        $this->form_validation->set_message('topic_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	///create
	public function create(){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Activity','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('category'			, 'category'    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('class'				, 'class'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('subject'				, 'subject'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('chapter'				, 'chapter'		, 'required|xss_clean|trim');
	    $this->form_validation->set_rules('topic'			    , 'topic'	    , 'required|xss_clean|callback_topic_check');
		 $this->form_validation->set_rules('topic_code'			, 'topic_code'	, 'required|xss_clean');
	    $this->form_validation->set_rules('description'		    , 'Description'	, 'required|xss_clean');
	    $category                 =       $this->adminlte_model->getcategory();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/topic/add_topic',['category'=>$category]);
	    }
	    else{
	        $dt 				= 	new DateTime();
	        $response 			= 	array('Status'=>$this->input->post('status'),'CreateBy'=>ucfirst($create->fname)." ".ucfirst($create->lname),
	            'Created'=>$dt->format('Y-m-d H:i:s'),'UpdateBy'=>"","Updated"=>"");
	        
	        $category			=		strtolower(trim($this->input->post('category')));
			$class				=		strtolower(trim($this->input->post('class')));
	        $subject			=		strtolower(trim($this->input->post('subject')));
			$chapter			=		strtolower(trim($this->input->post('chapter')));
			$topic				=		strtolower(str_replace(" ","-",trim($this->input->post('topic'))));
			$topic_code			=		strtolower(trim($this->input->post('topic_code')));
			$description		=		strtolower(trim($this->input->post('description')));
			$data_topic			=		array('topic'=>$topic,'topic_code'=>$topic_code,'description'=>$description,'chapter_id'=>$chapter,'subject_id'=>$subject,'class_id'=>$class,'category_id'=>$category);
	        $insert_id			=		$this->topic_model->insert_topic($data_topic);
	        
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>topic Added Successfully");
	        return redirect("admin/master/topic/index");
	        //return redirect("master/Activity/edit/$insert_id");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit topic','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	     =	  $this->topic_model->view_topic($list_id);
	    $this->form_validation->set_error_delimiters('<p topic="text-red">', '</p>');
	    $this->form_validation->set_rules('topic'					, 'topic'				, 'required|xss_clean');
	    $this->form_validation->set_rules('description'		        , 'Description'	        , 'required|xss_clean');
	    $this->form_validation->set_rules('chapter'				    , 'Chapter'	            , 'required|xss_clean');
	    $chapter     =   $this->topic_model->chapter_lists();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/topic/edit_topic',['list'=>$list,'chapter'=>$chapter]);
	    }
	    else{
	        $dt 			    = 	new DateTime();
	        $topic				=	strtolower(str_replace(" ","-",trim($this->input->post('topic'))));
	        $description		=	strtolower(trim($this->input->post('description')));
	        $chapter			=	strtolower(trim($this->input->post('chapter')));
	        $data_topic			=	array('topic'=>$topic,'description'=>$description,'chapter_id'=>$chapter);
	        
	        $this->topic_model->update_topic($data_topic,$list_id);
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>topic Updated Successfully");
	        return redirect("admin/master/topic/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View Topic','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $chapter     =   $this->topic_model->chapter_lists();
	    $list=$this->topic_model->view_topic($list_id);
	    $this->load->view('adminlte/master/topic/view_topic',['list'=>$list,'chapter'=>$chapter]);
	    $this->load->view('adminlte/panel/footer');
	}
	//////delete
	public function delete($list_id) {
	    $this->topic_model->delete_topic($list_id);
	    $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Topic Successfully Deleted!");
	    redirect('admin/master/topic/index');
	}
	public function get_class_subject(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject($postData);
	    echo json_encode($data);
	}
	
	public function get_class_subject_faculty(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject_faculty($postData);
	    echo json_encode($data);
	}
	public function class_id_view($class_id){
	    $query  = $this->db->select(['*','(select subject from subject where subject.id=subject_id)as subject',
	        '(select class from class where class.id=v2_course_class_detail.class_id)as class'])
	        ->from('v2_course_class_detail')
	        ->join('v2_course_presenter_data','v2_course_presenter_data.class_id=v2_course_class_detail.id')
	        ->where('v2_course_class_detail.class_tag_id',$class_id)
	        ->order_by("v2_course_class_detail.id","desc")->get();
	        //'(select faculty_code from v2_faculty where v2_faculty.id=v2_course_presenter_data.class_presenter)as faculty'
	        return $query->row();
	}
	public function search(){
	//print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
			'class'		   	   =>  strtolower(trim($this->input->post('class'))),
	        'subject'          =>  strtolower(trim($this->input->post('subject'))),
			'chapter'          =>  strtolower(trim($this->input->post('chapter'))),
			'topic'            =>  strtolower(trim($this->input->post('topic'))),
			'topic_code'       =>  strtolower(trim($this->input->post('topic_code'))),
	        'order_by'		   =>  strtolower(trim($this->input->post('order_by'))),
	        'seach_term'	   =>  strtolower(trim($this->input->post('seach_term')))
	    );
	    if(
	        (
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) || 
	            (isset($data_taskpo['class'])	    && !empty($data_taskpo['class'])) ||
				(isset($data_taskpo['subject']) 	&& !empty($data_taskpo['subject'])) ||
				(isset($data_taskpo['chapter'])	    && !empty($data_taskpo['chapter'])) ||
				(isset($data_taskpo['topic'])       && !empty($data_taskpo['topic'])) ||
				(isset($data_taskpo['topic_code'])  && !empty($data_taskpo['topic_code']))
	        )
	        &&(
	            (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	|| (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))
	            )
	        ){
	            
				$list         =	$this->topic_model->search($data_taskpo);
	            $category        =      $this->adminlte_model->getcategory();
				$topic_code_lists  =  $this->topic_model->topic_code_lists();
				
	            $links=''; 
	            
	            $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'category List','list'=>$list,
	                'link'=>$links,'menu_auth'=>$this->menu_auth]);
	            $this->load->view('adminlte/panel/sidebar');
	            //$this->load->view('adminlte/master/subject/subject',['category'=>$category,'data_taskpo'=>$data_taskpo]);
				$this->load->view('adminlte/master/topic/topic',['category'=>$category,'class'=>$class,'subject'=>$subject,'chapter'=>$chapter,'topic'=>$topic_lists,'topic_code'=>$topic_code_lists,'data_taskpo'=>$data_taskpo]);
	            $this->load->view('adminlte/panel/footer');
	    }
	    else{
	        return redirect('admin/master/topic');
	    }
	}
}
?>
