<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Subject extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Subjectmodel','subject_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');
		
		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		$this->load->model('AdminlteModel','adminlte_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}
	public function index(){
	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/subject/index'),
	        'total_rows'				=>	$this->subject_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'full_tag_open'			    =>	"<ul class='pagination pagination-sm no-margin'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		=   $this->subject_model->subject_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();
		$category        =      $this->adminlte_model->getcategory();
		//$subject  =         $this->subject_model->subject_lists1();
		$subject_code  =         $this->subject_model->subject_code_lists();
		
	    
	      $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,
		'title'=>'subject List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->load->view('adminlte/master/subject/subject',['category'=>$category,'class'=>$class,
		'subject'=>$subject,'subject_code'=>$subject_code]);
	    $this->load->view('adminlte/panel/footer');
	}
	/// subject Check
	function subject_check(){
	    $category			=	strtolower(trim($this->input->post('category')));
	    $class              =   trim($this->input->post('class'));
	    $subject		    =	strtolower(str_replace(" ","-",trim($this->input->post('subject'))));
	    $count 				= 	$this->subject_model->count_subject($category,$class,$subject);
	    if($count > 0){
	        $this->form_validation->set_message('subject_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	function subject_code_check(){
	    $category			=	strtolower(trim($this->input->post('category')));
	    $class              =   trim($this->input->post('class'));
	    $subject_code		=	strtolower(trim($this->input->post('subject_code')));
	    $count 				= 	$this->subject_model->count_subject_code($category,$class,$subject_code);
	    if($count > 0){
	        $this->form_validation->set_message('subject_code_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	///create
	public function create(){
	    //echo "<pre>";print_r($_POST);die;
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Subject','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('category'			, 'category', 'required|xss_clean|trim');
	    $this->form_validation->set_rules('class'				, 'class'	, 'required|xss_clean|trim');
	    $this->form_validation->set_rules('subject'				, 'subject'	, 'required|xss_clean|trim|callback_subject_check');
	    $this->form_validation->set_rules('subject_code'		, 'subject code'	, 'required|xss_clean|trim|callback_subject_code_check');
	    $this->form_validation->set_rules('description'			, 'Status'	, 'required|xss_clean|trim');
	    //$class =   $this->subject_model->class_lists();
	    //$class                                  =       $this->subject_model->getclass();
	    $category                                  =       $this->adminlte_model->getcategory();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/subject/add_subject',['category'=>$category]);
	    }
	    else{
	        $dt 					= 	    new DateTime();
	        $category				=		strtolower(trim($this->input->post('category')));
	        $class				    =		strtolower(trim($this->input->post('class')));
	        $subject				=		strtolower(str_replace(" ","-",trim($this->input->post('subject'))));
	        $subject_code		    =		strtolower(trim($this->input->post('subject_code')));
	        $description		    =		strtolower(trim($this->input->post('description')));
	        
	        $data_subject			=		array('category_id'=>$category,'class_id'=>$class,'subject'=>$subject,
	            'subject_code'=>$subject_code,'description'=>$description,'status'=>$status,
	            'create_by'=>$this->session->userdata('ad_id'));
	        $insert_id				=		$this->subject_model->insert_subject($data_subject);
	        
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>subject Added Successfully");
	        return redirect("admin/master/subject/index");
	        //return redirect("master/Activity/edit/$insert_id");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit subject','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	=	$this->subject_model->view_subject($list_id);
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    //$this->form_validation->set_rules('category'					, 'category'	    , 'required|xss_clean|trim');
	    //$this->form_validation->set_rules('class'					, 'class'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('description'		        , 'Description'	        , 'required|xss_clean');
	    $this->form_validation->set_rules('status'		            , 'Status'	            , 'required|xss_clean|trim');
	    //$class =   $this->subject_model->class_lists();
	    $category                                  =       $this->adminlte_model->getcategory();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/subject/edit_subject',['list'=>$list,'category'=>$category]);
	    }
	    else{
	        $dt 				= 	  new DateTime();
	        //$subject			=     strtolower(str_replace(" ","-",trim($this->input->post('subject'))));
	        $description		=	  strtolower(trim($this->input->post('description')));
	        $status		        =	  strtolower(trim($this->input->post('status')));
	        $data_subject	    =	  array( 'description'=>$description,
	            'status'=>$status,'update_by'=>$this->session->userdata('ad_id'));
	        
	        $this->subject_model->update_subject($data_subject,$list_id);
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>subject Updated Successfully");
	        return redirect("admin/master/subject/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View Subject','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list  =   $this->subject_model->view_subject($list_id);
	    //$class =   $this->subject_model->class_lists();
	    $category                                  =       $this->adminlte_model->getcategory();
	    $this->load->view('adminlte/master/subject/view_subject',['list'=>$list,'category'=>$category]);
	    $this->load->view('adminlte/panel/footer');;
	}
	//////delete
	public function delete($list_id) {
	    $this->subject_model->delete_subject($list_id);
	    $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Subject Successfully Deleted!");
	    redirect('admin/master/subject/index');
	}
	public function get_class_subject(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject($postData);
	    echo json_encode($data);
	}
	
	public function get_class_subject_faculty(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject_faculty($postData);
	    echo json_encode($data);
	}
	public function search(){
	//print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
			'class'		   	   =>  strtolower(trim($this->input->post('class'))),
	        'subject'       =>  strtolower(trim($this->input->post('subject'))),
			'subject_code'       =>  strtolower(trim($this->input->post('subject_code'))),
	        'order_by'		   =>  strtolower(trim($this->input->post('order_by'))),
	        'seach_term'	   =>  strtolower(trim($this->input->post('seach_term')))
	    );
	    if(
	        (
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) || 
	            (isset($data_taskpo['class'])	&& !empty($data_taskpo['class'])) ||
				(isset($data_taskpo['subject'])	&& !empty($data_taskpo['subject'])) ||
				(isset($data_taskpo['subject_code'])	&& !empty($data_taskpo['subject_code']))


	        )
	        &&(
	            (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	|| (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))
	            )
	        ){
	            
				$list         =	$this->subject_model->search($data_taskpo);
				$category        =      $this->adminlte_model->getcategory();
				$subject_code  =      $this->subject_model->subject_code_lists();
	           
	            $links=''; 
	            
	            $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'category List','list'=>$list,
	                'link'=>$links,'menu_auth'=>$this->menu_auth]);
	            $this->load->view('adminlte/panel/sidebar');
	            //$this->load->view('adminlte/master/subject/subject',['category'=>$category,'data_taskpo'=>$data_taskpo]);
				$this->load->view('adminlte/master/subject/subject',['category'=>$category,'class'=>$class,'subject'=>$subject,'subject_code'=>$subject_code,'data_taskpo'=>$data_taskpo]);
	            $this->load->view('adminlte/panel/footer');
	    }
	    else{
	        return redirect('admin/master/Subject');
	    }
	}
}
?>
