<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Presenter extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Presentermodel','presenter_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');

		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		//$this->load->model('AdminlteModel','adminlte_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}

	public function index(){

	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/presenter/index'),
	        'total_rows'				=>	$this->presenter_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'page_query_string'         => 	FALSE,
	        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		= $this->presenter_model->presenter_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();

	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'presenter List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->load->view('adminlte/master/presenter/presenter');
	    $this->load->view('adminlte/panel/footer');
	}
	/// presenter Check
	function presenter_check(){
	    $email	            =		strtolower(trim($this->input->post('email')));
	    $count 				= 	    $this->presenter_model->count_presenter($email);
	    if($count > 0){
	        $this->form_validation->set_message('presenter_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}

	///create
	public function create(){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add presenter','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('email'	      , 'Email'	        , 'required|xss_clean|trim|callback_presenter_check');
	    $this->form_validation->set_rules('first_name'    , 'First Name'	, 'required|xss_clean|trim');
	    $this->form_validation->set_rules('last_name'	  , 'Last Name'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('mobile'		  , 'Mobile'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('gender'		  , 'Gender'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('is_confirmed'  , 'Email Verification'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('admin_approve' , 'Admin Account Approval'	    , 'required|xss_clean|trim');

	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/presenter/add_presenter');
	    }
	    else{
	        //print_r($_POST);die;
	        $dt 				= 	    new DateTime();
	        $email			    =		strtolower(trim($this->input->post('email')));
	        $first_name	        =		strtolower(trim($this->input->post('first_name')));
	        $last_name			=		strtolower(trim($this->input->post('last_name')));
	        $gender		        =		strtolower(trim($this->input->post('gender')));
	        $mobile		        =		strtolower(trim($this->input->post('mobile')));
	        $is_confirmed		=		strtolower(trim($this->input->post('is_confirmed')));
	        $admin_approve		=		strtolower(trim($this->input->post('admin_approve')));
	        $hashtag		    =		random_string('alnum', 16);

	        $password           =       random_string('alnum',10);
	        $hash               =       $this->bcrypt->hash_password($password);

	        $data_presenter		=		array('email'=>$email,'first_name'=>$first_name,'last_name'=>$last_name,
	            'gender'=>$gender,'is_confirmed'=>$is_confirmed,'category'=>'1','hashtag'=>$hashtag,'password'=>$hash,'mobile'=>$mobile,
	            'admin_approve'=>$admin_approve
	        );
	        $insert_id			=		$this->presenter_model->insert_presenter($data_presenter);
	        if($insert_id){
	            $config['mailtype']     = 'html';
	            $this->email->initialize($config);
	            $this->email->from('info@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
	            //$this->email->to(['narender.rathore@deconglobalsolutions.com','narender.rathore@theonlinegurukul.com']);
	            $this->email->to($email);
	            $this->email->subject('Email Account Verification - TOG  Admin');
	            $salthash		=   random_string('alnum', 9);
	            $link1          =  base_url("assets/web/images/bg-email.png");
	            $link2          =  base_url("assets/web/images/bg-footer.png");

	            $htmlContent = '
                   <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>TOG ACCOUNT ACTIVATION LINK</title>
  <style type="text/css" media="screen">

    /* Force Hotmail to display emails at full width */
    .ExternalClass {
      display: block !important;
      width: 100%;
    }

    /* Force Hotmail to display normal line spacing */
    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
      line-height: 100%;
    }

    body,
    p,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
      margin: 0;
      padding: 0;
    }

    body,
    p,
    td {
      font-family: Arial, Helvetica, sans-serif;
      font-size: 15px;
      color: #333333;
      line-height: 1.5em;
    }

    h1 {
        text-align: center;
    font-size: 20px;
    font-weight: bold;
    line-height: 24px;
    }

    body,
    p {
      margin-bottom: 0;
      -webkit-text-size-adjust: none;
      -ms-text-size-adjust: none;
    }

    img {
      outline: none;
      text-decoration: none;
      -ms-interpolation-mode: bicubic;
    }

    a img {
      border: none;
    }

    .background {
                background-color: #eeeeee;
}


    table.background {
      margin: 0;
      padding: 0;
      width: 100% !important;
    }

    .block-img {
      display: block;
      line-height: 0;
    }

    a {
      color: white;
      text-decoration: none;
    }

    a,
    a:link {
      color: #2A5DB0;
      text-decoration: underline;
    }

    table td {
      border-collapse: collapse;
    }

    td {
      vertical-align: top;
      text-align: left;
    }

    .wrap {
	    margin-top: 0px;
      width: 600px;
    }

    .wrap-cell {
      padding-top: 30px;
      padding-bottom: 30px;
    }

    .header-cell,
    .body-cell,
    .footer-cell {
      padding-left: 20px;
      padding-right: 20px;
    }

    .header-cell {


      color: #ffffff;
    }

    .body-cell {
      background-color: #ffffff;
      padding-top:16px;
      padding-bottom: 34px;
    }

    .footer-cell {

      text-align: center;
      font-size: 13px;
      padding-top:13px;
      padding-bottom: 30px;
    }

    .card {
      width: 400px;
      margin: 0 auto;
    }

    .data-heading {
      text-align: right;
      padding: 10px;
      background-color: #ffffff;
      font-weight: bold;
    }

    .data-value {
      text-align: left;
      padding: 10px;
      background-color: #ffffff;
    }

    .force-full-width {
      width: 100% !important;
    }

  </style>
  <style type="text/css" media="only screen and (max-width: 600px)">
    @media only screen and (max-width: 600px) {
      body[class*="background"],
      table[class*="background"],
      td[class*="background"] {
        background: #eeeeee !important;
      }

      table[class="card"] {
        width: auto !important;
      }

      td[class="data-heading"],
      td[class="data-value"] {
        display: block !important;
      }

      td[class="data-heading"] {
        text-align: left !important;
        padding: 10px 10px 0;
      }

      table[class="wrap"] {
        width: 100% !important;
      }

      td[class="wrap-cell"] {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
      }
    }


  </style>
</head>

<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" bgcolor="" class="background">
  <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="background">
    <tr>
      <td align="center" valign="top" width="100%" class="background">
        <center>
          <table cellpadding="0" cellspacing="0" width="600" class="wrap">
            <tr>
              <td valign="top" class="wrap-cell" style="padding-top:30px; padding-bottom:30px;">
                <table cellpadding="0" cellspacing="0" class="force-full-width">
				 <tr>
                    <td height="8" bgcolor="#ededed" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                  </tr>
                  <tr>
                   <td height="65" valign="top" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">
                   <a href="http://theonlinegurukul.com" target="_blank">
                   <img src="'.base_url("assets/web/images/20.png").'" width="150"  alt="" style="border-width:0; max-width:100px; display:block" /></a>
                   </td>
                   </tr>
                   <tr>
                   <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"><!--  border-top-left-radius:10px; --> <!-- border-top-right-radius:10px" --></td>
                                          </tr>

                  <tr>
                    <td valign="top" class="body-cell">

                      <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td valign="top" style="padding-bottom:15px; background-color:#ffffff;">
                      <h1>User Email Address verification link</h1>
                      </td>
                      </tr>
                      <tr>
                      <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
                      <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">
                        Account password :    '.$password.'</p><br>
                      <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">
                      Your TOG Account activation link is as follows. Please click the link
							  below to Activation of your Account.<br>
                      </p>
                      <center>    <a href="'.site_url("user/email/verify/").$hashtag.$insert_id.$salthash.'"
                      style="background-color:#ffa500;color:#ffffff;display:inline-block;font-family:sans-serif;font-size: 16px;line-height:37px;text-align:center;text-decoration:none;width:165px;-webkit-text-size-adjust:none;">Verify your Account</a>
                      </center>
                      <br>
                      <p style="color:#5b5f65; font-size:14px; text-align:justify;font-family: Verdana, Geneva, sans-serif">

                      Thank you for your patience. Please contact us for any inconvenience caused to you.<br>


                      </p>
                      </td>
                      </tr>
                      <tr>
                      <td>
                      <table cellspacing="0" cellpadding="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td style="width:200px;background:#008000;">
                      <div><!--[if mso]>
                      <v:rect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:40px;v-text-anchor:middle;width:200px;" stroke="f" fillcolor="#008000">
                      <w:anchorlock/>
                      <center>
                      <![endif]-->


                      <!--[if mso]>
                      </center>
                      </v:rect>
                      <![endif]--></div>
                      </td>
                      <td width="360" style="background-color:#ffffff; font-size:0; line-height:0;">&nbsp;</td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td style="padding-top:20px;background-color:#ffffff;">
                      <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">

                      Regards.<br>
                      The Online Gurukul
                      </p>
                      </td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                      </tr>

                      <tr>
                       <td height="65" align="center" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">

                      <center><span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Email :</span>
                      <a class="txs" href="mailto:info@example.com" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank">Info@theonlinegurukul.com </a>
                      <br>
                      <span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Phone :-</span>
                      <a class="txs" href="tel:+91-0124-4272441" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank"> 91-0124-4272441</a>
                      </center>
                      </td>
                      <tr>

                      </tr>



                      </table>
                      </td>
                      </tr>
                      </table>
                      </center>
                      </td>
                      </tr>
                      </table>

                      </body>
                      </html>

        ';
	            $this->email->message($htmlContent);

	            if ($this->email->send()) {
	                $this->session->set_flashdata('message', "<i presenter='icon fa fa-check'></i>Password sent to Email Successfully");
	                return redirect("admin/master/presenter/index");
	            }
	            else{
	                //show_error($this->email->print_debugger());
	                $this->session->set_flashdata('message', "<i presenter='icon fa fa-check'></i>Password not sent to Email Successfully");
	                return redirect("admin/master/presenter/index");
	            }
	        }
	        $this->session->set_flashdata('message', "<i presenter='icon fa fa-check'></i>Presenter Added Successfully");
	        return redirect("admin/master/presenter/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}

	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit presenter','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	=	$this->presenter_model->view_presenter($list_id);
	    $this->form_validation->set_error_delimiters('<p presenter="font-bold col-pink">', '</p>');
	    //$this->form_validation->set_rules('email'	      , 'Email'	        , 'required|xss_clean|trim|callback_presenter_check');
	    $this->form_validation->set_rules('first_name'    , 'First Name'	, 'required|xss_clean|trim');
	    $this->form_validation->set_rules('last_name'	  , 'Last Name'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('mobile'		  , 'Mobile'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('gender'		  , 'Gender'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('is_confirmed'  , 'Email Verification'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('admin_approve'  , 'Admin Account Approval'	    , 'required|xss_clean|trim');
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/presenter/edit_presenter',['list'=>$list]);
	    }
	    else{
	        $dt 						= 	    new DateTime();
	        $first_name	        =		strtolower(trim($this->input->post('first_name')));
	        $last_name			=		strtolower(trim($this->input->post('last_name')));
	        $gender		        =		strtolower(trim($this->input->post('gender')));
	        $mobile		        =		strtolower(trim($this->input->post('mobile')));
	        $is_confirmed		=		strtolower(trim($this->input->post('is_confirmed')));
	        $admin_approve		=		strtolower(trim($this->input->post('admin_approve')));
	        //$hashtag		    =		random_string('alnum', 16);

	        /* $password        =       random_string('alnum',10);
	        $hash               =       $this->bcrypt->hash_password($password); */

	        $data_presenter		=		array('first_name'=>$first_name,'last_name'=>$last_name,
	            'gender'=>$gender,'is_confirmed'=>$is_confirmed,'mobile'=>$mobile,'admin_approve'=>$admin_approve);

	        $this->presenter_model->update_presenter($data_presenter,$list_id);
	        $this->session->set_flashdata('message', "<i presenter='icon fa fa-check'></i>presenter Updated Successfully");
	        return redirect("admin/master/presenter/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View presenter','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list=$this->presenter_model->view_presenter($list_id);
	    $this->load->view('adminlte/master/presenter/view_presenter',['list'=>$list]);
	    $this->load->view('adminlte/panel/footer');;
	}
	//////delete
	public function delete($list_id) {
	    $this->presenter_model->delete_presenter($list_id);
	    $this->session->set_flashdata('message', "<i presenter='icon fa fa-check'></i>presenter Successfully Deleted!");
	    redirect('admin/master/presenter/index');
	}
}
?>
