<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Parallel_session_purchased extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Parallel_session_purchasedmodel','parallel_session_purchased_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');
		
		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		//$this->load->model('AdminlteModel','adminlte_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}
	public function index(){
	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/parallel_session_purchased/index'),
	        'total_rows'				=>	$this->parallel_session_purchased_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'page_query_string'         => 	FALSE,
	        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		= $this->parallel_session_purchased_model->parallel_session_purchased_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();
	    
	    
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'parallel_session_purchased List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->load->view('adminlte/master/parallel_session_purchased/index',['parallel_session_purchased'=>$parallel_session_purchased]);
	    $this->load->view('adminlte/panel/footer');
	}
	/// category Check
	function parallel_session_purchased_check($parallel_session_purchased){
	    $activity			=	str_replace(" ","-",$parallel_session_purchased);
	    $count 				= 	$this->parallel_session_purchased_model->count_parallel_session_purchased($parallel_session_purchased);
	    if($count > 0){
	        $this->form_validation->set_message('parallel_session_purchased_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	
	///create
	public function create(){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add parallel_session_purchased','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('session_tag_id'	  , 'Session Tag Id'	    , 'required|xss_clean|trim|is_unique[parallel_session_purchased.session_tag_id]');
	    $this->form_validation->set_rules('total_attendee'    , 'Toatl Seat'	        , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('attendee_limit'	  , 'Attendee Seats'	        , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('count_month'		  , 'Toatl Month purchased'	            , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('from_to_date'	  , 'Duration Session'	        , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('date_purchased'    , 'Date of Purchase'	            , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('cost_basic'	      , 'Basic Cost'	        , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('cgst'		      , 'CGST COSt'	            , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('sgst'	          , 'Sgst Cost'	              , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('igst'		      , 'IGST COST'	         , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('our_gstin'	      , 'GSTIN NO'	          , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('customer_gstin'	  , 'CUSTOMER GSTIN'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('cost_per_year'	  , 'COST PER YEAR'	         , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('cost_per_month'	  , 'COST PER MONTH'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('cost_per_day'	  , 'COST PER DAY'	       , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('status'		      , 'Status'	          , 'required|xss_clean|trim');
	    
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/parallel_session_purchased/create');
	    }
	    else{
	        $dt 				= 	    new DateTime();
	        print_r($_POST);
	        $session_tag_id	    =		strtolower(trim($this->input->post('session_tag_id')));
	        $total_attendee	    =		strtolower(trim($this->input->post('total_attendee')));
	        $attendee_limit	    =		strtolower(trim($this->input->post('attendee_limit')));
	        $count_month		=		strtolower(trim($this->input->post('count_month')));
	        $from_to_date		=		strtolower(trim($this->input->post('from_to_date')));
	        $duration_date      =       explode('-',$from_to_date);
	        $date_purchased		=		strtolower(trim($this->input->post('date_purchased')));
	        $cost_basic		    =		strtolower(trim($this->input->post('cost_basic')));
	        $cgst		        =		strtolower(trim($this->input->post('cgst')));
	        $sgst		        =		strtolower(trim($this->input->post('sgst')));
	        $igst		        =		strtolower(trim($this->input->post('igst')));
	        $our_gstin		    =		strtolower(trim($this->input->post('our_gstin')));
	        $customer_gstin		=		strtolower(trim($this->input->post('customer_gstin')));
	        $cost_per_year		=		strtolower(trim($this->input->post('cost_per_year')));
	        $cost_per_month		=		strtolower(trim($this->input->post('cost_per_month')));
	        $cost_per_day		=		strtolower(trim($this->input->post('cost_per_day')));
	        $status		        =		strtolower(trim($this->input->post('status')));
	       
	        $data_category		=		array('session_tag_id'=>$session_tag_id,'total_attendee'=>$total_attendee,
	            'attendee_limit'=>$attendee_limit,'count_month'=>$count_month,'from_date'=>date("Y-m-d",strtotime($duration_date[0])),
	                'todate'=>date("Y-m-d",strtotime($duration_date[1])),'date_purchased'=>date("Y-m-d",strtotime($date_purchased)),
	            'cost_basic'=>$cost_basic,
	            'cgst'=>$cgst,'sgst'=>$sgst,'igst'=>$igst,'our_gstin'=>$our_gstin,'customer_gstin'=>$customer_gstin,
	            'cost_per_year'=>$cost_per_year,'cost_per_month'=>$cost_per_month,'cost_per_day'=>$cost_per_day,'status'=>$status,
	            'create_by'=>$this->userid);
	        $insert_id			=		$this->parallel_session_purchased_model->insert_parallel_session_purchased($data_category);
	        
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>category Added Successfully");
	        return redirect("admin/master/Parallel_session_purchased/index");
	        //return redirect("master/Activity/edit/$insert_id");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	
	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit parallel_session_purchased','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	=	$this->parallel_session_purchased_model->view_parallel_session_purchased($list_id);
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    //$this->form_validation->set_rules('category'					, 'category'				, 'required|xss_clean');
	    $this->form_validation->set_rules('description'		, 'Description'	, 'required|xss_clean');
	    $this->form_validation->set_rules('status'		    , 'Status'	    , 'required|xss_clean|trim');
	    
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/parallel_session_purchased/edit',['list'=>$list]);
	    }
	    else{
	        $dt 						= 	    new DateTime();
	        //$category					=		strtolower(str_replace(" ","-",trim($this->input->post('category'))));
	        $description		        =		strtolower($this->input->post('description'));
	        $status			            =		strtolower(trim($this->input->post('status')));
	        $data_category			    =		array(
	            //'category'=>$category,
	            'description'=>"$description",'status'=>$status,'update_by'=>$this->session->userdata('ad_id'));
	        
	        $this->parallel_session_purchased_model->update_parallel_session_purchased($data_category,$list_id);
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>category Updated Successfully");
	        return redirect("admin/master/parallel_session_purchased/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View category','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list=$this->parallel_session_purchased_model->view_parallel_session_purchased($list_id);
	    $this->load->view('adminlte/master/parallel_session_purchased/view',['list'=>$list]);
	    $this->load->view('adminlte/panel/footer');;
	}
	//////delete
	public function delete($list_id) {
	    $this->parallel_session_purchased_model->delete_parallel_session_purchased($list_id);
	    $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>category Successfully Deleted!");
	    redirect('admin/master/parallel_session_purchased/index');
	}
	public function get_class_subject(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject($postData);
	    echo json_encode($data);
	}
	
	public function get_class_subject_faculty(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject_faculty($postData);
	    echo json_encode($data);
	}
	
	public function search(){
	    //print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
	        'category_code'    =>  strtolower(trim($this->input->post('category_code'))),
	        'order_by'		   =>  strtolower(trim($this->input->post('order_by'))),
	        'seach_term'	   =>  strtolower(trim($this->input->post('seach_term')))
	    );
	    if(
	        (
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) 	|| 
	            (isset($data_taskpo['category_code'])	&& !empty($data_taskpo['category_code'])) 
	        )
	        &&(
	            (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	|| (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))
	            )
	        ){
	            
	            $list           =	$this->category_model->search($data_taskpo);
	            $category       =   $this->adminlte_model->category_lists();
	            $links=''; 
	            
	            $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'category List','list'=>$list,
	                'link'=>$links,'menu_auth'=>$this->menu_auth]);
	            $this->load->view('adminlte/panel/sidebar');
	            $this->load->view('adminlte/master/category/category',['category'=>$category,'data_taskpo'=>$data_taskpo]);
	            $this->load->view('adminlte/panel/footer');
	    }
	    else{
	        return redirect('admin/master/Parallel_session_purchased');
	    }
	}
}
?>
