<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Faculty extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Facultymodel','faculty_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');
		  $this->load->model('admin/course/Coursemodel','course_model');
		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}
	public function index(){
	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/faculty/index'),
	        'total_rows'				=>	$this->faculty_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'full_tag_open'			    =>	"<ul class='pagination pagination-sm no-margin'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		= $this->faculty_model->faculty_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();
	    $category        =      $this->adminlte_model->getcategory();
		$subject_code  =  $this->faculty_model->faculty_code_lists();
		//echo "<pre>";print_r($subject_code);

	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'faculty List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
		$this->load->view('adminlte/master/faculty/faculty',['subject_code'=>$subject_code,'category'=>$category,'class'=>$class,
		'subject'=>$subject]);
		$this->load->view('adminlte/panel/footer');
	}
	/// faculty Check
	function faculty_check(){
	    $category			=	strtolower(trim($this->input->post('category')));
	    $class              =   trim($this->input->post('class'));
	    $subject            =   trim($this->input->post('subject'));
	    $teacher            =   trim($this->input->post('teacher'));
	    //$subject		    =	strtolower(str_replace(" ","-",trim($this->input->post('subject'))));
	    $count 				= 	$this->faculty_model->count_faculty($category,$class,$subject,$teacher);
	    if($count > 0){
	        $this->form_validation->set_message('faculty_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	/* function faculty_code_check(){
	    $category			=	strtolower(trim($this->input->post('category')));
	    $class              =   trim($this->input->post('class'));
	    $subject            =   trim($this->input->post('subject'));
	    $teacher            =   trim($this->input->post('teacher'));
	    $faculty_code            =   trim($this->input->post('faculty_code'));
	    $count 				= 	$this->faculty_model->count_faculty_code($category,$class,$subject,$faculty_code);
	    if($count > 0){
	        $this->form_validation->set_message('faculty_code_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	} */
	///create
	public function create(){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Activity','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('category'			, 'category'    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('class'				, 'class'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('subject'				, 'subject'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('faculty'				, 'faculty'		, 'required|xss_clean|callback_faculty_check');
	   // $this->form_validation->set_rules('faculty_code'		, 'faculty'		, 'required|xss_clean|callback_faculty_code_check');
	    $this->form_validation->set_rules('description'			, 'Description'	, 'required|xss_clean');
	    $this->form_validation->set_rules('status'			    , 'Status'	    , 'required|xss_clean');
	    $teacher =       $this->faculty_model->teacher_lists();
	    $category                                  =       $this->adminlte_model->getcategory();

	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/faculty/add_faculty',['teacher'=>$teacher,'category'=>$category]);
	    }
	    else{
	        $dt 										= 	new DateTime();
	        $category				        =	strtolower(trim($this->input->post('category')));
	        $class				          =	strtolower(trim($this->input->post('class')));
	        $subject				        =	strtolower(trim($this->input->post('subject')));
	        $faculty					    	=	strtolower($this->input->post('faculty'));
	        $description						=	strtolower(trim($this->input->post('description')));
	        $status					        =	strtolower(trim($this->input->post('status')));
	        $data_faculty			      =	array(
	            'category_id'=>$category,'class_id'=>$class,'subject_id'=>$subject,
	            'teacher_id'=>$faculty,'description'=>$description,'status'=>$status,
	            'create_by'=>$this->session->userdata('ad_id'));
	        $insert_id				      =	$this->faculty_model->insert_faculty($data_faculty);

					$finduserid  						=  $this->course_model->find_usercategory_userid($faculty);
					if($finduserid->userid==""){
					  $getcode			     =	$this->course_model->fetch_usercategory_code('teacher');
					  $current	         =	$getcode->code;
					  $code3			       =	(int)$current;
					  $code			         =	$code3+1;
					  if(strlen($code)==1){$newcode="0000".$code;}
					  if(strlen($code)==2){$newcode="000".$code;}
					  if(strlen($code)==3){$newcode="00".$code;}
					  if(strlen($code)==4){$newcode="0".$code;}
					  if(strlen($code)==5){$newcode=$code;}
					  if((strlen($code)>5)||(strlen($newcode)==0)){echo "Please change Invoiceno series older is like 00001";exit;}

					  $this->course_model->update_userid_masteruser($faculty,strtoupper($getcode->main_code.$newcode));
						$this->course_model->update_code_usercategory($code,'teacher');
					}

	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>faculty Added Successfully");
	        return redirect("admin/master/faculty/index");
	        //return redirect("master/Activity/edit/$insert_id");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit faculty','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	=	$this->faculty_model->view_faculty($list_id);
	    $this->form_validation->set_error_delimiters('<p faculty="text-red">', '</p>');
	    //$this->form_validation->set_rules('faculty'			, 'faculty'		, 'required|xss_clean');
	    $this->form_validation->set_rules('description'		, 'Description'	, 'required|xss_clean');
	    $this->form_validation->set_rules('status'		, 'Status'	, 'required|xss_clean');
	    $category                                  =       $this->adminlte_model->getcategory();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/faculty/edit_faculty',['list'=>$list,'category'=>$category]);
	    }
	    else{
	        $dt 							= 	new DateTime();
	        $description					=	strtolower(trim($this->input->post('description')));
	        $status					        =	strtolower(trim($this->input->post('status')));
	        $data_faculty			        =	array('description'=>$description,'status'=>$status,
	            'update_by'=>$this->session->userdata('ad_id'));

	        $this->faculty_model->update_faculty($data_faculty,$list_id);
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>faculty Updated Successfully");
	        return redirect("admin/master/faculty/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View faculty','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $category                                  =       $this->adminlte_model->getcategory();
	    $list=$this->faculty_model->view_faculty($list_id);
	    $this->load->view('adminlte/master/faculty/view_faculty',['list'=>$list,'category'=>$category]);
	    $this->load->view('adminlte/panel/footer');;
	}
	//////delete
	public function delete($list_id) {
	    $this->faculty_model->delete_faculty($list_id);
	    $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>faculty Successfully Deleted!");
	    redirect('admin/master/faculty/index');
	}
	public function search(){
	//print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
			'class'		   	   =>  strtolower(trim($this->input->post('class'))),
	        'subject'       =>  strtolower(trim($this->input->post('subject'))),
			'subject_code'       =>  strtolower(trim($this->input->post('subject_code'))),
	        'order_by'		   =>  strtolower(trim($this->input->post('order_by'))),
	        'seach_term'	   =>  strtolower(trim($this->input->post('seach_term')))
	    );
	    if(
	        (
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) ||
	            (isset($data_taskpo['class'])	&& !empty($data_taskpo['class'])) ||
				(isset($data_taskpo['subject'])	&& !empty($data_taskpo['subject'])) ||
				(isset($data_taskpo['subject_code'])	&& !empty($data_taskpo['subject_code']))


	        )
	        &&(
	            (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	|| (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))
	            )
	        ){

				$list         =	$this->faculty_model->search($data_taskpo);
				$category        =      $this->adminlte_model->getcategory();
				$subject_code  =  $this->faculty_model->faculty_code_lists();

	            $links='';

	            $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'category List','list'=>$list,
	                'link'=>$links,'menu_auth'=>$this->menu_auth]);
	            $this->load->view('adminlte/panel/sidebar');
	            //$this->load->view('adminlte/master/subject/subject',['category'=>$category,'data_taskpo'=>$data_taskpo]);
				$this->load->view('adminlte/master/faculty/faculty',['category'=>$category,'class'=>$class,'subject'=>$subject,'subject_code'=>$subject_code,'data_taskpo'=>$data_taskpo]);
	            $this->load->view('adminlte/panel/footer');
	    }
	    else{
	        return redirect('admin/master/faculty');
	    }
	}
}
?>
