<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Coupon_category extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Coupon_categorymodel','coupon_category_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');
		
		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		//$this->load->model('AdminlteModel','adminlte_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}
	public function index(){
	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/coupon_category/index'),
	        'total_rows'				=>	$this->coupon_category_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'page_query_string'         => 	FALSE,
	        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		= $this->coupon_category_model->coupon_category_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();
	    
	   // $coupon_category   =   $this->adminlte_model->coupon_category_lists();
	    
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'coupon_category List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->load->view('adminlte/master/coupon_category/coupon_category',[]);
	    $this->load->view('adminlte/panel/footer');
	}
	/// coupon_category Check
	function coupon_category_check($coupon_category){
	    $activity			=	str_replace(" ","-",$coupon_category);
	    $count 				= 	$this->coupon_category_model->count_coupon_category($coupon_category);
	    if($count > 0){
	        $this->form_validation->set_message('coupon_category_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	public function contactVerify($contact, $otherField) {
	    return ($contact != '' || $this->input->post($otherField) != '');
	}
	
	///create
	public function create(){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add coupon_category','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p coupon_category="font-bold col-pink">', '</p>');
	    $this->form_validation->set_message('contactVerify', 'Either percent or Amount is required');
	    $this->form_validation->set_rules('coupon_category'	  , 'Coupon category'	    , 'required|xss_clean|trim|is_unique[coupon_category.coupon_category]');
	    $this->form_validation->set_rules('percent'           , 'percent'	            , 'callback_contactVerify[amount]|xss_clean|trim');
	    $this->form_validation->set_rules('amount'	          , 'Amount'	            , 'callback_contactVerify[percent]|xss_clean|trim');
	    $this->form_validation->set_rules('status'		      , 'Status'	            , 'required|xss_clean|trim');
	    
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/coupon_category/add_coupon_category');
	    }
	    else{
	        $dt 				        = 	    new DateTime();
	        $coupon_category			=		strtolower(str_replace(" ","-",trim($this->input->post('coupon_category'))));
	        $percent	                =		strtolower(trim($this->input->post('percent')));
	        $amount		                =		strtolower(trim($this->input->post('amount')));
	        $status			            =		strtolower(trim($this->input->post('status')));
	        $data_coupon_category		=		array('coupon_category'=>$coupon_category,'percent'=>$percent,'status'=>$status,
	            'amount'=>$amount,'create_by'=>$this->session->userdata('ad_id'));
	        $insert_id			        =		$this->coupon_category_model->insert_coupon_category($data_coupon_category);
	        
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>coupon_category Added Successfully");
	        return redirect("admin/master/coupon_category/index");
	        //return redirect("master/Activity/edit/$insert_id");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	
	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit coupon_category','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	=	$this->coupon_category_model->view_coupon_category($list_id);
	    $this->form_validation->set_error_delimiters('<p coupon_category="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('coupon_category'	  , 'Coupon category'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('percent'           , 'percent'	            , 'callback_contactVerify[amount]|xss_clean|trim');
	    $this->form_validation->set_rules('amount'	          , 'Amount'	            , 'callback_contactVerify[percent]|xss_clean|trim');
	    $this->form_validation->set_rules('status'		      , 'Status'	            , 'required|xss_clean|trim');
	    
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/coupon_category/edit_coupon_category',['list'=>$list]);
	    }
	    else{
	        $dt 						= 	    new DateTime();
	        $coupon_category			=		strtolower(str_replace(" ","-",trim($this->input->post('coupon_category'))));
	        $percent	                =		strtolower(trim($this->input->post('percent')));
	        $amount		                =		strtolower(trim($this->input->post('amount')));
	        $status			            =		strtolower(trim($this->input->post('status')));
	        $data_coupon_category		=		array('coupon_category'=>$coupon_category,'percent'=>$percent,'status'=>$status,
	            'amount'=>$amount,'update_by'=>$this->session->userdata('ad_id'));
	        
	        $this->coupon_category_model->update_coupon_category($data_coupon_category,$list_id);
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>coupon_category Updated Successfully");
	        return redirect("admin/master/coupon_category/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View coupon_category','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list=$this->coupon_category_model->view_coupon_category($list_id);
	    $this->load->view('adminlte/master/coupon_category/view_coupon_category',['list'=>$list]);
	    $this->load->view('adminlte/panel/footer');;
	}
	//////delete
	public function delete($list_id) {
	    $this->coupon_category_model->delete_coupon_category($list_id);
	    $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>coupon_category Successfully Deleted!");
	    redirect('admin/master/coupon_category/index');
	}
	public function get_class_subject(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject($postData);
	    echo json_encode($data);
	}
	
	public function get_class_subject_faculty(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject_faculty($postData);
	    echo json_encode($data);
	}
	
	public function search(){
	    //print_r($_POST);die;
	    $data_taskpo=array(
	        'coupon_category'		   =>  strtolower(trim($this->input->post('coupon_category'))),
	        'coupon_category_code'    =>  strtolower(trim($this->input->post('coupon_category_code'))),
	        'order_by'		   =>  strtolower(trim($this->input->post('order_by'))),
	        'seach_term'	   =>  strtolower(trim($this->input->post('seach_term')))
	    );
	    if(
	        (
	            (isset($data_taskpo['coupon_category'])	&& !empty($data_taskpo['coupon_category'])) 	|| 
	            (isset($data_taskpo['coupon_category_code'])	&& !empty($data_taskpo['coupon_category_code'])) 
	        )
	        &&(
	            (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	|| (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))
	            )
	        ){
	            
	            $list           =	$this->coupon_category_model->search($data_taskpo);
	            $coupon_category       =   $this->adminlte_model->coupon_category_lists();
	            $links=''; 
	            
	            $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'coupon_category List','list'=>$list,
	                'link'=>$links,'menu_auth'=>$this->menu_auth]);
	            $this->load->view('adminlte/panel/sidebar');
	            $this->load->view('adminlte/master/coupon_category/coupon_category',['coupon_category'=>$coupon_category,'data_taskpo'=>$data_taskpo]);
	            $this->load->view('adminlte/panel/footer');
	    }
	    else{
	        return redirect('admin/master/coupon_category');
	    }
	}
}
?>
