<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Classes extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Classmodel','class_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');
		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}
	public function index(){
	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/classes/index'),
	        'total_rows'				=>	$this->class_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'full_tag_open'			    =>	"<ul class='pagination pagination-sm no-margin'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		=   $this->class_model->class_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();
	    $cat        =      $this->adminlte_model->getcategory();
		$classcode  =      $this->class_model->class_code_lists();

		
		//echo "<pre>";print_r($cat);die;
	    
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'class List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth,'category'=>$cat]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->load->view('adminlte/master/class/class',['category'=>$cat,'class'=>$class,'class_code'=>$classcode]);
	    $this->load->view('adminlte/panel/footer');
	}
	/// class Check
	function class_check(){
	    $category			=	strtolower(trim($this->input->post('category')));
	    $class		        =	strtolower(str_replace(" ","-",trim($this->input->post('class'))));
	    $count 				= 	$this->class_model->count_class($category,$class);
	    if($count > 0){
	        $this->form_validation->set_message('class_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	function class_code_check(){
	    $category			=	strtolower(trim($this->input->post('category')));
	    $class_code		    =	strtolower(trim($this->input->post('class_code')));
	    $count 				= 	$this->class_model->count_class_code($category,$class_code);
	    if($count > 0){
	        $this->form_validation->set_message('class_code_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	///create
	public function create(){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Activity','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('category'		, 'category'	, 'required|xss_clean');
	    $this->form_validation->set_rules('class'			, 'class'		, 'required|xss_clean|callback_class_check');
	    $this->form_validation->set_rules('class_code'      , 'Class Code'	, 'required|xss_clean|trim|callback_class_code_check');
	    $this->form_validation->set_rules('description'	    , 'Description'	, 'required|xss_clean');
	    $category= $this->adminlte_model->getcategory();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/class/add_class',['category'=>$category]);
	    }
	    else{
	        $dt 				= 	new DateTime();
	        
	        $category			=		strtolower(trim($this->input->post('category')));
	        $class				=		strtolower(str_replace(" ","-",trim($this->input->post('class'))));
	        $class_code	        =		strtolower(trim($this->input->post('class_code')));
	        $description		=		strtolower(trim($this->input->post('description')));
	        $status			    =		strtolower(trim($this->input->post('status')));
	        $data_class			=		array('class'=>$class,'description'=>$description,'category_id'=>$category,'status'=>$status,
	            'class_code'=>$class_code,'create_by'=>$this->session->userdata('ad_id')
	        );
	        $insert_id			=		$this->class_model->insert_class($data_class);
	        
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>class Added Successfully");
	        return redirect("admin/master/classes/index");
	        //return redirect("master/Activity/edit/$insert_id");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit class','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	     =	  $this->class_model->view_class($list_id);
	    $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
	    //$this->form_validation->set_rules('category'				, 'category'	        , 'required|xss_clean');
	    //$this->form_validation->set_rules('class'					, 'class'				, 'required|xss_clean');
	    $this->form_validation->set_rules('description'		        , 'Description'	        , 'required|xss_clean');
	    $this->form_validation->set_rules('status'		            , 'Status'	            , 'required|xss_clean|trim');
	    $category=$this->adminlte_model->getcategory();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/class/edit_class',['list'=>$list,'category'=>$category]);
	    }
	    else{
	        $dt 			    = 	new DateTime();
	        ///$category	    =	strtolower(trim($this->input->post('category')));
	        //$class		    =	strtolower(str_replace(" ","-",trim($this->input->post('class'))));
	        $description		=	strtolower(trim($this->input->post('description')));
	        $status			    =   strtolower(trim($this->input->post('status')));
	        $data_class			=	array(
	            //'category_id'=>$category,
	            //'class'=>$class,
	            'description'=>$description,
	            'status'=>$status,'update_by'=>$this->session->userdata('ad_id')
	            
	        );
	        
	        $this->class_model->update_class($data_class,$list_id);
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>class Updated Successfully");
	        return redirect("admin/master/classes/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View class','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $category=$this->adminlte_model->getcategory();
	    $list=$this->class_model->view_class($list_id);
	    $this->load->view('adminlte/master/class/view_class',['list'=>$list,'category'=>$category]);
	    $this->load->view('adminlte/panel/footer');
	}
	//////delete
	public function delete($list_id) {
	    $this->class_model->delete_class($list_id);
	    $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>class Successfully Deleted!");
	    redirect('admin/master/classes/index');
	}
	public function get_class_subject(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject($postData);
	    echo json_encode($data);
	}
	
	public function get_class_subject_faculty(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject_faculty($postData);
	    echo json_encode($data);
	}
	public function search(){
	    //print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
			'class'		   	   =>  strtolower(trim($this->input->post('class'))),
	        'class_code'       =>  strtolower(trim($this->input->post('class_code'))),
	        'order_by'		   =>  strtolower(trim($this->input->post('order_by'))),
	        'seach_term'	   =>  strtolower(trim($this->input->post('seach_term')))
	    );
	    if(
	        (
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) || 
	            (isset($data_taskpo['class'])	&& !empty($data_taskpo['class'])) ||
				(isset($data_taskpo['class_code'])	&& !empty($data_taskpo['class_code']))

	        )
	        &&(
	            (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	|| (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))
	            )
	        ){
	            
	            $list         =	$this->class_model->search($data_taskpo);
	            $cat        =      $this->adminlte_model->getcategory();
				$classcode  =      $this->class_model->class_code_lists();
				
	            $links=''; 
	            
	            $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'category List','list'=>$list,
	                'link'=>$links,'menu_auth'=>$this->menu_auth]);
	            $this->load->view('adminlte/panel/sidebar');
	            //$this->load->view('adminlte/master/class/class',['category'=>$category,'data_taskpo'=>$data_taskpo]);
				$this->load->view('adminlte/master/class/class',['category'=>$cat,'class'=>$class,'class_code'=>$classcode,'data_taskpo'=>$data_taskpo]);
	            $this->load->view('adminlte/panel/footer');
	    }
	    else{
	        return redirect('admin/master/Classes');
	    }
	}
}
?>
