<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Chapter extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Chaptermodel','chapter_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');
		
		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		$this->load->model('AdminlteModel','adminlte_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}
	public function index(){
	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/chapter/index'),
	        'total_rows'				=>	$this->chapter_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'full_tag_open'			    =>	"<ul class='pagination pagination-sm no-margin'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		= $this->chapter_model->chapter_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();
		$category        =      $this->adminlte_model->getcategory();
		$chapter_code_lists  =  $this->chapter_model->chapter_code_lists();
		
		//echo "<pre>";print_r($chapter_code_lists);die;
	    
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'class List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->load->view('adminlte/master/chapter/chapter',['category'=>$category,'class'=>$class,'subject'=>$subject,'chapter'=>$chapter,'chapter_code'=>$chapter_code_lists]);
	    $this->load->view('adminlte/panel/footer');
	}
	/// chapter Check
	function chapter_check($chapter){
	    $activity			=	str_replace(" ","-",$chapter);
	    $count 				= 	$this->chapter_model->count_chapter($chapter);
	    if($count > 0){
	        $this->form_validation->set_message('chapter_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	///create
	public function create(){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Activity','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p class="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('category'			, 'category'    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('class'				, 'class'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('subject'				, 'subject'	    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('chapter'				, 'chapter'		, 'required|xss_clean|callback_chapter_check');
	    $this->form_validation->set_rules('chapter_code'		, 'chapter_code'    , 'required|xss_clean|trim');
	    $this->form_validation->set_rules('description'			, 'Description'	, 'required|xss_clean');
	    $subject =       $this->chapter_model->subject_lists();
	    $category                                  =       $this->adminlte_model->getcategory();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/chapter/add_chapter',['subject'=>$subject,'category'=>$category]);
	    }
	    else{
	        $dt 							= 	new DateTime();
	        
			$category					    =	strtolower(trim($this->input->post('category')));
	        $class					        =	strtolower(trim($this->input->post('class')));
			$subject					    =	strtolower(trim($this->input->post('subject')));
	        $chapter					    =	strtolower(str_replace(" ","-",trim($this->input->post('chapter'))));
			$chapter_code				    =	strtolower(trim($this->input->post('chapter_code')));
	        $description					=	strtolower(trim($this->input->post('description')));
	        
	        $data_chapter			        =	array('chapter'=>$chapter,'chapter_code'=>$chapter_code,'subject_id'=>$subject,'description'=>$description,'category_id'=>$category,'class_id'=>$class);
	        $insert_id				        =	$this->chapter_model->insert_chapter($data_chapter);
	        
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>chapter Added Successfully");
	        return redirect("admin/master/chapter/index");
	        //return redirect("master/Activity/edit/$insert_id");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit chapter','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	=	$this->chapter_model->view_chapter($list_id);
	    $this->form_validation->set_error_delimiters('<p chapter="text-red">', '</p>');
	    $this->form_validation->set_rules('chapter'			, 'chapter'		, 'required|xss_clean');
		//$this->form_validation->set_rules('chapter_code'			, 'chapter_code'		, 'required|xss_clean');
	    $this->form_validation->set_rules('description'		, 'Description'	, 'required|xss_clean');
	    $subject =   $this->chapter_model->subject_lists();
	    $class                                  =       $this->chapter_model->getclass();
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/chapter/edit_chapter',['list'=>$list,'subject'=>$subject,'class'=>$class]);
	    }
	    else{
	        $dt 							= 	new DateTime();
	        $chapter					    =	strtolower(str_replace(" ","-",trim($this->input->post('chapter'))));
	        //$chapter_code					=	strtolower(trim($this->input->post('chapter_code')));
	        $subject					    =	strtolower(trim($this->input->post('subject')));
	        $description					=	strtolower(trim($this->input->post('description')));
	        $data_chapter			        =	array('chapter'=>$chapter,'description'=>$description,'subject_id'=>$subject);
	        
	        $this->chapter_model->update_chapter($data_chapter,$list_id);
	        $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>chapter Updated Successfully");
	        return redirect("admin/master/chapter/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View Chapter','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $subject =   $this->chapter_model->subject_lists();
	    $class                                  =       $this->chapter_model->getclass();
	    $list=$this->chapter_model->view_chapter($list_id);
	    $this->load->view('adminlte/master/chapter/view_chapter',['list'=>$list,'subject'=>$subject,'class'=>$class]);
	    $this->load->view('adminlte/panel/footer');;
	}
	//////delete
	public function delete($list_id) {
	    $this->chapter_model->delete_chapter($list_id);
	    $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Chapter Successfully Deleted!");
	    redirect('admin/master/chapter/index');
	}
	public function search(){
	//print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
			'class'		   	   =>  strtolower(trim($this->input->post('class'))),
	        'subject'          =>  strtolower(trim($this->input->post('subject'))),
			'chapter'          =>  strtolower(trim($this->input->post('chapter'))),
			'chapter_code'     =>  strtolower(trim($this->input->post('chapter_code'))),
	        'order_by'		   =>  strtolower(trim($this->input->post('order_by'))),
	        'seach_term'	   =>  strtolower(trim($this->input->post('seach_term')))
	    );
	    if(
	        (
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) || 
	            (isset($data_taskpo['class'])	    && !empty($data_taskpo['class'])) ||
				(isset($data_taskpo['subject']) 	&& !empty($data_taskpo['subject'])) ||
				(isset($data_taskpo['chapter'])	    && !empty($data_taskpo['chapter'])) ||
				(isset($data_taskpo['chapter_code'])&& !empty($data_taskpo['chapter_code'])) 

	        )
	        &&(
	            (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	|| (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))
	            )
	        ){
	            
				$list         =	$this->chapter_model->search($data_taskpo);
				$category        =      $this->adminlte_model->getcategory();
				$chapter_code_lists  =  $this->chapter_model->chapter_code_lists();
				
	            $links=''; 
	            
	            $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'category List','list'=>$list,
	                'link'=>$links,'menu_auth'=>$this->menu_auth]);
	            $this->load->view('adminlte/panel/sidebar');
	            //$this->load->view('adminlte/master/subject/subject',['category'=>$category,'data_taskpo'=>$data_taskpo]);
				$this->load->view('adminlte/master/chapter/chapter',['category'=>$category,'class'=>$class,'subject'=>$subject,'chapter'=>$chapter,'chapter_code'=>$chapter_code_lists,'data_taskpo'=>$data_taskpo]);
	            $this->load->view('adminlte/panel/footer');
	    }
	    else{
	        return redirect('admin/master/chapter');
	    }
	}
}
?>
