<?php defined('BASEPATH') or exit('No direct Access is Allowed');?>
<?php
class Category extends MY_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model('admin/master/Categorymodel','category_model');
		$this->load->model('admin/Adminltemodel','adminlte_model');
		
		$this->load->library(['form_validation','bcrypt','email','session','pagination']);
		$this->load->helper(['html','form','url','security','string']);
		$this->load->model('CommonModel','common_model');
		//$this->load->model('AdminlteModel','adminlte_model');
		if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
		if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
		if($this->session->userdata('ss_id') ){return redirect('student/signin');}
		$list_id					=		$this->session->userdata('ad_id');
		$this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
		//echo $this->session->userdata('ad_id');die;
		error_reporting(0);
		date_default_timezone_set('Asia/Kolkata');
	}
	public function index(){
	    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
	    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
	    $config = [
	        'base_url'					=>	site_url('admin/master/category/index'),
	        'total_rows'				=>	$this->category_model->num_rows(),
	        'per_page'					=>	$perpage,
	        'display_pages'			    =>	TRUE,
	        'use_page_numbers'	        => 	TRUE,
	        'uri_segment'				=>	5,
	        'num_links'					=>	10,
	        'page_query_string'         => 	FALSE,
	        'full_tag_open'			    =>	"<ul category='pagination pagination-sm'>",
	        'full_tag_close'		    =>	"</ul>",
	        'first_tag_open'		    =>	'<li>',
	        'first_tag_close'		    =>	'</li>',
	        'last_tag_open'			    =>	'<li>',
	        'last_tag_close'		    =>	'</li>',
	        'next_tag_open'			    =>	'<li>',
	        'next_tag_close'		    =>	'</li>',
	        'prev_tag_open'			    =>	'<li>',
	        'prev_tag_close'		    =>	'</li>',
	        'num_tag_open'			    =>	'<li>',
	        'num_tag_close'			    =>	'</li>',
	        'cur_tag_open'			    =>	'<li category="page-item active"><a category="page-link">',
	        'cur_tag_close'			    =>	'</a></li>',
	    ];
	    $this->pagination->initialize($config);
	    $page 		= ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
	    $list 		= $this->category_model->category_list($config['per_page'],$page,$search);
	    $links		=	$this->pagination->create_links();
	    
	    $category   =   $this->adminlte_model->category_lists();
	    
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'category List','list'=>$list,'link'=>$links,'menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->load->view('adminlte/master/category/category',['category'=>$category]);
	    $this->load->view('adminlte/panel/footer');
	}
	/// category Check
	function category_check($category){
	    $activity			=	str_replace(" ","-",$category);
	    $count 				= 	$this->category_model->count_category($category);
	    if($count > 0){
	        $this->form_validation->set_message('category_check', 'The {field} field have already record you are enter,please enter unique value');
	        return FALSE;
	    }
	    else {
	        return TRUE;
	    }
	}
	
	///create
	public function create(){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add category','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $this->form_validation->set_error_delimiters('<p category="font-bold col-pink">', '</p>');
	    $this->form_validation->set_rules('category'	  , 'category'	    , 'required|xss_clean|trim|is_unique[category.category]');
	    $this->form_validation->set_rules('category_code' , 'Category Code'	, 'required|xss_clean|trim|is_unique[category.category_code]');
	    $this->form_validation->set_rules('description'	  , 'Description'	, 'required|xss_clean|trim');
	    $this->form_validation->set_rules('status'		  , 'Status'	    , 'required|xss_clean|trim');
	    
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/category/add_category');
	    }
	    else{
	        $dt 				= 	    new DateTime();
	        $category			=		strtolower(str_replace(" ","-",trim($this->input->post('category'))));
	        $category_code	    =		strtolower(trim($this->input->post('category_code')));
	        $status			    =		strtolower(trim($this->input->post('status')));
	        $description		=		strtolower(trim($this->input->post('description')));
	        $data_category		=		array('category'=>$category,'category_code'=>$category_code,'status'=>$status,
	            'description'=>$description,'create_by'=>$this->session->userdata('ad_id'));
	        $insert_id			=		$this->category_model->insert_category($data_category);
	        
	        $this->session->set_flashdata('message', "<i category='icon fa fa-check'></i>category Added Successfully");
	        return redirect("admin/master/category/index");
	        //return redirect("master/Activity/edit/$insert_id");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	
	/// edit
	public function edit($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit category','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list	=	$this->category_model->view_category($list_id);
	    $this->form_validation->set_error_delimiters('<p category="font-bold col-pink">', '</p>');
	    //$this->form_validation->set_rules('category'					, 'category'				, 'required|xss_clean');
	    $this->form_validation->set_rules('description'		, 'Description'	, 'required|xss_clean');
	    $this->form_validation->set_rules('status'		    , 'Status'	    , 'required|xss_clean|trim');
	    
	    if($this->form_validation->run()==false){
	        $this->load->view('adminlte/master/category/edit_category',['list'=>$list]);
	    }
	    else{
	        $dt 						= 	    new DateTime();
	        //$category					=		strtolower(str_replace(" ","-",trim($this->input->post('category'))));
	        $description		        =		strtolower($this->input->post('description'));
	        $status			            =		strtolower(trim($this->input->post('status')));
	        $data_category			    =		array(
	            //'category'=>$category,
	            'description'=>"$description",'status'=>$status,'update_by'=>$this->session->userdata('ad_id'));
	        
	        $this->category_model->update_category($data_category,$list_id);
	        $this->session->set_flashdata('message', "<i category='icon fa fa-check'></i>category Updated Successfully");
	        return redirect("admin/master/category/index");
	    }
	    $this->load->view('adminlte/panel/footer');
	}
	////// view
	public function view($list_id){
	    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'View category','menu_auth'=>$this->menu_auth]);
	    $this->load->view('adminlte/panel/sidebar');
	    $list=$this->category_model->view_category($list_id);
	    $this->load->view('adminlte/master/category/view_category',['list'=>$list]);
	    $this->load->view('adminlte/panel/footer');;
	}
	//////delete
	public function delete($list_id) {
	    $this->category_model->delete_category($list_id);
	    $this->session->set_flashdata('message', "<i category='icon fa fa-check'></i>category Successfully Deleted!");
	    redirect('admin/master/category/index');
	}
	public function get_class_subject(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject($postData);
	    echo json_encode($data);
	}
	
	public function get_class_subject_faculty(){
	    $postData   =   $this->input->post();
	    $data       =   $this->adminlte_model->get_class_subject_faculty($postData);
	    echo json_encode($data);
	}
	
	public function search(){
	    //print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
	        'category_code'    =>  strtolower(trim($this->input->post('category_code'))),
	        'order_by'		   =>  strtolower(trim($this->input->post('order_by'))),
	        'seach_term'	   =>  strtolower(trim($this->input->post('seach_term')))
	    );
	    if(
	        (
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) 	|| 
	            (isset($data_taskpo['category_code'])	&& !empty($data_taskpo['category_code'])) 
	        )
	        &&(
	            (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	|| (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))
	            )
	        ){
	            
	            $list           =	$this->category_model->search($data_taskpo);
	            $category       =   $this->adminlte_model->category_lists();
	            $links=''; 
	            
	            $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'category List','list'=>$list,
	                'link'=>$links,'menu_auth'=>$this->menu_auth]);
	            $this->load->view('adminlte/panel/sidebar');
	            $this->load->view('adminlte/master/category/category',['category'=>$category,'data_taskpo'=>$data_taskpo]);
	            $this->load->view('adminlte/panel/footer');
	    }
	    else{
	        return redirect('admin/master/Category');
	    }
	}
}
?>
