<?php defined('BASEPATH')or exit('NO Direc Access is Allowed'); ?>

<?php
 class Course extends MY_Controller{

   public function __construct(){
     parent::__construct();
      $this->load->model('admin/course/Coursemodel','course_model');
      $this->load->model('admin/Adminltemodel','adminlte_model');
      $this->load->model('admin/master/Facultymodel','faculty_model');
      $this->load->model('CommonModel','common_model');
      $this->load->library(['form_validation','bcrypt','email','session','pagination']);
      $this->load->helper(['html','form','url','security','string']);
      //$this->load->model('AdminlteModel','adminlte_model');
      if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
      if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
      if($this->session->userdata('ss_id') ){return redirect('student/signin');}
      $list_id					=		$this->session->userdata('ad_id');
      $this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
      //echo $this->session->userdata('ad_id');die;
      error_reporting(0);
      date_default_timezone_set('Asia/Calcutta');
   }
   public function addrow(){
       $this->load->view("adminlte/courses/add_row", array());
   }
   public function class_calendar($course_id){
     //$this->load->library('calendar');
    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>"{$list[0]->course_name} - Classes List",'list'=>$list,'link'=>$links]);
    $this->load->view('adminlte/panel/sidebar');
    $list = $this->course_model->calendar_class_list($course_id);
    $this->load->view("adminlte/courses/class_calendar", array('course_id'=>$course_id,'course_name'=>$list[0]->course_name));
    $this->load->view('adminlte/panel/footer');
   }

   public function get_events(){
        // Our Start and End Dates
        $start = $this->input->get("start");
        $end = $this->input->get("end");
        $courseid = $this->input->get("course_id");
        $startdt = new DateTime('now'); // setup a local datetime
        $startdt->setTimestamp($start); // Set the date based on timestamp
        $start_format = $startdt->format('Y-m-d H:i:s');
        $enddt = new DateTime('now'); // setup a local datetime
        $enddt->setTimestamp($end); // Set the date based on timestamp
        $end_format = $enddt->format('Y-m-d H:i:s');
        $events = $this->course_model->calendar_class_list($courseid);
        $data_events = array();
        foreach($events as $r) {
            $data_events[] = array(
                "id" => $r->id,
                "title" => $r->subject_id,
                "description" => $r->course_name,
                "end" => $r->class_date." ".$r->class_end_time,
                "start" => $r->class_date." ".$r->class_start_time,
                "day" => strtoupper(date("l",strtotime($r->class_date))),
                "faculty" => strtoupper($r->faculty),
                "category" => strtoupper($r->category_id),
                "class" => strtoupper($r->class_id),
                "subject" => strtoupper($r->subject_id),
                "class_name" => $r->class_name,
            );
        }

        echo json_encode(array("events" => $data_events));
        exit();
    }
    public function get_events_month_calendar(){
         // Our Start and End Dates
         // $start = $this->input->get("start");
         // $end = $this->input->get("end");
         // $courseid = $this->input->get("course_id");
         // $startdt = new DateTime('now'); // setup a local datetime
         // $startdt->setTimestamp($start); // Set the date based on timestamp
         // $start_format = $startdt->format('Y-m-d H:i:s');
         // $enddt = new DateTime('now'); // setup a local datetime
         // $enddt->setTimestamp($end); // Set the date based on timestamp
         // $end_format = $enddt->format('Y-m-d H:i:s');
         $events = $this->course_model->course_class_list_month_calender();
         $data_events = array();
         foreach($events as $r) {
             $data_events[] = array(
                 "id" => $r->id,
                 "title" => $r->subject_id,
                 "description" => $r->course_name,
                 "end" => $r->class_date." ".$r->class_end_time,
                 "start" => $r->class_date." ".$r->class_start_time,
                 "day" => strtoupper(date("l",strtotime($r->class_date))),
                 "faculty" => strtoupper($r->faculty),
                 "category" => strtoupper($r->category_id),
                 "class" => strtoupper($r->class_id),
                 "subject" => strtoupper($r->subject_id),
                 "class_name" => $r->class_name,
             );
         }

         echo json_encode(array("events" => $data_events));
         exit();
     }

  public function studentschedulelist(){
     $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
     if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
     $config = [
         'base_url'					    =>	site_url('admin/course/Course/studentschedulelist'),
         'total_rows'			     	=>	$this->course_model->studentschedulelist_list_num_rows(),
         'per_page'				    	=>	$perpage,
         'display_pages'		    =>	TRUE,
         'use_page_numbers'	    => 	TRUE,
         'uri_segment'				  =>	5,
         'num_links'					  =>	10,
         'page_query_string'    => 	FALSE,
         'full_tag_open'			  =>	"<ul class='pagination pagination-sm'>",
         'full_tag_close'		    =>	"</ul>",
         'first_tag_open'		    =>	'<li>',
         'first_tag_close'		  =>	'</li>',
         'last_tag_open'			  =>	'<li>',
         'last_tag_close'		    =>	'</li>',
         'next_tag_open'			  =>	'<li>',
         'next_tag_close'		    =>	'</li>',
         'prev_tag_open'			  =>	'<li>',
         'prev_tag_close'		    =>	'</li>',
         'num_tag_open'			    =>	'<li>',
         'num_tag_close'			  =>	'</li>',
         'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
         'cur_tag_close'			  =>	'</a></li>',
     ];
     $this->pagination->initialize($config);
     $page 		                  =    ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
     $list 		                  =    $this->course_model->studentschedulelist_list($config['per_page'],$page);
     $links		                  =	   $this->pagination->create_links();

     $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Student Schedule List','list'=>$list,'link'=>$links]);
     $this->load->view('adminlte/panel/sidebar');
     $this->load->view('adminlte/courses/studentschedulelist');
     $this->load->view('adminlte/panel/footer');
 }

 public function studentschedule($studentid){
    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
    if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
  //  echo $this->course_model->studentscheduleid_num_rows($studentid);die;
    $config = [
        'base_url'					    =>	site_url("admin/course/Course/studentschedule/{$studentid}"),
        'total_rows'			     	=>	$this->course_model->studentscheduleid_num_rows($studentid),
        'per_page'				    	=>	$perpage,
        'display_pages'		      =>	TRUE,
        'use_page_numbers'	    => 	TRUE,
        'uri_segment'				    =>	6,
        'num_links'					    =>	10,
        'page_query_string'     => 	FALSE,
        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
        'full_tag_close'		    =>	"</ul>",
        'first_tag_open'		    =>	'<li>',
        'first_tag_close'		    =>	'</li>',
        'last_tag_open'			    =>	'<li>',
        'last_tag_close'		    =>	'</li>',
        'next_tag_open'			    =>	'<li>',
        'next_tag_close'		    =>	'</li>',
        'prev_tag_open'			    =>	'<li>',
        'prev_tag_close'		    =>	'</li>',
        'num_tag_open'			    =>	'<li>',
        'num_tag_close'			    =>	'</li>',
        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
        'cur_tag_close'			    =>	'</a></li>',
    ];
    $this->pagination->initialize($config);
    $page 		                  =    ($this->uri->segment(6)) ? $this->uri->segment(6) : 1;
  //  print_r(array($studentid,$config['per_page'],$page));die;
    $list 		                  =    $this->course_model->studentscheduleid($studentid,$config['per_page'],$page);
    $links		                  =	   $this->pagination->create_links();
    $student_m                  =    strtoupper($list[0]->student_name);
    $class_data                 =    $this->course_model->studentscheduleid_count_class($studentid);
    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>"{$student_m} class Schedule",
    'list'=>$list,'link'=>$links,'class_count'=>$class_data->class_count,'course_count'=>$class_data->course_count]);
    $this->load->view('adminlte/panel/sidebar');
    $this->load->view('adminlte/courses/student_schedule');
    $this->load->view('adminlte/panel/footer');
}
 public function teacherschedulelist(){
    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
    if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
    $config = [
        'base_url'					    =>	site_url('admin/course/Course/teacherschedulelist'),
        'total_rows'			     	=>	$this->course_model->teacher_schedule_list_num_rows(),
        'per_page'				    	=>	$perpage,
        'display_pages'		      =>	TRUE,
        'use_page_numbers'	    => 	TRUE,
        'uri_segment'				    =>	5,
        'num_links'					    =>	10,
        'page_query_string'     => 	FALSE,
        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
        'full_tag_close'		    =>	"</ul>",
        'first_tag_open'		    =>	'<li>',
        'first_tag_close'		    =>	'</li>',
        'last_tag_open'			    =>	'<li>',
        'last_tag_close'		    =>	'</li>',
        'next_tag_open'			    =>	'<li>',
        'next_tag_close'		    =>	'</li>',
        'prev_tag_open'			    =>	'<li>',
        'prev_tag_close'		    =>	'</li>',
        'num_tag_open'			    =>	'<li>',
        'num_tag_close'			    =>	'</li>',
        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
        'cur_tag_close'			    =>	'</a></li>',
    ];
    $this->pagination->initialize($config);
    $page 		                  =    ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
    $list 		                  =    $this->course_model->teacher_schedule_list($config['per_page'],$page);
    $links		                  =	   $this->pagination->create_links();

    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Teacher Schedule List','list'=>$list,'link'=>$links]);
    $this->load->view('adminlte/panel/sidebar');
    $this->load->view('adminlte/courses/teacherschedulelist');
    $this->load->view('adminlte/panel/footer');
}
public function teacher_schedule($teacherid){
   $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
   if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
 //  echo $this->course_model->studentscheduleid_num_rows($studentid);die;
   $config = [
       'base_url'					    =>	site_url("admin/course/Course/teacher_schedule/{$teacherid}"),
       'total_rows'			     	=>	$this->course_model->teacher_schedule_by_id_num_rows($teacherid),
       'per_page'				    	=>	$perpage,
       'display_pages'		      =>	TRUE,
       'use_page_numbers'	    => 	TRUE,
       'uri_segment'				    =>	6,
       'num_links'					    =>	10,
       'page_query_string'     => 	FALSE,
       'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
       'full_tag_close'		    =>	"</ul>",
       'first_tag_open'		    =>	'<li>',
       'first_tag_close'		    =>	'</li>',
       'last_tag_open'			    =>	'<li>',
       'last_tag_close'		    =>	'</li>',
       'next_tag_open'			    =>	'<li>',
       'next_tag_close'		    =>	'</li>',
       'prev_tag_open'			    =>	'<li>',
       'prev_tag_close'		    =>	'</li>',
       'num_tag_open'			    =>	'<li>',
       'num_tag_close'			    =>	'</li>',
       'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
       'cur_tag_close'			    =>	'</a></li>',
   ];
   $this->pagination->initialize($config);
   $page 		                  =    ($this->uri->segment(6)) ? $this->uri->segment(6) : 1;
 //  print_r(array($studentid,$config['per_page'],$page));die;
   $list 		                  =    $this->course_model->teacher_schedule_by_id($teacherid,$config['per_page'],$page);
   $links		                  =	   $this->pagination->create_links();
   $faculty_m                  =    strtoupper($list[0]->faculty);
   $class_data                 =    $this->course_model->teacher_schedule_by_id_count_class($teacherid);
   $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>"{$faculty_m} class Schedule",
   'list'=>$list,'link'=>$links,'class_count1'=>$class_data->class_count,'course_count'=>$class_data->course_count,'course_names'=>$class_data->course_names]);
   $this->load->view('adminlte/panel/sidebar');
   $this->load->view('adminlte/courses/teacher_schedule');
   $this->load->view('adminlte/panel/footer');
}

  public function index(){
     $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
     if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
     $config = [
         'base_url'					    =>	site_url('admin/course/Course/index'),
         'total_rows'			     	=>	$this->course_model->course_list_num_rows(),
         'per_page'				    	=>	$perpage,
         'display_pages'		    =>	TRUE,
         'use_page_numbers'	    => 	TRUE,
         'uri_segment'				  =>	5,
         'num_links'					  =>	10,
         'page_query_string'    => 	FALSE,
         'full_tag_open'			  =>	"<ul class='pagination pagination-sm'>",
         'full_tag_close'		    =>	"</ul>",
         'first_tag_open'		    =>	'<li>',
         'first_tag_close'		  =>	'</li>',
         'last_tag_open'			  =>	'<li>',
         'last_tag_close'		    =>	'</li>',
         'next_tag_open'			  =>	'<li>',
         'next_tag_close'		    =>	'</li>',
         'prev_tag_open'			  =>	'<li>',
         'prev_tag_close'		    =>	'</li>',
         'num_tag_open'			    =>	'<li>',
         'num_tag_close'			  =>	'</li>',
         'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
         'cur_tag_close'			  =>	'</a></li>',
     ];
     $this->pagination->initialize($config);
     $page 		                  =    ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
     $list 		                  =    $this->course_model->course_list($config['per_page'],$page);
     $links		                  =	   $this->pagination->create_links();

     $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Course List','list'=>$list,'link'=>$links]);
     $this->load->view('adminlte/panel/sidebar');
     $this->load->view('adminlte/courses/courselist');
     $this->load->view('adminlte/panel/footer');
 }
 public function course_class_list($courseid){
    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
    if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
    $config = [
        'base_url'					    =>	site_url("admin/course/Course/course_class_list/$courseid"),
        'total_rows'			     	=>	$this->course_model->course_class_list_num_rows($courseid),
        'per_page'				    	=>	$perpage,
        'display_pages'		     	=>	TRUE,
        'use_page_numbers'	    => 	TRUE,
        'uri_segment'				    =>	6,
        'num_links'					    =>	10,
        'page_query_string'     => 	FALSE,
        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
        'full_tag_close'		    =>	"</ul>",
        'first_tag_open'		    =>	'<li>',
        'first_tag_close'		    =>	'</li>',
        'last_tag_open'			    =>	'<li>',
        'last_tag_close'		    =>	'</li>',
        'next_tag_open'			    =>	'<li>',
        'next_tag_close'		    =>	'</li>',
        'prev_tag_open'			    =>	'<li>',
        'prev_tag_close'		    =>	'</li>',
        'num_tag_open'			    =>	'<li>',
        'num_tag_close'			    =>	'</li>',
        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
        'cur_tag_close'			    =>	'</a></li>',
    ];
    $this->pagination->initialize($config);
    $page 		                  =    ($this->uri->segment(6)) ? $this->uri->segment(6) : 1;
    $list 		                  =    $this->course_model->course_class_list($config['per_page'],$page,$courseid);
    $links		                  =	   $this->pagination->create_links();

    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>"{$list[0]->course_name} - Classes List",'list'=>$list,'link'=>$links]);
    $this->load->view('adminlte/panel/sidebar');
    $this->load->view('adminlte/courses/course_class_list');
    $this->load->view('adminlte/panel/footer');
}

   public function create(){
     $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Course','menu_auth'=>$this->menu_auth]);
     $this->load->view('adminlte/panel/sidebar');
      $this->form_validation->set_error_delimiters('<p class="font-bold text-red">', '</p>');
      $this->form_validation->set_rules('parallel_session_purchased' , 'Parallel Session'				 , 'required|xss_clean|trim');
      $this->form_validation->set_rules('category'			             , 'Category'				         , 'required|xss_clean|trim');
      $this->form_validation->set_rules('class'			                 , 'Class'				           , 'required|xss_clean|trim');
      $this->form_validation->set_rules('subject'			               , 'Subject'				         , 'required|xss_clean|trim');
      $this->form_validation->set_rules('faculty'		                 , 'Faculty'                 , 'required|xss_clean|trim');
      $this->form_validation->set_rules('week_days[]'		             , 'Week Days'		           , 'required|xss_clean|trim');
      $this->form_validation->set_rules('course_duration_hours'		   , 'Course Duration'         , 'required|xss_clean|trim');
      $this->form_validation->set_rules('class_unit_price'		       , 'Class Unit Price'        , 'required|xss_clean|trim');
      $this->form_validation->set_rules('course_start_from'		       , 'Course Start From'       , 'required|xss_clean|trim');
      $this->form_validation->set_rules('remarks'		                 , 'Remarks'                 , 'xss_clean|trim');
      //$class                                  =       $this->adminlte_model->getclass();
      $category                               =       $this->adminlte_model->getcategory();
      $parallel_session                       =       $this->adminlte_model->get_parallel_session();
      if($this->form_validation->run()==false){
          $this->load->view('adminlte/courses/add_course',['class'=>$class,'category'=>$category,'session'=>$parallel_session]);
      }
      else{
          $dt 							           = 	  new DateTime();
          $parallel_session_purchased	 =		strtolower($this->input->post('parallel_session_purchased'));
          $category						         =		strtolower($this->input->post('category'));
          $class						           =		strtolower($this->input->post('class'));
          $subject							       =		strtolower($this->input->post('subject'));
          $faculty				             =		strtolower($this->input->post('faculty'));
          $course_duration_hours			 =		strtolower($this->input->post('course_duration_hours'));
          $class_unit_price				     =		strtolower($this->input->post('class_unit_price'));
          $course_start_from					 =		strtolower($this->input->post('course_start_from'));

          $remarks	                   =		strtolower($this->input->post('remarks'));
          $week_days							     =    implode(',',$_POST['week_days']);
          //$week_day_ls				       =	  $_POST['week_days'];
          $faculty_name                =    $this->faculty_model->view_faculty($faculty);
          //echo "<pre>";print_r($faculty_name);die;

          $course_name			 =	$this->course_model->fetch_course_code('1');
          $current	         =	$course_name->course_code;
          $code			         =	(int)$current;
          $code			         =	$code+1;
          if(strlen($code)==1){$newcode="0000".$code;}
          if(strlen($code)==2){$newcode="000".$code;}
          if(strlen($code)==3){$newcode="00".$code;}
          if(strlen($code)==4){$newcode="0".$code;}
          if(strlen($code)==5){$newcode=$code;}
          if((strlen($code)>5)||(strlen($newcode)==0)){echo "Please change Invoiceno series older is like 00001";exit;}

          $new_course_code		        =	    strtoupper($faculty_name->category_code.$faculty_name->class_code.$faculty_name->subject_code.
          date("M",strtotime(strtolower($course_start_from))).date("d",strtotime(strtolower($course_start_from))).
          date("y",strtotime(strtolower($course_start_from))).$newcode);

          $data_course						     =	  array('course_name'=>$new_course_code,'parallel_session_purchased'=>$parallel_session_purchased,'category'=>$category,'class'=>$class,'subject'=>$subject,
          'faculty'=>$faculty,'course_duration_hours'=>$course_duration_hours,'class_unit_price'=>$class_unit_price,
          'course_start_from'=>date("Y-m-d",strtotime($course_start_from)),'remarks'=>$remarks,'week_days'=>$week_days,'time_zone'=>"Asia/Kolkata"
          );
          $insert_id							     =	  $this->course_model->add_course($data_course);
          if($insert_id){
            //$this->course_model->update_course_name($new_course_code,$insert_id);
            $this->course_model->update_course_code($newcode,'1');

            return redirect('admin/course/Course');
          }
      }
     $this->load->view('adminlte/panel/footer');
   }

   function course_student_limit($course_id,$studnet_limit){
      $course_id      =   $this->input->post('çourse_id');
      $studnet_limit  =   $this->input->post('studnet_limit');
      $count          =   $this->course_model->course_student_limit($course_id);
      if($count<=$studnet_limit){
        return TRUE;
      }else{
        $this->form_validation->set_message('course_student_limit',"Student limit can't exceed more than ".$studnet_limit);
        return FALSE;
      }
   }

   public function edit_course_student($courseid){
     $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit Course Student','menu_auth'=>$this->menu_auth]);
     $this->load->view('adminlte/panel/sidebar');
     $this->form_validation->set_error_delimiters('<p class="font-bold text-red">', '</p>');

      $this->form_validation->set_rules('course_id', 'Course id', 'required|xss_clean|trim');
      $category                           =       $this->adminlte_model->getcategory();
      $student                            =       $this->course_model->student_lists();
      $course_name                        =       $this->course_model->course_id_name($courseid);
      $course_stu_list                    =       $this->course_model->total_course_student_list($courseid);
      //print_r($course_stu_list);die;
      if($this->form_validation->run()==false){
          $this->load->view('adminlte/courses/edit_course_student',['student'=>$student,'course'=>$course_name,'course_student_list'=>$course_stu_list,'active_student'=>$course_act_stu_list]);
      }
      else{
          $course_id			                 =		strtolower($this->input->post('course_id'));

          $i=0;
        foreach($_POST['student'] as $student){
            $finduserid  =  $this->course_model->find_usercategory_userid($student);
            if($finduserid->userid==""){
              $getcode			     =	$this->course_model->fetch_usercategory_code('student');
              $current	         =	$getcode->code;
              $code3			       =	(int)$current;
              $code			         =	$code3+1;
              if(strlen($code)==1){$newcode="0000".$code;}
              if(strlen($code)==2){$newcode="000".$code;}
              if(strlen($code)==3){$newcode="00".$code;}
              if(strlen($code)==4){$newcode="0".$code;}
              if(strlen($code)==5){$newcode=$code;}
              if((strlen($code)>5)||(strlen($newcode)==0)){echo "Please change Invoiceno series older is like 00001";exit;}

              $this->course_model->update_userid_masteruser($student,strtoupper($getcode->main_code.$newcode));
              $this->course_model->update_code_usercategory($code,'student');
            }
            $data_course_vise_student		   =	  array('course_id'=>$course_id,'student_id'=>$student,
            'joining_date'=>date("Y-m-d",strtotime($_POST['joining_date'][$i])),'status'=>$_POST['status'][$i],'remarks'=>$_POST['remarks'][$i]);
            $counter_stu                   =    $this->course_model->count_duplicate_student_course($course_id,$student);

            if($counter_stu==0){
              $insert_id							     =	  $this->course_model->add_course_vise_student($data_course_vise_student);
            }else{
              $data_array                  =    array('joining_date'=>date("Y-m-d",strtotime($_POST['joining_date'][$i])),
              'status'=>$_POST['status'][$i],'remarks'=>$_POST['remarks'][$i]);
              $update_id							     =	  $this->course_model->update_course_vise_student($course_id,$student,$data_array);
            }
            $i++;
        }
          return redirect('admin/course/Course');
      }
     $this->load->view('adminlte/panel/footer');
   }

   public function week_or_custom_date($contact, $otherField) {
       return ($contact != '' || $this->input->post($otherField) != '');
   }




   public function add_class_as_well_student_to_course($course_id){

     $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Class to Course','menu_auth'=>$this->menu_auth]);
     $this->load->view('adminlte/panel/sidebar');
     $this->form_validation->set_error_delimiters('<p class="font-bold text-red">', '</p>');

      $this->form_validation->set_rules('course_id'		               , 'Course id'               , 'required|xss_clean|trim');

      //$class                                =       $this->adminlte_model->getclass();
      $category                               =       $this->adminlte_model->getcategory();
      $student                                =       $this->course_model->student_lists();
      $faculty_list                           =       $this->course_model->course_wise_faculty_list($course_id);
      $course_name                            =       $this->course_model->course_id_name($course_id);
      $course_act_stu_list                    =       $this->course_model->total_course_active_student_list($course_id);
      //echo "<pre>";print_r($faculty_list);die;
      if($this->form_validation->run()==false){
          $this->load->view('adminlte/courses/add_class_as_well_student_to_course',['faculty'=>$faculty_list,'course'=>$course_name,'active_student'=>$course_act_stu_list]);
      }
      else{
      // echo "<pre>";print_r($_POST);die;
          $courseid				             =		strtolower($this->input->post('course_id'));
          $studnet_limit				       =		strtolower($this->input->post('studnet_limit'));
          $student_array               =    array();
          $student_array               =    $_POST['student_id'];
          $i                           =    0;
          foreach($_POST['class_date'] as $class_date){
            //$_POST['student_id'];

            $class_duration              =   $_POST['class_duration_mins'][$i];
            $extend_duration             =   $_POST['extend_duration_mins'][$i];
            $class_start_time            =   date("H:i", strtotime($_POST['class_start_time'][$i]));
            $total_duration_min          =   $class_duration+$extend_duration;
            $time1 		                   =   strtotime($class_start_time);
            $class_end_time 	           =   date("H:i", strtotime("+$total_duration_min minutes", $time1));

            $faculty                     =   $_POST['faculty'][$i];
            $remarks                     =   $_POST['remarks'][$i];
            $class_status				         =	 strtolower('create');

            $faculty_name                =    $this->course_model->view_faculty($faculty);
            $category                    =    $this->adminlte_model->getcategory();
            $student                     =    $this->course_model->student_lists();
            $faculty_list                =    $this->course_model->course_wise_faculty_list($courseid);
            $course_name                 =    $this->course_model->course_id_name($courseid);
            $subject_id									 =		$this->course_model->subject_name_from_course($courseid);


            require_once APPPATH. '/plugins/wiziq/classCode/create.php';
            $schedule 					         =		new ScheduleClass();
            $secretAcessKey				       =	  "yOEQY4Y6HJG2Swp2CZ+q2A==";
            $access_key					         =	  "7DpOH0SG9m8=";
            $webServiceUrl 				       =	  "http://classapi.wiziqxt.com/apimanager.ashx";
            //date_default_timezone_set('UTC');
            date_default_timezone_set('Asia/Kolkata');
            $date                        =     date("m/d/Y", strtotime($class_date));
            $no_class_count              =     "0";

            $schedule->presenter_id 					=		$faculty;
            $schedule->presenter_name 				=		strtoupper($faculty_name->userid)." | ".ucfirst($faculty_name->first_name).' '.ucfirst($faculty_name->last_name);
            $time										          =		$date." ".$class_start_time;
            $schedule->start_time 						=		$time;
            //$schedule->title 							  =		strtoupper($course_name->course_name)." | ".strtoupper($subject_id->class_id)." [ ".strtoupper($subject_id->subject_id)." ]";
            $schedule->title 							    =		strtoupper($course_name->course_name)." | ".strtoupper($subject_id->subject_id)." | ". date("d-M-Y", strtotime(strtolower($class_date)));
            $schedule->duration 						  =		$class_duration;
            $schedule->time_zone 						  =		"Asia/Kolkata";
            $schedule->attendee_limit 				=	   $course_name->attendee_limit;
            $schedule->create_recording 			=		'true';
            $schedule->return_url 						=		site_url('lobby');
            if($extend_duration!=""){$schedule->extend_duration=$extend_duration;}
            $schedule->status_ping_url 				=		site_url('class-status');
            $schedule->language_culture_name 	=		"en-us";

            //echo "<pre>";print_r($schedule);die;
            $response 									      =		$schedule->createClass($secretAcessKey,$access_key,$webServiceUrl);
            //echo "<pre>";print_r($response);

            if(empty($response['errorcode'])){
                $method			                  =	  $response['method'];
                $class_id			                =	  $response['class_id'];
                $recording_url		            =	  $response['recording_url'];
                $presenter_email	            =	  $response['presenter_email'];
                $presenter_url		            =	  $response['presenter_url'];
                $class_date                   =   date("Y-m-d", strtotime($date));

                if($extend_duration!=""){ $exttim= (int) $extend_duration;}else{ $exttim =0;}
                $totaltime  = $class_duration+$exttim;
                $hr_cal     = (int) $totaltime/60;
                //$min_cal = $time%60;
                //echo "Hours ".round($hr_cal,2)." Min Cal ".round(strstr($hr_cal,'.',false),2);
                if((round($hr_cal,2)>=0.5)&&(round($hr_cal,2)<0.75)){
                  $hr_calculate = 0.5;
                }
                else if((round($hr_cal,2)>=0.75)&&(round($hr_cal,2)<1.25)){
                  $hr_calculate =1;
                }
                else if((round($hr_cal,2)>=1.25)&&(round($hr_cal,2)<1.75)){
                  $hr_calculate = 1.5;
                }
                else if((round($hr_cal,2)>=1.75)&&(round($hr_cal,2)<2.25)){
                  $hr_calculate = 2;
                }
                else if((round($hr_cal,2)>=2.25)&&(round($hr_cal,2)<2.75)){
                  $hr_calculate = 2.5;
                }
                else if((round($hr_cal,2)>=2.75)&&(round($hr_cal,2)<3.25)){
                  $hr_calculate = 3;
                }
                else if((round($hr_cal,2)>=3.25)&&(round($hr_cal,2)<3.75)){
                  $hr_calculate = 3.5;
                }
                else if((round($hr_cal,2)>=3.75)&&(round($hr_cal,2)<4.25)){
                  $hr_calculate = 4;
                }
                else if((round($hr_cal,2)>=4.25)&&(round($hr_cal,2)<4.75)){
                  $hr_calculate = 4.5;
                }
                else if((round($hr_cal,2)>=4.75)&&(round($hr_cal,2)<5.25)){
                  $hr_calculate = 5;
                }else{
                  $hr_calculate = $hr_cal;
                }
                $course_price_hour = $this->course_model->course_hour_unit_price($courseid);
                $class_price_after_calculate_hour_unit= $hr_calculate* $course_price_hour->class_unit_price;

                $data_class_info              =   array('course_id'=>$courseid,'class_name'=>$class_id,
                    "class_date"=>$class_date,'class_start_time'=>$class_start_time,"class_end_time"=>$class_end_time,
                    'class_amount'=>$class_price_after_calculate_hour_unit,
                    "class_duration_min"=>$class_duration,"faculty_id"=>$faculty,"class_status"=>$class_status,
                    "class_extended_min"=>$extend_duration,"remarks"=>$remarks,"method"=>$method,
                    "teacher_cls_url"=>$presenter_url,"teacher_rec_url"=>$recording_url);
                $classid_gene                 =   $this->course_model->add_course_class_live_created($data_class_info);
                ////////////////////////////////////////////////////////////////////////////////////////////////////////
                foreach($student_array as $student){

                  $st_wallet_amount = $this->course_model->course_student_wallet($student);
                  //$course_price_hour->class_unit_price
                  //$st_wallet_amount->wallet_amount;
                  if($st_wallet_amount->wallet_amount>=$class_price_after_calculate_hour_unit){

                      require_once APPPATH. '/plugins/wiziq/classCode/AddAttendee.php';
                      $secretAcessKey					      =		"yOEQY4Y6HJG2Swp2CZ+q2A==";
                      $access_key						        = 	"7DpOH0SG9m8=";
                      $webServiceUrl 				        =		"http://classapi.wiziqxt.com/apimanager.ashx";
                      $attendee 				            =	  new AddAttendee();
                      $xml 						              = 	new SimpleXMLElement('<attendee_list></attendee_list>');
                      $attendee_id			            =	  "<![CDATA[".$student."]]>";
                      $student_id				            =	  $this->course_model->student_name($student);
                      $stud_userid                  =   strtoupper($student_id->userid);
                      $stud_first                   =   $student_id->first_name;
                      $stud_last                    =   $student_id->last_name;
                      $screen_name			            =	  "<![CDATA[".$stud_userid.' | '.$stud_first.' '.$stud_last."]]>";
                      $language_culture_name	      =	  "<![CDATA["."en-us"."]]>";
                      $person                       =    $xml->addChild('attendee');
                      $person->addChild('attendee_id', "$attendee_id");
                      $person->addChild('screen_name', "$screen_name");
                      $person->addChild('language_culture_name', "$language_culture_name");
                      //  print_r($xml->asXML());
                      $XMLAttendee1				           =	str_replace('<?xml version="1.0"?>',"",$xml->asXML());
                      $XMLAttendee2				           =	str_replace("&lt;","<",$XMLAttendee1);
                      $attendee->XMLAttendee	       =	str_replace("&gt;",">",$XMLAttendee2);
                      //echo "<pre>"; print_r($attendee->XMLAttendee);
                      $attendee->class_id			       =	trim($class_id);//"386549";
                      $response2            	       = 	$attendee->InsertAttendee($secretAcessKey,$access_key,$webServiceUrl);
                      // $response3				             =  json_encode($response2);
                      //print_r($response2);die;
                      // $response['method'];
                      // $response['attendee_class_id'];
                      // $response['add_attendees_status'];
                      // $response['attendee_urls'];
                      foreach($response2['attendee_urls']as $data){
                        $test_url    =	explode("<=>",$data);
                        $att_data    =  array('course_id'=>$courseid,'class_id'=>$classid_gene,'student_id'=>$test_url[0],
                        'class_amount'=>$class_price_after_calculate_hour_unit,'st_url'=>$test_url[1]);
                        $inse_id     =  $this->course_model->insert_course_class_student($att_data);
                      }
                      $lef_st_amount =  $st_wallet_amount->wallet_amount-$class_price_after_calculate_hour_unit;
                      $this->course_model->update_current_amount_student($lef_st_amount,$student);
                    }
                }

                /////////////////////////////////////////////////////////////////////////////////////////////////////////////
                unset($class_date);
            }else{
                $this->session->set_flashdata('failure', "<i class='icon fa fa-check'></i>class Not Added Successfully".$response['errorcode']." ".$response['errormsg']);
                return redirect("admin/course/Course/add_class_as_well_student_to_course/$courseid");
            }

            $i++;
          }
          $this->session->set_flashdata('success', "<i class='icon fa fa-check'></i>class added  Successfully");
          return redirect("admin/course/Course/add_class_as_well_student_to_course/$courseid");
      }
     $this->load->view('adminlte/panel/footer');
   }

   public function add_student_to_specific_class($classid){

       $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add more student to class','menu_auth'=>$this->menu_auth]);
       $this->load->view('adminlte/panel/sidebar');
       $this->form_validation->set_error_delimiters('<p category="font-bold col-pink">', '</p>');
       $this->form_validation->set_rules('class_id'	                      , 'Class Id'	          , 'required|xss_clean|trim');
       $this->form_validation->set_rules('course_id'		                  , 'Course Name'	        , 'required|xss_clean|trim');
      // $this->form_validation->set_rules('student_id[]'		                  , 'Student'	            , 'required|xss_clean|trim');

       $class_detail                   =       $this->course_model->class_detail($classid);
       $category                       =       $this->adminlte_model->getcategory();
       $student                        =       $this->course_model->student_lists();
       $faculty_list                   =       $this->course_model->course_wise_faculty_list($class_detail->course_id);
       $course_name                    =       $this->course_model->course_id_name($class_detail->course_id);
       $course_act_stu_list            =       $this->course_model->total_course_active_student_list($class_detail->course_id);
       $course_stu_list                =       $this->course_model->total_course_active_student_list_drop($class_detail->course_id);
       $student_list_34_               =       $this->course_model->class_id_student_per_($classid);
       $active_student_class_not_alloted =array_diff_key($course_stu_list,$student_list_34_);
       //print_r($res);die;
       if($this->form_validation->run()==false){ //echo "false"; echo "<pre>";print_r($_POST);die;
           $this->load->view('adminlte/courses/add_student_to_specific_class',['class'=>$class_detail,
           'faculty'=>$faculty_list,'course'=>$course_name,'active_student'=>$course_act_stu_list,
           'active_student_not_in_class'=>$active_student_class_not_alloted,'student_already_in_class'=>$student_list_34_]);
       }
       else{
        //echo "<pre>";print_r($_POST);die;
         $class_id				             =		strtolower($this->input->post('class_id'));
         $courseid				             =		strtolower($this->input->post('course_id'));
         $studnet_limit				         =		strtolower($this->input->post('studnet_limit'));
         $student_array                =    array();
         $student_array                =    array_unique($_POST['student_id']);
         $class_detail                 =    $this->course_model->class_detail($class_id);

         $class_duration  = $class_detail->class_duration_min;
         $extend_duration = $class_detail->class_extended_min;
          if($extend_duration!=""){ $exttim= (int) $extend_duration;}else{ $exttim =0;}
           $totaltime  = $class_duration+$exttim;
           $hr_cal     = (int) $totaltime/60;
           //$min_cal = $time%60;
           //echo "Hours ".round($hr_cal,2)." Min Cal ".round(strstr($hr_cal,'.',false),2);
           if((round($hr_cal,2)>=0.5)&&(round($hr_cal,2)<0.75)){
             $hr_calculate = 0.5;
           }
           else if((round($hr_cal,2)>=0.75)&&(round($hr_cal,2)<1.25)){
             $hr_calculate =1;
           }
           else if((round($hr_cal,2)>=1.25)&&(round($hr_cal,2)<1.75)){
             $hr_calculate = 1.5;
           }
           else if((round($hr_cal,2)>=1.75)&&(round($hr_cal,2)<2.25)){
             $hr_calculate = 2;
           }
           else if((round($hr_cal,2)>=2.25)&&(round($hr_cal,2)<2.75)){
             $hr_calculate = 2.5;
           }
           else if((round($hr_cal,2)>=2.75)&&(round($hr_cal,2)<3.25)){
             $hr_calculate = 3;
           }
           else if((round($hr_cal,2)>=3.25)&&(round($hr_cal,2)<3.75)){
             $hr_calculate = 3.5;
           }
           else if((round($hr_cal,2)>=3.75)&&(round($hr_cal,2)<4.25)){
             $hr_calculate = 4;
           }
           else if((round($hr_cal,2)>=4.25)&&(round($hr_cal,2)<4.75)){
             $hr_calculate = 4.5;
           }
           else if((round($hr_cal,2)>=4.75)&&(round($hr_cal,2)<5.25)){
             $hr_calculate = 5;
           }else{
             $hr_calculate = $hr_cal;
           }
           $course_price_hour = $this->course_model->course_hour_unit_price($courseid);
           $class_price_after_calculate_hour_unit= $hr_calculate* $course_price_hour->class_unit_price;

          foreach($student_array as $student){

              $st_wallet_amount = $this->course_model->course_student_wallet($student);
                  //$course_price_hour->class_unit_price
                  //$st_wallet_amount->wallet_amount;
            if($st_wallet_amount->wallet_amount>=$class_price_after_calculate_hour_unit){
               require_once APPPATH. '/plugins/wiziq/classCode/AddAttendee.php';
               $secretAcessKey					    =		"yOEQY4Y6HJG2Swp2CZ+q2A==";
               $access_key						      = 	"7DpOH0SG9m8=";
               $webServiceUrl 				      =		"http://classapi.wiziqxt.com/apimanager.ashx";

               $attendee 				            =	  new AddAttendee();
               $xml 						            = 	new SimpleXMLElement('<attendee_list></attendee_list>');

               $attendee_id			            =	  "<![CDATA[".$student."]]>";
               $student_id				          =	  $this->course_model->student_name($student);
               $stud_userid                 =   strtoupper($student_id->userid);
               $stud_first                  =   $student_id->first_name;
               $stud_last                   =   $student_id->last_name;
               $screen_name			            =	  "<![CDATA[".$stud_userid.' | '.$stud_first.' '.$stud_last."]]>";
               $language_culture_name	      =	  "<![CDATA["."en-us"."]]>";

               $person                      =    $xml->addChild('attendee');
               $person->addChild('attendee_id', "$attendee_id");
               $person->addChild('screen_name', "$screen_name");
               $person->addChild('language_culture_name', "$language_culture_name");
             //  print_r($xml->asXML());
               $XMLAttendee1				        =	  str_replace('<?xml version="1.0"?>',"",$xml->asXML());
               $XMLAttendee2				        =	  str_replace("&lt;","<",$XMLAttendee1);
               $attendee->XMLAttendee	      =	  str_replace("&gt;",">",$XMLAttendee2);
              // echo "<pre>"; print_r($attendee->XMLAttendee);die;
               $attendee->class_id			    =	  trim($class_detail->class_name);//"386549";
              // echo "<pre>"; print_r($attendee->class_id);die;
               $response2            	      = 	$attendee->InsertAttendee($secretAcessKey,$access_key,$webServiceUrl);
               //$response3				          =  json_encode($response2);
               //print_r($response2);die;
               //$response['method'];// $response['attendee_class_id'];// $response['add_attendees_status'];// $response['attendee_urls'];

               foreach($response2['attendee_urls']as $data){
                 $test_url    =	explode("<=>",$data);
                 $att_data    =  array('course_id'=>$courseid,'class_id'=>$class_id,'student_id'=>$test_url[0],'st_url'=>$test_url[1]);
                 $inse_id     =  $this->course_model->insert_course_class_student($att_data);
               }
               $lef_st_amount =  $st_wallet_amount->wallet_amount-$class_price_after_calculate_hour_unit;
              $this->course_model->update_current_amount_student($lef_st_amount,$student);
           }
          }
       $this->session->set_flashdata('message', "<i category='icon fa fa-check'></i>Student Added to class Successfully");
      return redirect("admin/course/Course/course_class_list/{$courseid}");
       }
       $this->load->view('adminlte/panel/footer');

   }

   //////////////////////////////////////
   public function modify_course_class($classid){

       if($classid==""){
           $this->session->set_flashdata('failure', "<i class='icon fa fa-check'></i>Classid should not be blank");
           return redirect("admin/adminlte/course_list");
       }
       $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'modify Course CLass','menu_auth'=>$this->menu_auth]);
       $this->load->view('adminlte/panel/sidebar');
       $this->form_validation->set_error_delimiters('<p class="font-bold text-red">', '</p>');
       $this->form_validation->set_rules('class_id'		          , 'Class'                 , 'required|xss_clean|trim');
       $this->form_validation->set_rules('course_id'		        , 'Course'                , 'required|xss_clean|trim');
       $this->form_validation->set_rules('faculty'		          , 'Faculty'               , 'required|xss_clean|trim');
       $this->form_validation->set_rules('class_date'		        , 'Class Date'		        , 'required|xss_clean|trim');
       $this->form_validation->set_rules('class_start_time'	    , 'Start Time'		        , 'required|xss_clean|trim');
       $this->form_validation->set_rules('class_duration_mins'	, 'Class Duration'		    , 'required|xss_clean|trim');
       $this->form_validation->set_rules('extend_duration_mins'	, 'Extend Duration'		    , 'xss_clean|trim');
       $this->form_validation->set_rules('remarks'	            , 'Extend Duration'		    , 'xss_clean|trim');

       $class_detail                   =       $this->course_model->class_detail($classid);
       $category                       =       $this->adminlte_model->getcategory();
       $student                        =       $this->course_model->student_lists();
       $faculty_list                   =       $this->course_model->course_wise_faculty_list($class_detail->course_id);
       $course_name                    =       $this->course_model->course_id_name($class_detail->course_id);
       $course_act_stu_list            =       $this->course_model->total_course_active_student_list($class_detail->course_id);


       if($this->form_validation->run()==false){
           $this->load->view('adminlte/courses/modify_course_class',['class'=>$class_detail,'faculty'=>$faculty_list,'course'=>$course_name,'active_student'=>$course_act_stu_list]);
       }
       else{
           //print_r($this->input->post('class_id'));die;
           $class_id                    =   $this->input->post('class_id');
           $course_id                   =   $this->input->post('course_id');
           $class_date                  =   $this->input->post('class_date');
           $class_duration              =   $this->input->post('class_duration_mins');
           $extend_duration             =   $this->input->post('extend_duration_mins');
           $class_start_time            =   date("H:i", strtotime($this->input->post('class_start_time')));
           $total_duration_min          =   $class_duration+$extend_duration;
           $time1 		                  =   strtotime($class_start_time);
           $class_end_time 	            =   date("H:i", strtotime("+$total_duration_min minutes", $time1));

           $faculty                     =   $this->input->post('faculty');
           $remarks3                     =   $this->input->post('remarks');
           $class_status				        =	  strtolower('modify');

           $class_detail                =    $this->course_model->class_detail($class_id);
           $faculty_name                =    $this->course_model->view_faculty($faculty);
           $category                    =    $this->adminlte_model->getcategory();
           $student                     =    $this->course_model->student_lists();
           $faculty_list                =    $this->course_model->course_wise_faculty_list($course_id);
           $course_name                 =    $this->course_model->course_id_name($course_id);
           $subject_id									=		 $this->course_model->subject_name_from_course($course_id);

           require_once APPPATH. '/plugins/wiziq/classCode/ModifyClass.php';
           $modify 							              =	  new ModifyClass();
           $secretAcessKey				            =	  "yOEQY4Y6HJG2Swp2CZ+q2A==";
           $access_key					              =	  "7DpOH0SG9m8=";
           $webServiceUrl 				            =	  "http://classapi.wiziqxt.com/apimanager.ashx";
           date_default_timezone_set('Asia/Kolkata');

           $modify->class_id 					        =		 $class_detail->class_name;
           $modify->presenter_id 					    =		 $faculty;
           $modify->presenter_name 				    =		 strtoupper($faculty_name->userid)." | ".ucfirst($faculty_name->first_name).' '.ucfirst($faculty_name->last_name);
           $date                              =    date("m/d/Y", strtotime($class_date));
           $time								              =		 $date." ".$class_start_time;
           //$time 								            =		 date("m/d/Y H:i", strtotime(strtolower($_POST['start_time'])));
           $modify->start_time 					      =		 $time;
           //$subject_id						          =		 $this->adminlte_model->subject_name($res->subject_id);
           $modify->title 							      =		 strtoupper($course_name->course_name)." | ".strtoupper($subject_id->subject_id)." | ". date("d-M-Y", strtotime(strtolower($class_date)));
           $modify->duration 						      =		 $class_duration;
           $modify->time_zone 						    =		 "Asia/Kolkata";
           $modify->attendee_limit 				    =	   $class_strength;
           $modify->create_recording 			    =		 'true';
           $modify->return_url 			          =		 site_url('lobby');
           if($extend_duration!=""){$modify->extend_duration=$extend_duration;}
           $modify->status_ping_url 				  =		 site_url('class-status');
           $modify->language_culture_name 	  =		 "en-us";

           //echo "<pre>";print_r($modify);die;
           $response 								          =		$modify->Modify($secretAcessKey,$access_key,$webServiceUrl);
           //echo "<pre>";print_r($response);die;//$file = 'log.txt';//$message = serialize($response)."\r\n";
           //file_put_contents($file, $message, FILE_APPEND);//echo "<pre>";print_r($response);die;//$response['errormsg']
           if(empty($response['errorcode'])){
               $method			     	            =	  $response['method'];
               $modify		                    =	  $response['modify'];
               $method_info                   =   $modify.",".date("Y-M-d h:i");

               $remarks                       =   json_decode($class_detail->remarks);
               $remarks->modify_time          =   $method_info;
               $remarks->modify_remarks       =   $remarks3;
               $new_remarks                   =   json_encode($remarks);

               $data_class_info               =   array(
                   "class_date"=>date("Y-m-d", strtotime($class_date)),"method"=>$method,"class_status"=>"modify",
                   'class_start_time'=>$class_start_time,'class_end_time'=>$class_end_time,'class_duration_min'=>$class_duration,
                   'class_extended_min'=>$extend_duration,'remarks'=>$new_remarks,"faculty_id"=>$faculty);
               $this->course_model->modify_course_class_update($data_class_info,$class_detail->id);
               $this->session->set_flashdata('success', "<i class='icon fa fa-check'></i>".$class_detail->class_name." Class modified successfully for ".$time);
               return redirect("admin/course/Course/course_class_list/{$course_id}");
           }else{
               $this->session->set_flashdata('failure', "<i class='icon fa fa-check'></i>Class not modified".$response['errorcode']." ".$response['errormsg']);
               return redirect("admin/adminlte/course_class_list/{$course_id}");
           }

       }
       $this->load->view('adminlte/panel/footer');
   }

   public function cancel_course_class($classid){
      $class_detail              =    $this->course_model->class_detail($classid);
      //  echo "<pre>";print_r($class_detail);die;

      require_once APPPATH. '/plugins/wiziq/classCode/CancelClass.php';
      $cancel 					         =		new CancelClass();
      $secretAcessKey				     =	  "yOEQY4Y6HJG2Swp2CZ+q2A==";
      $access_key					       =	  "7DpOH0SG9m8=";
      $webServiceUrl 				     =		"http://classapi.wiziqxt.com/apimanager.ashx";
      $cancel->class_id 				 =	  $class_detail->class_name;
      $response 							   =	  $cancel->CancelEvent($secretAcessKey,$access_key,$webServiceUrl);
      $course_id                 =    $class_detail->course_id;
       if(empty($response['errorcode'])){
           $method			         =	  $response['method'];
           $cancel		           =	  $response['cancel'];
           $method_info          =    $cancel.",".date("Y-M-d h:i");

           $remarks              =    json_decode($class_detail->remarks);
           $remarks->cancel_time =    $method_info;
           $new_remarks          =    json_encode($remarks);
           $this->course_model->course_class_cancel_update($method,$new_remarks,$class_detail->id);
           //echo "<pre>";print_r($response);die;

           $this->session->set_flashdata('success', "<i class='icon fa fa-check'></i>".$class_detail->class_name." class Cancel Successfully".$method." ".$cancel);
           return redirect("admin/course/Course/course_class_list/{$course_id}");
       }
       else{
          //$file 								= 	'logcancel.txt';
          //$message 							= 	serialize($response)."\r\n";
          /// file_put_contents($file, $message, FILE_APPEND);
          //echo "<pre>";print_r($response);die;
          $this->session->set_flashdata('failure', "<i class='icon fa fa-check'></i>Class not Cancel".$response['errorcode']." ".$response['errormsg']);
          return redirect("admin/course/Course/course_class_list/{$course_id}");
       }
   }

   public function class_download_recording($classid){

       require_once APPPATH. '/plugins/wiziq/classCode/DownloadRecording.php';
       $download 					         =		new DownloadRecording();
       $secretAcessKey				     =	  "yOEQY4Y6HJG2Swp2CZ+q2A==";
       $access_key					       =	  "7DpOH0SG9m8=";
       $webServiceUrl 				     =		"http://classapi.wiziqxt.com/apimanager.ashx";

       $class_detail               =     $this->course_model->class_detail($classid);
       $download->class_id 			   =	   $class_detail->class_name;
       $response 					         =	   $download->Recording($secretAcessKey,$access_key,$webServiceUrl);
       if(empty($response['errorcode'])){
           $method			           =	   $response['method'];
           $download_status        =	   $response['download_status'];
           $message		             =	   $response['message'];
           $status_xml_path        =	   $response['status_xml_path'];

           $method_info            =     $message.",".date("Y-M-d");
           $requestParameters["recording_format"] = "zip";
           //$data = file_get_contents($status_xml_path);
          // echo "<pre>"; print_r($data);
           $ch                     =      curl_init();
           curl_setopt($ch, CURLOPT_URL, htmlspecialchars($status_xml_path));
           curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
           $XMLReturn              =      curl_exec($ch);
           curl_close($ch);

           if(!empty($XMLReturn))
           {
               try
               {
                   $objDOM = new DOMDocument();
                   $objDOM->loadXML($XMLReturn);
               }
               catch(Exception $e)
               {
                   echo $e->getMessage();
               }
               $status=$objDOM->getElementsByTagName("rsp")->item(0);
               $attribNode = $status->getAttribute("status");
               if($attribNode=="ok")
               {
                   $methodTag=$objDOM->getElementsByTagName("method");
                   $download_statusTag					    =	$objDOM->getElementsByTagName("download_status");
                   $messageTag							        =	$objDOM->getElementsByTagName("message");
                   $recording_download_pathTag			=	$objDOM->getElementsByTagName("recording_download_path");

                   $response1["method"]				      =	$methodTag->item(0)->nodeValue;
                   $response1["download_status"]		=	$download_statusTag->item(0)->nodeValue;
                   $response1["message"]				    =	$messageTag->item(0)->nodeValue;
                   $response1["recording_download_path"]=	str_replace('&','&amp;',$recording_download_pathTag->item(0)->nodeValue);
                   // return  $response;
               }
               else if($attribNode=="fail")
               {
                   $error=$objDOM->getElementsByTagName("error")->item(0);
                   $response1["errorcode"]				  =	$error->getAttribute("code");
                   $response1["errormsg"]				    =	$error->getAttribute("msg");
                   //return  $response;
               }
           }
           //file_get_contents($response1['recording_download_path']);
           //echo "<pre>";print_r($response);
           //echo "<pre>";print_r($response1);
           // die;

           echo '<script language="javascript">';
           echo "alert(".$response1['recording_download_path'].")";  //not showing an alert box.
           echo "alert(".$response1['download_status'].")";
           echo "alert(".$response1['message'].")";
           echo "alert(".$response1['method'].")";
           echo '</script>';
       }else{
           //$file 								= 	'logcancel.txt';
           //$message 							    = 	serialize($response)."\r\n";
           /// file_put_contents($file, $message, FILE_APPEND);
           //echo "<pre>";print_r($response);die;
           $this->session->set_flashdata('failure', "<i class='icon fa fa-check'></i>Class not Cancel".$response['errorcode']." ".$response['errormsg']);
           return redirect("admin/course/Course/course_class_list/{$class_detail->course_id}");
       }
   }

   public function course_class_student_list($class_id){
     $class                          =    $this->course_model->class_detail($class_id);
     $category                       =    $this->adminlte_model->getcategory();
     $student                        =    $this->course_model->student_lists();
     $faculty_list                   =    $this->course_model->course_wise_faculty_list($class->course_id);
     $course_name                    =    $this->course_model->course_id_name($class->course_id);
     $course_act_stu_list            =    $this->course_model->total_course_active_student_list($class->course_id);
     $class_assign_student_list      =    $this->course_model->course_class_student_list($class->id);
     //print_r($course_name->faculty);
     $course_name1                   =   strtoupper($course_name->course_name);
     $course_main_faculty            =   strtoupper($course_name->facultyuserid." | ".$course_name->faculty);
     $hour_unit_price                =   strtoupper($course_name->class_unit_price);
     $course_duration_hours          =   strtoupper($course_name->course_duration_hours);
     $course_student_count           =   strtoupper($course_name->course_student);
     $course_start_from              =   strtoupper(date("d-M-Y",strtotime($course_name->course_start_from)));
     //print_r($class_assign_student_list);
     //'class'=>$class_detail,'faculty'=>$faculty_list,'course'=>$course_name,'active_student'=>$course_act_stu_list
      $class_name                    =   strtoupper($class->class_name);
      $class_date                    =   strtoupper(date("d-M-Y",strtotime($class->class_date)));
      $class_start_time              =   strtoupper(date("g:i a",strtotime($class->class_start_time)));
      $class_end_time                =   strtoupper(date("g:i a",strtotime($class->class_end_time)));
      if($class->class_extended_min!=""){
        $class_duration_min          =   strtoupper($class->class_duration_min+$class->class_extended_min);
      }
      else{
        $class_duration_min          =   strtoupper($class->class_duration_min);
      }
      $faculty                       =   strtoupper($class->facultyuserid." | ".$class->faculty);
      $money_class                   =   strtoupper($class->earning_from_class." / ".($class->class_amount*$class->attendee_limit-$class->earning_from_class)." / ".($class->class_amount*$class->attendee_limit));
      $student_count                 =   strtoupper($class->current_class_strength." / ".($class->attendee_limit-$class->current_class_strength)." / ".$class->attendee_limit);


     $html	       =   "
     <div class='table-responsive'>
         <table class='table table-bordered'>
           <thead>
           <tr>
             <th>Course Start From</th>
             <th>Course Name</th>
             <th>Course Faculty</th>
             <th>Hour Unit Price</th>
             <th>Total Duration Hrs</th>
             <th>Total Student</th>
          </tr>
        </thead>
           <tbody>
           <tr>
             <td>$course_start_from</td>
             <td>$course_name1</td>
             <td>$course_main_faculty</td>
             <td><i class='fa fa-fw fa-rupee'></i> $hour_unit_price</td>
             <td>$course_duration_hours</td>
             <td>$course_student_count</td>
          </tr>
        </tbody>
   </table>
   </div>
         <table id='example2' class='table table-bordered table-hover  table-responsive' style='font-family: sans-serif;font-size: 12px;'>
           <thead>
             <tr style='background-color: #428bca99 !important;color: #fff !important;'>
             <th>Class Id</th>
             <th>Class Date</th>
             <th>Class Start Time</th>
             <th>Class End Time</th>
             <th>Class Duration</th>
             <th>Faculty</th>
             <th>Current/Loss/Expected</th>
             <th>Current/Left/Desired</th>
             </tr>
           </thead>
           <tbody style='height:50px;'>
             <tr>
               <td>$class_name</td>
               <td>$class_date</td>
               <td>$class_start_time</td>
               <td>$class_end_time</td>
               <td>$class_duration_min '</td>
               <td>$faculty</td>
               <th><i class='fa fa-fw fa-rupee'></i> $money_class</th>
               <td>$student_count</td>
             </tr>
           </tbody>
           </table>

           ";
           $html.="<table id='example2' class='table table-bordered table-hover  table-responsive' style='font-family: sans-serif;font-size: 12px;'><tbody style='height:50px;'><h2>Student in Current Class</h2><tr>";
           if(count($class_assign_student_list)>0){
             foreach($class_assign_student_list as $id=>$value){
               $html.="<td>".$value."</td>";
             }
           }
           else{
             $html.="<td>There is no studnet added in this class</td>";
           }

           $html.="</tr></tbody></table>";
           echo $html;
   }


 }
