<?php defined("BASEPATH")or exit('No direct access is allowed');?>

<?php
class Account extends CI_Controller{

  public function __construct(){
    parent::__construct();
     $this->load->model('admin/account/AccountModel','account_model');
     $this->load->model('admin/AdminlteModel','adminlte_model');
     $this->load->model('admin/master/Facultymodel','faculty_model');
     $this->load->model('CommonModel','common_model');

     $this->load->library(['form_validation','bcrypt','email','session','pagination']);
     $this->load->helper(['html','form','url','security','string']);

     //$this->load->model('AdminlteModel','adminlte_model');
     if(!$this->session->userdata('ad_id') ){return redirect('Admin/signin');}
     if($this->session->userdata('ts_id') ){return redirect('teacher/signin');}
     if($this->session->userdata('ss_id') ){return redirect('student/signin');}
     $list_id					=		$this->session->userdata('ad_id');
     $this->admin_data	        =		$this->adminlte_model->user_profile($list_id);
     //echo $this->session->userdata('ad_id');die;
     error_reporting(0);
     date_default_timezone_set('Asia/Kolkata');
  }
  public function index(){
    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
    $config = [
        'base_url'					    =>	site_url('admin/account/Account/index'),
        'total_rows'			     	=>	$this->account_model->student_current_wallet_list_num_rows(),
        'per_page'				    	=>	$perpage,
        'display_pages'		     	=>	TRUE,
        'use_page_numbers'	    => 	TRUE,
        'uri_segment'				    =>	5,
        'num_links'					    =>	10,
        'page_query_string'     => 	FALSE,
        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
        'full_tag_close'		    =>	"</ul>",
        'first_tag_open'		    =>	'<li>',
        'first_tag_close'		    =>	'</li>',
        'last_tag_open'			    =>	'<li>',
        'last_tag_close'		    =>	'</li>',
        'next_tag_open'			    =>	'<li>',
        'next_tag_close'		    =>	'</li>',
        'prev_tag_open'			    =>	'<li>',
        'prev_tag_close'		    =>	'</li>',
        'num_tag_open'			    =>	'<li>',
        'num_tag_close'			    =>	'</li>',
        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
        'cur_tag_close'			    =>	'</a></li>',
    ];
    $this->pagination->initialize($config);
    $page 		                  =    ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
    $list 		                  =    $this->account_model->student_current_wallet_list($config['per_page'],$page);
    $links		                  =	   $this->pagination->create_links();

    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Atudent Account Status List','list'=>$list,'link'=>$links]);
    $this->load->view('adminlte/panel/sidebar');
    $this->load->view('adminlte/accounts/account_status_list');
    $this->load->view('adminlte/panel/footer');
  }
  public function student_wallet(){
    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
    $config = [
        'base_url'					    =>	site_url('admin/account/Account/index'),
        'total_rows'			     	=>	$this->account_model->student_current_wallet_list_num_rows(),
        'per_page'				    	=>	$perpage,
        'display_pages'		     	=>	TRUE,
        'use_page_numbers'	    => 	TRUE,
        'uri_segment'				    =>	5,
        'num_links'					    =>	10,
        'page_query_string'     => 	FALSE,
        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
        'full_tag_close'		    =>	"</ul>",
        'first_tag_open'		    =>	'<li>',
        'first_tag_close'		    =>	'</li>',
        'last_tag_open'			    =>	'<li>',
        'last_tag_close'		    =>	'</li>',
        'next_tag_open'			    =>	'<li>',
        'next_tag_close'		    =>	'</li>',
        'prev_tag_open'			    =>	'<li>',
        'prev_tag_close'		    =>	'</li>',
        'num_tag_open'			    =>	'<li>',
        'num_tag_close'			    =>	'</li>',
        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
        'cur_tag_close'			    =>	'</a></li>',
    ];
    $this->pagination->initialize($config);
    $page 		                  =    ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
    $list 		                  =    $this->account_model->student_current_wallet_list($config['per_page'],$page);
    $links		                  =	   $this->pagination->create_links();

    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Atudent Account Status List','list'=>$list,'link'=>$links]);
    $this->load->view('adminlte/panel/sidebar');
    $this->load->view('adminlte/accounts/student_wallet_list');
    $this->load->view('adminlte/panel/footer');
  }

  public function teacher_wallet(){
    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
    if($this->input->post('perpage')==""){$perpage=10;}		else{$perpage		=	$this->input->post('perpage');}
    $config = [
        'base_url'					    =>	site_url('admin/account/Account/index'),
        'total_rows'			     	=>	$this->account_model->student_current_wallet_list_num_rows(),
        'per_page'				    	=>	$perpage,
        'display_pages'		     	=>	TRUE,
        'use_page_numbers'	    => 	TRUE,
        'uri_segment'				    =>	5,
        'num_links'					    =>	10,
        'page_query_string'     => 	FALSE,
        'full_tag_open'			    =>	"<ul class='pagination pagination-sm'>",
        'full_tag_close'		    =>	"</ul>",
        'first_tag_open'		    =>	'<li>',
        'first_tag_close'		    =>	'</li>',
        'last_tag_open'			    =>	'<li>',
        'last_tag_close'		    =>	'</li>',
        'next_tag_open'			    =>	'<li>',
        'next_tag_close'		    =>	'</li>',
        'prev_tag_open'			    =>	'<li>',
        'prev_tag_close'		    =>	'</li>',
        'num_tag_open'			    =>	'<li>',
        'num_tag_close'			    =>	'</li>',
        'cur_tag_open'			    =>	'<li class="page-item active"><a class="page-link">',
        'cur_tag_close'			    =>	'</a></li>',
    ];
    $this->pagination->initialize($config);
    $page 		                  =    ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
    $list 		                  =    $this->account_model->student_current_wallet_list($config['per_page'],$page);
    $links		                  =	   $this->pagination->create_links();

    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Atudent Account Status List','list'=>$list,'link'=>$links]);
    $this->load->view('adminlte/panel/sidebar');
    $this->load->view('adminlte/accounts/teacher_wallet_list');
    $this->load->view('adminlte/panel/footer');
  }
  public function assign_pay_type_teacher(){

    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Teacher Pay Type','menu_auth'=>$this->menu_auth]);
    $this->load->view('adminlte/panel/sidebar');
    //echo "<pre>";print_r($_POST);die;
    $this->form_validation->set_error_delimiters('<p class="font-bold text-red">', '</p>');
    $this->form_validation->set_rules('teacher[]'         , 'Teacher'			                 , 'xss_clean|trim');
    //$this->form_validation->set_rules('mode_of_payment[]'	, 'Mode of Payment'              , 'xss_clean|trim');
    //$this->form_validation->set_rules('mode_start_at[]'		, 'Mode start Date'				       , 'numeric|xss_clean|trim');
    //$this->form_validation->set_rules('mode_end_at[]'		  , 'Mode End Date'				         , 'numeric|xss_clean|trim');
    //$this->form_validation->set_rules('salary_unit[]'		  , 'Salary Unit'				           , 'numeric|xss_clean|trim');
    //$this->form_validation->set_rules('remarks[]'		      , 'Remarks'                      , 'xss_clean|trim');
    $list      =  $this->account_model->teacher_lists();
    $mode_pay  =  $this->account_model->payment_mode_teacher();
    if($this->form_validation->run()==false){
        $this->load->view('adminlte/accounts/assign_pay_type_teacher',['teacher_list'=>$list,"paymode"=>$mode_pay]);
    }else{//echo "<pre>";print_r($_POST);die;
          $i   = 0;
        foreach($_POST['teacher'] as $teacher){
          $data = array('teacher_id'=>$teacher,'pay_mode'=>$_POST['mode_of_payment'][$i],
          'salary_unit_price'=>$_POST['salary_unit'][$i],'mode_start_at'=>date('d-m-Y',strtotime($_POST['mode_start_at'][$i])),
          'mode_end_at'=>date('d-m-Y',strtotime($_POST['mode_end_at'][$i])),'remarks'=>$_POST['remarks'][$i]);
            $count    =  $this->account_model->teacehr_current_pay_mode_num_row_id($teacher);
            if($count==0){
              $insertid =  $this->account_model->teacehr_current_pay_mode($data);
            }
            //teacehr_current_pay_mode_history
          $i++;
        }
        return redirect('account/Account/teacher_wallet');
    }
    $this->load->view('adminlte/panel/footer');
  }
  public function add_student_money_account(){
    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Add Student Wallet','menu_auth'=>$this->menu_auth]);
    $this->load->view('adminlte/panel/sidebar');
     $this->form_validation->set_error_delimiters('<p class="font-bold text-red">', '</p>');
     $this->form_validation->set_rules('wallet_date[]'      , 'Parallel Session'			, 'required|xss_clean|trim');
     $this->form_validation->set_rules('wallet_add_time[]'  , 'Parallel Session'			, 'required|xss_clean|trim');
     $this->form_validation->set_rules('mode_of_payment[]'	, 'Category'              , 'required|xss_clean|trim');
     $this->form_validation->set_rules('student[]'			    , 'Class'				          , 'required|xss_clean|trim');
     $this->form_validation->set_rules('student_wallet[]'		, 'Subject'				        , 'required|numeric|xss_clean|trim');
     $this->form_validation->set_rules('remarks[]'		      , 'Remarks'               , 'xss_clean|trim');
     $student                                 =       $this->account_model->student_lists();
     $mode_pay                                =       $this->account_model->mode_of_payemnt_lists();
     if($this->form_validation->run()==false){
         $this->load->view('adminlte/accounts/add_student_money_account',['student34'=>$student,"paymode"=>$mode_pay]);
     }
     else{
         $wallet_date	                       =		($_POST['wallet_date']);
         $wallet_add_time						         =		($_POST['wallet_add_time']);
         $mode_of_payment						         =		($_POST['mode_of_payment']);
         $student							               =		($_POST['student']);
         $student_wallet				             =		($_POST['student_wallet']);
         $remarks	                           =		($_POST['remarks']);
         $i=0;
        foreach($student as $str){
            $count_c = $this->account_model->find_duplicate_current_amount_student($str);
            if($count_c==0){
              $carray= array('student_id'=>$str,'wallet_amount'=>$student_wallet[$i]);
              $insertid =  $this->account_model->insert_current_ammount_student($carray);
              $darray =array('current_wallet_id'=>$insertid,'wallet_add_date_time'=>date("d-m-Y",strtotime($wallet_date[$i]))." ".$wallet_add_time[$i],'wallet_amount'=>$student_wallet[$i],'mode_of_payment'=>$mode_of_payment[$i],'remarks'=>$remarks[$i]);
              $hid= $this->account_model->insert_history_ammount_student($darray);
            }else{
                $user_id = $this->account_model->find_row_current_amount_student($str);
                $amount = $user_id->wallet_amount+$student_wallet[$i];
                $this->account_model->update_current_ammount_student($str,$amount);
                $darray =array('current_wallet_id'=>$user_id->id,'wallet_add_date_time'=>date("d-m-Y",strtotime($wallet_date[$i]))." ".$wallet_add_time[$i],'wallet_amount'=>$student_wallet[$i],'mode_of_payment'=>$mode_of_payment[$i],'remarks'=>$remarks[$i]);
                $hid= $this->account_model->insert_history_ammount_student($darray);
            }
           $i++;
        }
        return redirect('admin/account/Account');
     }
    $this->load->view('adminlte/panel/footer');
  }

  public function edit_student_money_account($current_st_am_id){
    $this->load->view('adminlte/panel/header',['userdata'=>$this->admin_data,'title'=>'Edit Student Wallet','menu_auth'=>$this->menu_auth]);
    $this->load->view('adminlte/panel/sidebar');
     $this->form_validation->set_error_delimiters('<p class="font-bold text-red">', '</p>');
     $this->form_validation->set_rules('wallet_date[]'      , 'Parallel Session'			, 'required|xss_clean|trim');
     $this->form_validation->set_rules('wallet_add_time[]'  , 'Parallel Session'			, 'required|xss_clean|trim');
     $this->form_validation->set_rules('mode_of_payment[]'	, 'Category'              , 'required|xss_clean|trim');
     $this->form_validation->set_rules('student[]'			    , 'Class'				          , 'required|xss_clean|trim');
     $this->form_validation->set_rules('student_wallet[]'		, 'Subject'				        , 'required|numeric|xss_clean|trim');
     $this->form_validation->set_rules('remarks[]'		      , 'Remarks'               , 'xss_clean|trim');
     $student                                 =       $this->account_model->student_lists();
     $mode_pay                                =       $this->account_model->mode_of_payemnt_lists();
     $data                                    =       $this->account_model->current_amount_student_fetch($current_st_am_id);
     //echo "<pre>";print_r($data);die;
     if($this->form_validation->run()==false){
         $this->load->view('adminlte/accounts/edit_student_money_account',['student34'=>$student,"paymode"=>$mode_pay,'data'=>$data]);
     }
     else{
         $wallet_date	                       =		$_POST['wallet_date'];
         $wallet_add_time						         =		$_POST['wallet_add_time'];
         $mode_of_payment						         =		$_POST['mode_of_payment'];
         $student_wallet				             =		$_POST['student_wallet'];
         $remarks	                           =		$_POST['remarks'];
         $current_wallet_id	              