<?php defined("BASEPATH") or exit("NO DIRECT ACCESS IS ALLOWED");?>
<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
    
    /**
     * Description of highchart
     *
     * @author http://www.roytuts.com
     */
    class HighChart extends MY_Controller {
        
        function __construct() {
            parent::__construct();
            $this->load->model('HighChartModel', 'chart');
        }
        
        public function index() {
            $this->load->view('highcharts');
        }
        
        public function get_chart_data() {
            if (isset($_POST['start']) AND isset($_POST['end'])) {
                $start_date = $_POST['start'];
                $end_date = $_POST['end'];
                $results = $this->chart->get_chart_data($start_date, $end_date);
                if ($results === NULL) {
                    echo json_encode('No record found');
                } else {
                    $json = '[';
                    $counter = 1;
                    foreach ($results as $result) {
                        $json .= '[';
                        $json .= strtotime($result->temp_date);
                        $json .= ',';
                        $json .= $result->temp_min;
                        $json .= ',';
                        $json .= $result->temp_max;
                        $json .= ']';
                        if ($counter < count($results)) {
                            $json .= ',';
                        }
                        $counter++;
                    }
                    $json .= ']';
                    echo $json;
                }
            } else {
                echo json_encode('Date must be selected.');
            }
        }
        
    }
    
    /* End of file highchart.php */
    /* Location: ./application/controllers/highchart.php */