<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {
    
    public function __construct(){
        parent::__construct();
        error_reporting(0);
        $this->load->library(array('twconnect'));
        $this->load->library(['form_validation','bcrypt','email','session']);
        $this->load->helper(['html','form','url','security','string']);
    }
    public function index()
    {
        if($this->session->userdata('login') == true){
            redirect('welcome/profile');
        }
        
        $this->load->view('welcome_message');
    }
    
    public function redirect() {
        
        if($this->session->userdata('login') == true){
            redirect('welcome/profile');
        }
        
        $ok = $this->twconnect->twredirect('welcome/callback');
        //echo $ok; echo "$this->twconnect->twredirect('welcome/callback')";die;
        if (!$ok) {
            echo 'Could not connect to Twitter. Refresh the page or try again later.';
        }
        
    }
    
    
    public function callback() {
        
        if($this->session->userdata('login') == true){
            redirect('welcome/profile');
        }
        
        $ok = $this->twconnect->twprocess_callback();
        
       if ( $ok ) { redirect('welcome/success'); }
        //if ( $ok ) { redirect('welcome/twitter'); }
        else redirect ('welcome/failure');
        
    }
    public function twitter() {
        
        $this->twconnect->twaccount_verify_credentials();
        $user_profile = $this->twconnect->tw_user_info;
        
        /* $arr = array(
            'id' => $user_profile->id,
            'name' => $user_profile->name,
            'screen_name' => $user_profile->screen_name,
            'location' => $user_profile->location,
            'description' => $user_profile->description,
            'profile_image_url' => $user_profile->profile_image_url,
        ); */
        
        $hashtag		        = random_string('alnum', 16);
        //$data['email']          = $user['email'];
       // $data['gender']         = $user['gender'];
        $data['first_name']     = $user_profile->name;
        $data['last_name']      = $user_profile->screen_name;
        $data['twitter_id']     = $user_profile->id;
        // $data['dob']          = false;
        $data['profile_image']  = $user_profile->profile_image_url;
        $data['category']       = 2;
        $data['hashtag']        = $hashtag;
        //echo "<pre>";print_r($data);die;
        
        $ins = $this->common_model->insert_twitter($data);
        $this->load->library('session');
        $this->session->set_userdata('ss_id',$data['hashtag'].$ins);
        //echo $this->session->userdata('ss_id');die;
        return redirect('Student/class_scheduled_list');
        
    }
    
    public function success() {
        
        if($this->session->userdata('login') == true){
            redirect('welcome/profile');
        }
        
        $this->twconnect->twaccount_verify_credentials();
        
        
        $user_profile = $this->twconnect->tw_user_info;
        
        $this->session->set_userdata('login',true);
        
        
        $arr = array(
            'id' => $user_profile->id,
            'name' => $user_profile->name,
            'screen_name' => $user_profile->screen_name,
            'location' => $user_profile->location,
            'description' => $user_profile->description,
            'profile_image_url' => $user_profile->profile_image_url,
        );
        
       $this->session->set_userdata('user_profile',$arr);
        
        redirect('welcome/profile');
        
    }
    
    
    
    public function failure() {
        
        if($this->session->userdata('login') == true){
            redirect('welcome/profile');
        }
        
        echo '<p>Twitter connect failed</p>';
        echo '<p><a href="' . base_url() . 'welcome/logout">Try again!</a></p>';
    }
    
    public function profile(){
        if($this->session->userdata('login') != true){
            redirect('');
        }
        $contents['user_profile'] = $this->session->userdata('user_profile');
        $this->load->view('profile',$contents);
        
    }
    
    public function logout(){
        $this->session->sess_destroy();
        $this->session->set_flashdata('success','User Successfully logout');
        redirect('student/signin');
        
    }
}
