<?php
defined("BASEPATH")or exit("NO Direct Access is Allowed");

Class Teacher extends CI_Controller{
    protected $limit, $offset;
  public function __construct(){

    parent::__construct();
    $this->load->library(['form_validation','bcrypt','email','session','pagination']);
	$this->load->helper(['html','form','url','security','string','file','directory']);
	$this->load->model('CommonModel','common_model');
    $this->load->model('TeacherModel','teacher_model');
    //$this->load->model('admin/Adminltemodel','adminlte_model');
    if( ! $this->session->userdata('ts_id') ){return redirect('teacher/signin');}
    if( $this->session->userdata('ss_id') ){return redirect('student/signin');}
    if( $this->session->userdata('ad_id') ){return redirect('teacher/signin');}
    $list_id					=		$this->session->userdata('ts_id');
    $this->userid               =       substr($list_id, 16);
    $this->teacher_data	        =		$this->teacher_model->user_profile($list_id);
    $this->teacher_data1	    =		$this->teacher_model->basic_information($list_id);
    $this->teacher_data2	    =		$this->teacher_model->basic_information($list_id);
    $this->faculty_ids          =       $this->teacher_model->v2_faculty_list($this->userid);
	error_reporting(0);

	//echo $this->userid; die;
     //echo "<pre>";print_r($this->faculty_ids);
    //die;

    date_default_timezone_set('Asia/Kolkata');
    error_reporting(0);
    $this->total_approve_subject                =       $this->teacher_model->subject_approved_list_num_row($this->userid);
    $this->crs_enrolled                         =       $this->teacher_model->teacher_crs_enrld_list_num_row($this->faculty_ids);
	//echo $this->crs_enrolled ; die;
    $this->crs_enrolled_running                 =       $this->teacher_model->teacher_crs_enrld_list_num_row_running($this->faculty_ids);
    //echo $this->crs_enrolled ; die;
    $this->crs_enrolled_completed               =       $this->teacher_model->teacher_crs_enrld_list_num_row_completed($this->faculty_ids);
    $this->sessions                             =       $this->teacher_model->total_session($this->faculty_ids);
    $this->total_class_today                    =	   $this->teacher_model->total_class_today($this->faculty_ids);
    $this->total_class_today_remaining          =	   $this->teacher_model->total_class_today_remaining($this->faculty_ids);
    $this->total_class_today_completed          =	   $this->teacher_model->total_class_today_completed($this->faculty_ids);
    $this->total_class_this_week                =	   $this->teacher_model->total_class_this_week($this->faculty_ids);
    $this->total_class_this_week_completed      =	   $this->teacher_model->total_class_this_week_completed($this->faculty_ids);
    $this->total_class_this_week_remaining      =	   $this->teacher_model->total_class_this_week_remaining($this->faculty_ids);
    $this->total_class_next_week                =	   $this->teacher_model->total_class_next_week($this->faculty_ids);
    $this->total_class_this_month               =	   $this->teacher_model->total_class_this_month($this->faculty_ids);
    $this->total_class_this_month_completed     =	   $this->teacher_model->total_class_this_month_completed($this->faculty_ids);
    $this->total_class_this_month_remaining     =	   $this->teacher_model->total_class_this_month_remaining($this->faculty_ids);
    $this->total_class_next_month               =	   $this->teacher_model->total_class_next_month($this->faculty_ids);
    $this->total_class_this_year                =	   $this->teacher_model->total_class_this_year($this->faculty_ids);
    $this->current_class                        =	   $this->teacher_model->current_class_counter($this->faculty_ids);
    $this->classes_today_rows_running_as_well_as_next  =	   $this->teacher_model->total_class_today_rows($this->faculty_ids);
    $this->current_class_now                    =	   $this->teacher_model->current_class_rows($this->faculty_ids);
    $this->next_class_today                     =	   $this->teacher_model->next_class_rows($this->faculty_ids);
    //echo "<pre>"; print_r($this->current_class_now); die;
  }

  public function index(){
        /* $country_list   =   $this->common_model->country_list();
        $this->load->view('teacher/header',[]);
		$this->load->view('teacher/teacher_info_mendatory',['country'=>$country_list]);
		$this->load->view('teacher/footer'); */
      return redirect("Teacher/recent-classes");
  }
  public function logout(){

  		$this->session->unset_userdata('ts_id');
  		$this->session->sess_destroy();
  		return redirect('teacher/signin');
  }

  public function earnings(){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url('Teacher/earnings'),
          'total_rows'					=>	$this->teacher_model->earnings_num_row($this->faculty_ids),
          'per_page'					=>	$perpage,
          'display_pages'				=>	TRUE,
          'use_page_numbers'			=> 	TRUE,
          'uri_segment'					=>	3,
          'num_links'					=>	10,
          'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'				=>	"</ul>",
          'first_tag_open'				=>	'<li>',
          'first_tag_close'				=>	'</li>',
          'last_tag_open'				=>	'<li>',
          'last_tag_close'				=>	'</li>',
          'next_tag_open'				=>	'<li>',
          'next_tag_close'				=>	'</li>',
          'prev_tag_open'				=>	'<li>',
          'prev_tag_close'				=>	'</li>',
          'num_tag_open'				=>	'<li>',
          'num_tag_close'				=>	'</li>',
          'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      $list 		                =  $this->teacher_model->earnings($config['per_page'],$page,$this->faculty_ids);
      $links		                =  $this->pagination->create_links();
	  $category                     =  $this->teacher_model->getcategory();
      $subject_code                 =  $this->teacher_model->subject_code_lists();

      $this->load->view('teacher/header',['title'=>'Earnings','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/teacher_earnings',['category'=>$category,'subject_code'=>$subject_code]);
      $this->load->view('teacher/footer');
  }

  public function earnings_list($course_id){
    $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
    if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
    $cid                              =   $this->teacher_model->find_course_key_id($course_id);
	$course=strtoupper($course_id);
    $config = [
        'base_url'				=>	site_url("Teacher/earnings_list/$course"),
        'total_rows'				=>	$this->teacher_model->earnings_list_num_row($cid,$this->faculty_ids),
        'per_page'				=>	$perpage,
        'display_pages'				=>	TRUE,
        'use_page_numbers'			=> 	TRUE,
        'uri_segment'				=>	4,
        'num_links'				=>	10,
        'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
        'full_tag_close'			=>	"</ul>",
        'first_tag_open'			=>	'<li>',
        'first_tag_close'			=>	'</li>',
        'last_tag_open'				=>	'<li>',
        'last_tag_close'			=>	'</li>',
        'next_tag_open'				=>	'<li>',
        'next_tag_close'			=>	'</li>',
        'prev_tag_open'				=>	'<li>',
        'prev_tag_close'			=>	'</li>',
        'num_tag_open'				=>	'<li>',
        'num_tag_close'				=>	'</li>',
        'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
        'cur_tag_close'				=>	'</a></li>',
    ];
    $this->pagination->initialize($config);
    $page 		                =  ($this->uri->segment(4)) ? $this->uri->segment(4) : 1;
    $list 		                =  $this->teacher_model->earnings_list($config['per_page'],$page,$cid,$this->faculty_ids);
    $links		                =  $this->pagination->create_links();

    $this->load->view('teacher/header',['title'=>'Earning List','list'=>$list,'link'=>$links]);
    $this->load->view('teacher/teacher_earnings_list');
    $this->load->view('teacher/footer');
}

  public function teacher_course_enrolled_list(){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url('Teacher/teacher_course_enrolled_list'),
          'total_rows'					=>	$this->teacher_model->teacher_crs_enrld_list_num_row($this->faculty_ids),
          'per_page'					=>	$perpage,
          'display_pages'				=>	TRUE,
          'use_page_numbers'				=> 	TRUE,
          'uri_segment'					=>	3,
          'num_links'					=>	10,
          'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'				=>	"</ul>",
          'first_tag_open'				=>	'<li>',
          'first_tag_close'				=>	'</li>',
          'last_tag_open'				=>	'<li>',
          'last_tag_close'				=>	'</li>',
          'next_tag_open'				=>	'<li>',
          'next_tag_close'				=>	'</li>',
          'prev_tag_open'				=>	'<li>',
          'prev_tag_close'				=>	'</li>',
          'num_tag_open'				=>	'<li>',
          'num_tag_close'				=>	'</li>',
          'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      $list 		                =  $this->teacher_model->teacher_crs_enrld_list($config['per_page'],$page,$this->faculty_ids);
      $links		                =  $this->pagination->create_links();
	  $category                     =  $this->teacher_model->getcategory();
      $subject_code  				=  $this->teacher_model->subject_code_lists();



      $this->load->view('teacher/header',['title'=>'Course Enrolled','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/teacher_course_enrolled_list',['category'=>$category,'subject_code'=>$subject_code]);
      $this->load->view('teacher/footer');
  }

  public function teacher_course_enrolled_class_list($course_id){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $cid                              =   $this->teacher_model->find_course_key_id($course_id);
      $config = [
          'base_url'					=>	site_url("Teacher/teacher_course_enrolled_class_list/class-list/$course_id"),
          'total_rows'					=>	$this->teacher_model->teacher_crs_enrld_cl_list_num_row($this->faculty_ids,$cid),
          'per_page'					=>	$perpage,
          'display_pages'				=>	TRUE,
          'use_page_numbers'			=> 	TRUE,
          'uri_segment'					=>	5,
          'num_links'					=>	10,
          'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'				=>	"</ul>",
          'first_tag_open'				=>	'<li>',
          'first_tag_close'				=>	'</li>',
          'last_tag_open'				=>	'<li>',
          'last_tag_close'				=>	'</li>',
          'next_tag_open'				=>	'<li>',
          'next_tag_close'				=>	'</li>',
          'prev_tag_open'				=>	'<li>',
          'prev_tag_close'				=>	'</li>',
          'num_tag_open'				=>	'<li>',
          'num_tag_close'				=>	'</li>',
          'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(5)) ? $this->uri->segment(5) : 1;
      $list 		                =  $this->teacher_model->teacher_crs_enrld_cl_list($config['per_page'],$page,$this->faculty_ids,$cid);
      $links		                =  $this->pagination->create_links();

      $this->load->view('teacher/header',['title'=>'Class List','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/teacher_course_enrolled_class_list');
      $this->load->view('teacher/footer');
  }

  public function subject_approved_list(){

      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url("Teacher/subject_approved_list"),
          'total_rows'					=>	$this->teacher_model->subject_approved_list_num_row($this->userid),
          'per_page'					=>	$perpage,
          'display_pages'				=>	TRUE,
          'use_page_numbers'			=> 	TRUE,
          'uri_segment'					=>	3,
          'num_links'					=>	10,
          'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'				=>	"</ul>",
          'first_tag_open'				=>	'<li>',
          'first_tag_close'				=>	'</li>',
          'last_tag_open'				=>	'<li>',
          'last_tag_close'				=>	'</li>',
          'next_tag_open'				=>	'<li>',
          'next_tag_close'				=>	'</li>',
          'prev_tag_open'				=>	'<li>',
          'prev_tag_close'				=>	'</li>',
          'num_tag_open'				=>	'<li>',
          'num_tag_close'				=>	'</li>',
          'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      $list 		                =  $this->teacher_model->subject_approved_list($config['per_page'],$page,$this->userid);
      $links		                =  $this->pagination->create_links();
      $category  =  $this->teacher_model->getcategory();
      $subject_code  =  $this->teacher_model->subject_code_lists();
      $this->load->view('teacher/header',['title'=>'Subject List','list'=>$list,'link'=>$links,
          "request_made"=>$test3]);
      $this->load->view('teacher/subject_approved_list', ['category'=>$category,'subject_code'=>$subject_code]);
      $this->load->view('teacher/footer');
  }

  public function  recent_classes_15_days(){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url("Teacher/recent_classes_15_days"),
          'total_rows'					=>	$this->teacher_model->recent_classes_15_days_num_row($this->faculty_ids),
          'per_page'					=>	$perpage,
          'display_pages'				=>	TRUE,
          'use_page_numbers'			=> 	TRUE,
          'uri_segment'					=>	3,
          'num_links'					=>	10,
          'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'				=>	"</ul>",
          'first_tag_open'				=>	'<li>',
          'first_tag_close'				=>	'</li>',
          'last_tag_open'				=>	'<li>',
          'last_tag_close'				=>	'</li>',
          'next_tag_open'				=>	'<li>',
          'next_tag_close'				=>	'</li>',
          'prev_tag_open'				=>	'<li>',
          'prev_tag_close'				=>	'</li>',
          'num_tag_open'				=>	'<li>',
          'num_tag_close'				=>	'</li>',
          'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      $list 		                =  $this->teacher_model->recent_classes_15_days_list($config['per_page'],$page,$this->faculty_ids);
      $links		                =  $this->pagination->create_links();

        $category  =  $this->teacher_model->getcategory();
      $subject_code  =  $this->teacher_model->subject_code_lists();

      $this->load->view('teacher/header',['title'=>'Recent Classes','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/recent_classes_15_days',['category'=>$category,'subject_code'=>$subject_code]);
      $this->load->view('teacher/footer');
  }

  public function  recent_classes_past_days(){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url("Teacher/recent_classes_past_days"),
          'total_rows'					=>	$this->teacher_model->recent_classes_past_days_num_row($this->faculty_ids),
          'per_page'					=>	$perpage,
          'display_pages'				=>	TRUE,
          'use_page_numbers'			=> 	TRUE,
          'uri_segment'					=>	3,
          'num_links'					=>	10,
          'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'				=>	"</ul>",
          'first_tag_open'				=>	'<li>',
          'first_tag_close'				=>	'</li>',
          'last_tag_open'				=>	'<li>',
          'last_tag_close'				=>	'</li>',
          'next_tag_open'				=>	'<li>',
          'next_tag_close'				=>	'</li>',
          'prev_tag_open'				=>	'<li>',
          'prev_tag_close'				=>	'</li>',
          'num_tag_open'				=>	'<li>',
          'num_tag_close'				=>	'</li>',
          'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      $list 		                =  $this->teacher_model->recent_classes_past_days_list($config['per_page'],$page,$this->faculty_ids);
      $links		                =  $this->pagination->create_links();

        $category  =  $this->teacher_model->getcategory();
      $subject_code  =  $this->teacher_model->subject_code_lists();

      $this->load->view('teacher/header',['title'=>'Recent Classes','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/recent_classes_past_days',['category'=>$category,'subject_code'=>$subject_code]);
      $this->load->view('teacher/footer');
  }

  public function upload_profile(){

    $this->load->view("teacher/header",[]);
		$data          =  array();
		if($this->input->post('fileSubmit') && !empty($_FILES['userFiles']['name'])){
			$filesCount = count($_FILES['userFiles']['name']);
			for($i = 0; $i < $filesCount; $i++){
				$_FILES['userFile']['name'] 	= 	$_FILES['userFiles']['name'][$i];
				$_FILES['userFile']['type'] 	= 	$_FILES['userFiles']['type'][$i];
				$_FILES['userFile']['tmp_name'] = 	$_FILES['userFiles']['tmp_name'][$i];
				$_FILES['userFile']['error'] 	= 	$_FILES['userFiles']['error'][$i];
				$_FILES['userFile']['size'] 	= 	$_FILES['userFiles']['size'][$i];
				$uploadPath 					= 	"./uploads/user/images/$this->userid/profile/";
				//echo $uploadPath ;die;
				if(!is_dir($uploadPath )){mkdir($uploadPath, 0777, TRUE );}
				$config['upload_path'] 			= 	$uploadPath;
				$config['allowed_types'] 		= 	'jpg|png|gif|jpeg|JPG|PNG|GIF';
				$config['overwrite'] 			= 	'1';
				$this->load->library('upload', $config);
				$this->upload->initialize($config);

				if($this->upload->do_upload('userFile')){
					$fileData = $this->upload->data();
					$this->teacher_model->update_profile_pic($this->userid,$config['upload_path'].$fileData['file_name']);
					$this->imageResize50X50($config['upload_path'].$fileData['file_name']);
				}
			}
			   $this->session->set_flashdata('success', 'Profile Added Succesfully');
			   return redirect("teacher");
		}
		$this->load->view('teacher/upload_profile', $data);
	 $this->load->view("teacher/footer");
	}

  public function upload_profile1(){

    $this->load->view("teacher/header",[]);
    $data          =  array();
    if($this->input->post('fileSubmit') && !empty($_FILES['userFiles1']['name'])){
      $filesCount = count($_FILES['userFiles']['name']);
      for($i = 0; $i < $filesCount; $i++){
        $_FILES['userFile1']['name'] 	= 	$_FILES['userFiles1']['name'][$i];
        $_FILES['userFile1']['type'] 	= 	$_FILES['userFiles1']['type'][$i];
        $_FILES['userFile1']['tmp_name'] = 	$_FILES['userFiles1']['tmp_name'][$i];
        $_FILES['userFile1']['error'] 	= 	$_FILES['userFiles1']['error'][$i];
        $_FILES['userFile1']['size'] 	= 	$_FILES['userFiles1']['size'][$i];
        $uploadPath 					= 	"./uploads/user/images/$this->userid/screenshot/";
        //echo $uploadPath ;die;
        if(!is_dir($uploadPath )){mkdir($uploadPath, 0777, TRUE );}
        $config['upload_path'] 			= 	$uploadPath;
        $config['allowed_types'] 		= 	'gif|jpg|png|jpeg|pdf|doc|xml|docx|GIF|JPG|PNG|JPEG|PDF|DOC|XML|DOCX|xls|xlsx';
        $config['overwrite'] 			= 	'1';
        $this->load->library('upload', $config);
        $this->upload->initialize($config);

        if($this->upload->do_upload('userFile1')){
          $fileData = $this->upload->data();
          $this->teacher_model->basic_information($this->userid,$config['upload_path'].$fileData['file_name']);
          $this->imageResize50X50($config['upload_path'].$fileData['file_name']);
        }
      }
         $this->session->set_flashdata('success', 'Profile Added Succesfully');
         return redirect("teacher");
    }
    $this->load->view('teacher/upload_profile2', $data);
   $this->load->view("teacher/footer");
  }

  public function upload_profile2(){

    $this->load->view("teacher/header",[]);
		$data          =  array();
		if($this->input->post('fileSubmit') && !empty($_FILES['userFiles2']['name'])){
			$filesCount = count($_FILES['userFiles2']['name']);
			for($i = 0; $i < $filesCount; $i++){
				$_FILES['userFile2']['name'] 	= 	$_FILES['userFiles2']['name'][$i];
				$_FILES['userFile2']['type'] 	= 	$_FILES['userFiles2']['type'][$i];
				$_FILES['userFile2']['tmp_name'] = 	$_FILES['userFiles2']['tmp_name'][$i];
				$_FILES['userFile2']['error'] 	= 	$_FILES['userFiles2']['error'][$i];
				$_FILES['userFile2']['size'] 	= 	$_FILES['userFiles2']['size'][$i];
				$uploadPath 					= 	"./uploads/user/images/$this->userid/resume/";
				//echo $uploadPath ;die;
				if(!is_dir($uploadPath )){mkdir($uploadPath, 0777, TRUE );}
				$config['upload_path'] 			= 	$uploadPath;
				$config['allowed_types'] 		= 	'gif|jpg|png|jpeg|pdf|doc|xml|docx|GIF|JPG|PNG|JPEG|PDF|DOC|XML|DOCX|xls|xlsx';
				$config['overwrite'] 			= 	'1';
				$this->load->library('upload', $config);
				$this->upload->initialize($config);

				if($this->upload->do_upload('userFile2')){
					$fileData = $this->upload->data();
					$this->teacher_model->basic_information($this->userid,$config['upload_path'].$fileData['file_name']);
					$this->imageResize50X50($config['upload_path'].$fileData['file_name']);
				}
			}
			   $this->session->set_flashdata('success', 'Profile Added Succesfully');
			   return redirect("teacher");
		}
		$this->load->view('teacher/upload_profile3', $data);
	 $this->load->view("teacher/footer");
	}

	function imageResize50X50($path){
	   // $img_path =  realpath("img")."\\images\\uploaded\\".$imgName.".jpeg";

	    // Configuration
	    $config['image_library'] = 'gd2';
	    $config['source_image'] = $path;
	    $config['new_image'] = $path;
	    $config['create_thumb'] = TRUE;
	    $config['maintain_ratio'] = TRUE;
	    $config['width']           = 100;
	    $config['height']          =         100;

	    // Load the Library
	    $this->load->library('image_lib', $config);

	    // resize image
	    $this->image_lib->resize();
	    // handle if there is any problem
	    if ( ! $this->image_lib->resize()){
	        echo $this->image_lib->display_errors();
	    }
	}


	public function complete_profile(){
	    //echo "<pre>";print_r($_POST);die;
	    $this->load->view('teacher/header',['title'=>'Add teacher']);

	    $this->form_validation->set_error_delimiters('<br><span style="color:red;">', '</span>');
	    $this->form_validation->set_rules('first_name'	               , 'First Name'                    , 'required|xss_clean|alpha_numeric_spaces|trim|max_length[20]');
	    $this->form_validation->set_rules('last_name'		               , 'Last Name'	                   , 'required|xss_clean|alpha_numeric_spaces|trim|max_length[20]');
	    $this->form_validation->set_rules('mobile'	                   , 'Mobile'                        , 'required|xss_clean|regex_match[/^[0-9]{10}$/]|max_length[10]|min_length[10]|exact_length[10]|trim');
	    $this->form_validation->set_rules('address'		                 , 'Address'	                     , 'required|xss_clean|trim|max_length[150]');
	    $this->form_validation->set_rules('country'		                 , 'Country'	                     , 'required|xss_clean');
	    $this->form_validation->set_rules('pin_code'	                 , 'Pin Code'                      , 'required|xss_clean|numeric|trim|max_length[20]');
	    $this->form_validation->set_rules('school_name'		             , 'School Name'	                 , 'required|xss_clean|alpha_numeric_spaces|trim|max_length[150]');
	    $this->form_validation->set_rules('school_address'	           , 'School Address'	               , 'required|xss_clean|trim|max_length[20]');
	    $this->form_validation->set_rules('preferred_subject'	         , 'Preferred Subject'             , 'required|xss_clean|trim|max_length[20]');
	    $this->form_validation->set_rules('preferred_learning_hour'		 , 'Preferred learning Hour'	     , 'required|xss_clean|trim|max_length[20]');
	    $this->form_validation->set_rules('preferred_class'		         , 'Prefeered Class'	             , 'required|xss_clean|trim|max_length[20]');
	    $this->form_validation->set_rules('current_class'	             , 'Current Class'                 , 'required|xss_clean|trim|max_length[20]');
	    $this->form_validation->set_rules('parent_fname'		           , 'Parent First Name'	           , 'required|xss_clean|trim|max_length[20]');
	    $this->form_validation->set_rules('parent_lname'		           , 'Parent Last Name'	             , 'required|xss_clean|trim|max_length[20]');
	    $this->form_validation->set_rules('parent_email'		           , 'Parent Email Address'	         , 'required|xss_clean|valid_email|trim|max_length[100]');
	    $this->form_validation->set_rules('parent_mobile'		           , 'Parent Mobile'	               , 'required|xss_clean|regex_match[/^[0-9]{10}$/]|max_length[10]|min_length[10]|exact_length[10]|trim');
	    $country_list   =   $this->common_model->country_list();
	    if($this->form_validation->run()==false){
	        $this->session->set_flashdata('danger', "<i class='icn glyphicon glyphicon-remove'></i>  Profile Not Completed");
	        $this->load->view('teacher/teacher_info_mendatory',['country'=>$country_list]);
	    }
	    else{
	        $dt 				    = 	new DateTime();
	        $response 			    = 	array("profile"=>array('first_name'=>strtolower($this->input->post('first_name')),'last_name'=>strtolower($this->input->post('last_name')),
	            'mobile'=>strtolower($this->input->post('mobile')),'address'=>strtolower($this->input->post('address')),"school_address"=>strtolower($this->input->post('school_address')),
	            'pin_code'=>strtolower($this->input->post('pin_code')),'school_name'=>strtolower($this->input->post('school_name')),"preferred_subject"=>strtolower($this->input->post('preferred_subject')),
	            'preferred_learning_hour'=>strtolower($this->input->post('preferred_learning_hour')),'preferred_class'=>strtolower($this->input->post('preferred_class')),
	            "current_class"=>strtolower($this->input->post('current_class')),"parent_fname"=>strtolower($this->input->post('parent_fname')),"parent_lname"=>strtolower($this->input->post('parent_lname')),
	            "parent_email"=>strtolower($this->input->post('parent_email')),"parent_mobile"=>strtolower($this->input->post('parent_mobile')),"country"=>strtolower($this->input->post('country')),
	        ));
	        $remarks			     =	json_encode($response);
	        //$data_remarks		     =	array('remarks'=>"$remarks");
	        $this->teacher_model->complete_profile_teacher($this->userid,$remarks);

	        $this->session->set_flashdata('success', "<i class='fa-check-circle'></i>  Profile Completed Successfully");
	        return redirect("teacher/complete_profile");
	        //return redirect("master/Activity/edit/$insert_id");
	    }

	    $this->load->view('teacher/footer');
	}

	public function view(){

	    $country_list        =  $this->common_model->country_list();
	    $this->load->view('teacher/header',['title'=>'View Profile']);
        $list            =  $this->teacher_model->basic_information($this->userid);
        $list1            =  $this->teacher_model->qualification_details($this->userid);
        $list2            =  $this->teacher_model->preferred_classes($this->userid);
        $list3            =  $this->teacher_model->bank_details($this->userid);
        $list4            =  $this->teacher_model->network_info($this->userid);
   //echo "<pre>";print_r($list);print_r($list1);print_r($list2);print_r($list3);print_r($list4);die;
	    $this->load->view('teacher/profile',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,'country'=>$country_list,]);
	    $this->load->view('teacher/footer');;
    }

    public function dashboard(){
      $list 		                =  $this->teacher_model->earning_dashboard($this->faculty_ids);
      $list1 		                =  $this->teacher_model->recent_classes($this->faculty_ids);
      $list2 		                =  $this->teacher_model->cousre_running($this->faculty_ids);
      $list3		                =  $this->teacher_model->class_history($this->faculty_ids);
      //echo "<pre>";print_r($list3);
      $this->load->view('teacher/header',['title'=>'Teacher Dashboard']);
      $this->load->view('teacher/teacher_new_dashboard',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3]);
      $this->load->view('teacher/footer');;
    }

	public function teacher_edit(){


      $this->load->view('teacher/header',['title'=>'Edit Teacher']);
        $list            =  $this->teacher_model->basic_information($this->userid);
        $list1            =  $this->teacher_model->qualification_details($this->userid);
        $list2            =  $this->teacher_model->preferred_classes($this->userid);
        $list3            =  $this->teacher_model->bank_details($this->userid);
        $list4            =  $this->teacher_model->network_info($this->userid);
        $country1           = $this->common_model->getCountry();
      // echo "<pre>";print_r($country1);
  // echo "<pre>";print_r($list);print_r($list1);print_r($list2);print_r($list3);print_r($list4);die;
      $this->load->view('teacher/teacher_edit',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,'country45'=>$country1]);
      $this->load->view('teacher/footer');;
    }


	public function basic_edit(){

        $this->load->view('teacher/header',['title'=>'Edit Teacher']);
        $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
        $this->form_validation->set_rules('first_name'      , 'First Name'     , 'required|trim');
        $this->form_validation->set_rules('last_name'       , 'Last Name'      , 'required|trim');
        $this->form_validation->set_rules('mobile'          , 'Contact'        , 'required|trim|exact_length[10]|numeric');
        $this->form_validation->set_rules('date_of_birth'   , 'Date of Birth'  , 'required|trim');
        $this->form_validation->set_rules('gender'          , 'Gender'         , 'required|trim');
        $this->form_validation->set_rules('country_id'      , 'Country'        , 'required|trim');
        $this->form_validation->set_rules('state_id'        , 'State'          , 'required|trim');
        $this->form_validation->set_rules('city_id'         , 'City'           , 'required|trim');
        $this->form_validation->set_rules('zip_code'        , 'Zip Code'       , 'required|trim');
        $this->form_validation->set_rules('aadhar_id'       , 'Aadhar Id'      , 'required|trim');
        $this->form_validation->set_rules('pan_id'          , 'Pan Card'       , 'required|trim');

        $country1           =   $this->common_model->getCountry();
        $qualification_li   =   $this->teacher_model->qualification_listing();
        $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
        $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");
        $list               =   $this->teacher_model->basic_information($this->userid);
        $list1              =   $this->teacher_model->qualification_details($this->userid);
        $list2              =   $this->teacher_model->preferred_classes($this->userid);
        $list3              =   $this->teacher_model->bank_details($this->userid);
        $list4              =   $this->teacher_model->network_info($this->userid);

        if($this->form_validation->run()==false){
            //echo form_error();echo validation_errors(); echo "false";echo "<pre>";print_r($_POST);die;
            $this->load->view('teacher/teacher_edit',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,
            'country45'=>$country1,'qualification_li'=>$qualification_li,'subject_primary'=>$subject_primary,'subject_secondary'=>$subject_secondary]);
        }
        else{  //echo "<pre>";print_r($_POST);die;
            $dt                     =   new DateTime();
            $first_name             =   strtolower(trim($this->input->post('first_name')));
            $last_name              =   strtolower(trim($this->input->post('last_name')));
            $mobile                 =   strtolower(trim($this->input->post('mobile')));
            $date_of_birth          =   strtolower(trim($this->input->post('date_of_birth')));
            $gender                 =   strtolower(trim($this->input->post('gender')));
            $zip_code               =   strtolower(trim($this->input->post('zip_code')));
            $aadhar_id              =   strtolower(trim($this->input->post('aadhar_id')));
            $pan_id                 =   strtolower(trim($this->input->post('pan_id')));
            $country_id             =   strtolower(trim($this->input->post('country_id')));
            $state_id               =   strtolower(trim($this->input->post('state_id')));
            $city_id                =   strtolower(trim($this->input->post('city_id')));
            $data_teacher_master    =   array('first_name'=>$first_name,'last_name'=>$last_name,'mobile'=>$mobile,'gender'=>$gender );
            $data_teacher_basic     =   array('dob'=>$date_of_birth,'country_id'=>$country_id,'state_id'=>$state_id,'city_id'=>$city_id,
                                                'zip_code'=>$zip_code,'aadhar_id'=>$aadhar_id,'pan_id'=>$pan_id);

            $this->teacher_model->update_teacher_master($data_teacher_master, $this->userid);
            $this->teacher_model->update_teacher_basic($data_teacher_basic,   $this->userid);
            $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
            return redirect("teacher/basic_edit");
        }
        $this->load->view('teacher/footer3');
    }

  public function basic_edit1($pfid){
        //echo "<pre>";print_r($_POST);die;
        $this->load->view('teacher/header',['title'=>'Edit Teacher']);
        $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
        $this->form_validation->set_rules('class'            , 'Class'             , 'required|trim');
        $this->form_validation->set_rules('primary_sub[]'      , 'Primary Subject'   , 'required|trim');
        $this->form_validation->set_rules('secondary_sub[]'    , 'Secondary Subject' , 'required|trim');
        //$this->form_validation->set_rules('other'            , 'Other'             , 'required|trim');

        $country1            =   $this->common_model->getCountry();
        $qualification_li    =   $this->teacher_model->qualification_listing();
        $subject_primary     =   $this->teacher_model->subjectshow_listing("Primary");
        $subject_secondary   =   $this->teacher_model->subjectshow_listing("Secondary");
        $list                =   $this->teacher_model->basic_information($this->userid);
        $list1               =   $this->teacher_model->qualification_details($this->userid);
        $list2               =   $this->teacher_model->preferred_classes($this->userid);
        $list3               =   $this->teacher_model->bank_details($this->userid);
        $list4               =   $this->teacher_model->network_info($this->userid);

        if($this->form_validation->run()==false){
            //echo form_error();echo validation_errors(); echo "false";echo "<pre>";print_r($_POST);die;
            //$this->load->view('teacher/teacher_edit',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,
            //'country45'=>$country1,'qualification_li'=>$qualification_li,'subject_primary'=>$subject_primary,'subject_secondary'=>$subject_secondary]);
            return redirect("teacher/basic_edit");
        }
        else{   //echo "<pre>";print_r($_POST);die;
            $dt                =    new DateTime();
            $class             =    strtolower(trim($this->input->post('class')));
            $primary_sub       =    strtolower(implode(",",$this->input->post('primary_sub')));
            $secondary_sub     =    strtolower(implode(",",$this->input->post('secondary_sub')));
            $other             =    strtolower(trim($this->input->post('other')));

            $data_teacher_pf_class   =   array('class'=>$class,'primary_sub'=>$primary_sub,
            'secondary_sub'=>$secondary_sub,'other'=>$other );
            //print_r($data_teacher_pf_class);die;
            $count                   =   $this->teacher_model->num_teacher_pf_class($class,$primary_sub,$secondary_sub0,$other,$this->userid);

            if($count==0){
                $this->teacher_model->update_teacher_pf_class($data_teacher_pf_class, $this->userid,$pfid);
            }else{
                return redirect("teacher/basic_edit");
            }
            $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
            return redirect("teacher/basic_edit");
        }
        $this->load->view('teacher/footer3');
    }

     public function basic_edit2($qualificationid){

        $this->load->view('teacher/header',['title'=>'Edit Teacher']);
        $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
        $this->form_validation->set_rules('qualification'           , 'Qualification'   , 'required|trim');
        $this->form_validation->set_rules('university'              , 'University'      , 'required|trim');
        $this->form_validation->set_rules('passing_year'            , 'Passing year'    , 'required|trim');
        $this->form_validation->set_rules('grade'                   , 'Grade'           , 'required|trim');

        $country1           =   $this->common_model->getCountry();
        $qualification_li   =   $this->teacher_model->qualification_listing();
        $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
        $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");
        $list               =   $this->teacher_model->basic_information($this->userid);
        $list1              =   $this->teacher_model->qualification_details($this->userid);
        $list2              =   $this->teacher_model->preferred_classes($this->userid);
        $list3              =   $this->teacher_model->bank_details($this->userid);
        $list4              =   $this->teacher_model->network_info($this->userid);

        if($this->form_validation->run()==false){
          //echo form_error(); echo validation_errors();  echo "false";echo "<pre>";print_r($_POST);die;
        //   $this->load->view('teacher/teacher_edit',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,
        //   'country45'=>$country1,'qualification_li'=>$qualification_li,'subject_primary'=>$subject_primary,'subject_secondary'=>$subject_secondary]);
        return redirect("teacher/basic_edit");
         }
        else{ //echo "<pre>";print_r($_POST);die;
            $dt                     =   new DateTime();
            $qualification          =   strtolower(trim($this->input->post('qualification')));
            $university             =   strtolower(trim($this->input->post('university')));
            $passing_year           =   strtolower(trim($this->input->post('passing_year')));
            $grade                  =   strtolower(trim($this->input->post('grade')));

            $data_teacher_qualfication = array('qualification'=>$qualification,'university'=>$university,
            'passing_year'=>$passing_year,'grade'=>$grade);

            $count                  =  $this->teacher_model->num_teacher_qualfication($qualification,$university,$passing_year,$grade,$this->userid);
            //echo $c0;die;
            if($count==0){
                $this->teacher_model->update_teacher_qualfication($data_teacher_qualfication, $this->userid,$qualificationid);
            }else{
                $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>data already exist");
                return redirect("teacher/basic_edit");
            }
            $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
            return redirect("teacher/basic_edit");
        }
        $this->load->view('teacher/footer3');
    }


public function basic_edit3(){

        $this->load->view('teacher/header',['title'=>'Edit Teacher']);

       $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
        $this->form_validation->set_rules('bank_name'           , 'Bank Name'           , 'required|trim');
        $this->form_validation->set_rules('branch_name'             , 'Branch Name'         , 'required|trim');
        $this->form_validation->set_rules('account_holder_name'     , 'Account Holder Name' , 'required|trim');
        $this->form_validation->set_rules('ifsc_code'             , 'Ifsc Code'             , 'required|trim');
        $this->form_validation->set_rules('micr_code'             , 'Micr Code'             , 'required|trim');

        //echo "<pre>";print_r($country1);die;
         $country1 = $this->common_model->getCountry();
         $qualification_li   =   $this->teacher_model->qualification_listing();
         $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
         $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");

        $list             =  $this->teacher_model->basic_information($this->userid);
        $list1            =  $this->teacher_model->qualification_details($this->userid);
        $list2            =  $this->teacher_model->preferred_classes($this->userid);
        $list3            =  $this->teacher_model->bank_details($this->userid);
        $list4            =  $this->teacher_model->network_info($this->userid);

        if($this->form_validation->run()==false){
            //echo form_error();
               // echo validation_errors();
        //echo "false";echo "<pre>";print_r($_POST);die;
        //$this->load->view('teacher/teacher_edit',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,
        //'country45'=>$country1,'qualification_li'=>$qualification_li,'subject_primary'=>$subject_primary,'subject_secondary'=>$subject_secondary]);
        return redirect("teacher/basic_edit");
        }
        else{  //echo "<pre>";print_r($_POST);die;
            $dt             =   new DateTime();
            $bank_name        = strtolower(trim($this->input->post('bank_name')));
            $branch_name            = strtolower(trim($this->input->post('branch_name')));
            $account_holder_name        = strtolower(trim($this->input->post('account_holder_name')));
            $ifsc_code                  = strtolower(trim($this->input->post('ifsc_code')));
            $micr_code                  = strtolower(trim($this->input->post('micr_code')));
            $data_teacher_bank_detail = array('bank_name'=>$bank_name,'branch_name'=>$branch_name,'account_holder_name'=>$account_holder_name,
                                            'ifsc_code'=>$ifsc_code,'micr_code'=>$micr_code );

            $this->teacher_model->update_teacher_bank_detail($data_teacher_bank_detail, $this->userid);

            $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
            return redirect("teacher/basic_edit");
        }
        $this->load->view('teacher/footer3');
    }
    public function basic_edit4(){
        //echo "<pre>";print_r($_POST);die;
        $this->load->view('teacher/header',['title'=>'Edit Teacher']);

       $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
        $this->form_validation->set_rules('current_occupation'          , 'Current Occupation'                    , 'required|trim');
        $this->form_validation->set_rules('days_available[]'            , 'Days Available'                          , 'required|trim');
        $this->form_validation->set_rules('hours_week_ends_available'   , 'Hours Daily Available'                 , 'required|trim');
        $this->form_validation->set_rules('available_timings[]'         , 'Preferred Time for Teaching'             , 'required|trim');
        $this->form_validation->set_rules('total_teaching_experience'   , 'Total Teaching Experience'              , 'required|trim');
        $this->form_validation->set_rules('type_of_connection'          , 'Type of Connection'                       , 'required|trim');
        $this->form_validation->set_rules('down_internet_conn_speed'    , 'Download Speed of Internet Connection'   , 'required|trim');
        $this->form_validation->set_rules('upload_internet_conn_speed'      , 'Upload Speed of Internet Connection'       , 'required|trim');
        $this->form_validation->set_rules('association_with_gurukul'    , 'Association with gurukul is'                  , 'required|trim');
       // $this->form_validation->set_rules('come_to_know_tog_status'     , 'How you come to know with theonlinegurukul'    , 'required|trim');

        $country1 = $this->common_model->getCountry();
        $qualification_li   =   $this->teacher_model->qualification_listing();
        $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
        $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");

        $list             =  $this->teacher_model->basic_information($this->userid);
        $list1            =  $this->teacher_model->qualification_details($this->userid);
        $list2            =  $this->teacher_model->preferred_classes($this->userid);
        $list3            =  $this->teacher_model->bank_details($this->userid);
        $list4            =  $this->teacher_model->network_info($this->userid);

        if($this->form_validation->run()==false){
          // echo form_error();echo validation_errors(); echo "false";echo "<pre>";print_r($_POST);die;
            //$this->load->view('teacher/teacher_edit',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,
            //'country45'=>$country1,'qualification_li'=>$qualification_li,'subject_primary'=>$subject_primary,'subject_secondary'=>$subject_secondary]);
            return redirect("teacher/basic_edit");
        }
        else{  //echo "<pre>";print_r($_POST);die;
            $dt                             =   new DateTime();
            $current_occupation             =   strtolower(trim($this->input->post('current_occupation')));
            $days_available                 =   strtolower(implode(",",$this->input->post('days_available')));
            $hours_week_ends_available      =   strtolower(trim($this->input->post('hours_week_ends_available')));
            $available_timings              =   strtolower(implode(",",$this->input->post('available_timings')));
            $total_teaching_experience      =   strtolower(trim($this->input->post('total_teaching_experience')));
            $type_of_connection             =   strtolower(trim($this->input->post('type_of_connection')));
            $down_internet_conn_speed       =   strtolower(trim($this->input->post('down_internet_conn_speed')));
            $up_internet_conn_speed         =   strtolower(trim($this->input->post('upload_internet_conn_speed')));
            $association_with_gurukul       =   strtolower(trim($this->input->post('association_with_gurukul')));
            $come_to_know_tog_status        =   strtolower(trim($this->input->post('come_to_know_tog_status')));
            $data_teacher_network_info      =   array('current_occupation'=>$current_occupation,'days_available'=>$days_available,'hours_week_ends_available'=>$hours_week_ends_available,
                                                'available_timings'=>$available_timings,'total_teaching_experience'=>$total_teaching_experience,'type_of_connection'=>$type_of_connection,
                                                'down_internet_conn_speed'=>$down_internet_conn_speed,'up_internet_conn_speed'=>$up_internet_conn_speed,'association_with_gurukul'=>$association_with_gurukul,
                                                'come_to_know_tog_status'=>$come_to_know_tog_status
                                                );

            $this->teacher_model->update_teacher_network_info($data_teacher_network_info, $this->userid);

            $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
            return redirect("teacher/basic_edit");
        }
        $this->load->view('teacher/footer3');
    }

	public function view1(){

	    $country_list        =  $this->common_model->country_list();
	    $this->load->view('teacher/header',['title'=>'View Profile']);
	    $list            =  $this->teacher_model->user_profile($this->session->userdata('ts_id'));
	    $this->load->view('teacher/teacherdashboard',['list'=>$list,'country'=>$country_list]);
	    $this->load->view('teacher/footer');;
	}

	public function subject_approved_list_search(){
	//print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
            'class'		   	   =>  strtolower(trim($this->input->post('class'))),
            'subject'	       =>  strtolower(trim($this->input->post('subject')))


	    );
	    if(
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) ||
                (isset($data_taskpo['class'])	&& !empty($data_taskpo['class'])) ||
                (isset($data_taskpo['subject'])	&& !empty($data_taskpo['subject']))

	        )

                    {

	            $list         =	     $this->teacher_model->subject_approved_list_search($this->userid,$data_taskpo);
	            $links='';
                $category     =      $this->teacher_model->getcategory();

			$subject_code  =  $this->teacher_model->subject_code_lists();
            $this->load->view('teacher/header',['title'=>'Subject Approved','list'=>$list,'link'=>$links]);
            $this->load->view('teacher/subject_approved_list',['category'=>$category,'subject_code'=>$subject_code]);
            $this->load->view('teacher/footer');

	    }
	    else{
	        return redirect('teacher/subject_approved_list');
	    }
    }

    public function subject_approved_list_search2(){

            $subject_code1	   =  strtolower(trim($this->input->post('subject_code')));

	    if($this->input->post('subject_code')!="")
                    {

	            $list         =	     $this->teacher_model->subject_approved_list_search2($this->userid,$subject_code1);
	            $links='';
                $subject_code =      $this->teacher_model->subject_code_lists();
				$category     =      $this->teacher_model->getcategory();

            $this->load->view('teacher/header',['title'=>'Subject Approved','list'=>$list,'link'=>$links]);
            $this->load->view('teacher/subject_approved_list',['category'=>$category,'subject_code'=>$subject_code]);
            $this->load->view('teacher/footer');

	    }
	    else{
	        return redirect('teacher/subject_approved_list');
	    }
    }


	public function teacher_course_enrolled_list_search(){
	//print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
            'class'		   	   =>  strtolower(trim($this->input->post('class'))),
            'subject'	       =>  strtolower(trim($this->input->post('subject'))),
			'subject_code'	       =>  strtolower(trim($this->input->post('subject_code'))),
			'course_id_tag'	       =>  strtolower(trim($this->input->post('course_id_tag')))


	    );
	    if(
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) ||
                (isset($data_taskpo['class'])	&& !empty($data_taskpo['class'])) ||
                (isset($data_taskpo['subject'])	&& !empty($data_taskpo['subject'])) ||
				(isset($data_taskpo['subject_code'])	&& !empty($data_taskpo['subject_code'])) ||
				(isset($data_taskpo['course_id_tag'])	&& !empty($data_taskpo['course_id_tag']))
	        )

                    {

	            $list         =	     $this->teacher_model->teacher_course_enrolled_list_search($this->faculty_ids,$data_taskpo);
	            $links='';
                $category     =      $this->teacher_model->getcategory();
				$subject_code =      $this->teacher_model->subject_code_lists();


            $this->load->view('teacher/header',['title'=>'Course Enrolled','list'=>$list,'link'=>$links]);
            $this->load->view('teacher/teacher_course_enrolled_list',['category'=>$category,'subject_code'=>$subject_code]);
            $this->load->view('teacher/footer');

	    }
	    else{
	        return redirect('teacher/teacher_course_enrolled_list');
	    }
    }

    public function teacher_course_enrolled_list_search2(){

            $subject_code1	   =  strtolower(trim($this->input->post('subject_code')));

	    if($this->input->post('subject_code')!=""){

            $list         =	     $this->teacher_model->teacher_course_enrolled_list_search2($this->faculty_ids,$subject_code1);
            $links='';
            $category     =      $this->teacher_model->getcategory();
            $subject_code =      $this->teacher_model->subject_code_lists();

            $this->load->view('teacher/header',['title'=>'Course Enrolled','list'=>$list,'link'=>$links]);
            $this->load->view('teacher/teacher_course_enrolled_list',['category'=>$category,'subject_code'=>$subject_code]);
            $this->load->view('teacher/footer');

	    }
	    else{
	        return redirect('teacher/teacher_course_enrolled_list');
	    }
    }



	public function recent_classes_15_days_search(){
	//print_r($_POST);die;
	    $data_taskpo=array(
	        'category'		   =>  strtolower(trim($this->input->post('category'))),
            'class'		   	   =>  strtolower(trim($this->input->post('class'))),
            'subject'	       =>  strtolower(trim($this->input->post('subject'))),
			'subject_code'	       =>  strtolower(trim($this->input->post('subject_code'))),
			'course_id'	       =>  strtolower(trim($this->input->post('course_id')))


	    );
	    if(
	            (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) ||
                (isset($data_taskpo['class'])	&& !empty($data_taskpo['class'])) ||
                (isset($data_taskpo['subject'])	&& !empty($data_taskpo['subject'])) ||
				(isset($data_taskpo['subject_code'])	&& !empty($data_taskpo['subject_code'])) ||
				(isset($data_taskpo['course_id'])	&& !empty($data_taskpo['course_id']))
	        )

                    {

	            $list         =	     $this->teacher_model->recent_classes_15_days_search($this->faculty_ids,$data_taskpo);
	            $links='';
                $category     =      $this->teacher_model->getcategory();
				$subject_code =      $this->teacher_model->subject_code_lists();


            $this->load->view('teacher/header',['title'=>'Course Enrolled','list'=>$list,'link'=>$links]);
            $this->load->view('teacher/recent_classes_15_days',['category'=>$category,'subject_code'=>$subject_code]);
            $this->load->view('teacher/footer');

	    }
	    else{
	        return redirect('teacher/recent_classes_15_days');
	    }
    }
	public function recent_classes_15_days_search2(){

            $subject_code1	   =  strtolower(trim($this->input->post('subject_code')));

	    if($this->input->post('subject_code')!="")
                    {

	            $list         =	     $this->teacher_model->recent_classes_15_days_search2($this->faculty_ids,$subject_code1);
	            $links='';
                $category     =      $this->teacher_model->getcategory();
				$subject_code =      $this->teacher_model->subject_code_lists();

            $this->load->view('teacher/header',['title'=>'Course Enrolled','list'=>$list,'link'=>$links]);
            $this->load->view('teacher/recent_classes_15_days',['category'=>$category,'subject_code'=>$subject_code]);
            $this->load->view('teacher/footer');

	    }
	    else{
	        return redirect('teacher/recent_classes_15_days');
	    }
    }
	public function earning_list_search(){
        //print_r($_POST);die;
            $data_taskpo=array(
                'category'		   =>  strtolower(trim($this->input->post('category'))),
                'class'		   	   =>  strtolower(trim($this->input->post('class'))),
                'subject'	       =>  strtolower(trim($this->input->post('subject'))),
                'course_id'	       =>  strtolower(trim($this->input->post('course_id')))



            );
            if(
                    (isset($data_taskpo['category'])	&& !empty($data_taskpo['category'])) ||
                    (isset($data_taskpo['class'])	&& !empty($data_taskpo['class'])) ||
                    (isset($data_taskpo['subject'])	&& !empty($data_taskpo['subject'])) ||
                    (isset($data_taskpo['course_id'])	&& !empty($data_taskpo['course_id']))
                )

                        {

                    $list         =	     $this->teacher_model->earning_list_search($data_taskpo,$this->faculty_ids);
                    $links='';
                    $category     =      $this->teacher_model->getcategory();
                    $subject_code =      $this->teacher_model->subject_code_lists();

                $this->load->view('teacher/header',['title'=>'Earning History','list'=>$list,'link'=>$links]);
                //$this->load->view('teacher/sidebar');
                $this->load->view('teacher/teacher_earnings',['category'=>$category,'subject_code'=>$subject_code]);
                $this->load->view('teacher/footer');

            }
            else{
                return redirect('teacher/earning');
            }
        }

		public function earning_list_search2(){

            $subject_code1	   =  strtolower(trim($this->input->post('subject_code')));

        if($this->input->post('subject_code')!="")
                    {

                $list         =	     $this->teacher_model->earning_list_search2($subject_code1,$this->faculty_ids);
                $links='';
                $category     =      $this->teacher_model->getcategory();
                $subject_code =      $this->teacher_model->subject_code_lists();

            $this->load->view('teacher/header',['title'=>'Earning History','list'=>$list,'link'=>$links]);
           // $this->load->view('teacher/sidebar');
            $this->load->view('teacher/teacher_earnings',['category'=>$category,'subject_code'=>$subject_code]);
            $this->load->view('teacher/footer');

        }
        else{
            return redirect('teacher/earning');
        }
        }


	public function get_category_class(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_category_class($postData);
        echo json_encode($data);
    }
    public function get_class_subject(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_class_subject($postData);
        echo json_encode($data);
    }
    public function get_subject_chapter(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_subject_chapter($postData);
        echo json_encode($data);
    }
    public function get_chapter_topic(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_chapter_topic($postData);
        echo json_encode($data);
    }

    public function get_class_subject_faculty(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_class_subject_faculty($postData);
        echo json_encode($data);
    }
    public function get_class_subject_course_maded_list(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_class_subject_course_maded_list($postData);
        echo json_encode($data);
    }
    public function get_class_subject_course_classid_list(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_class_subject_course_classid_list($postData);
        echo json_encode($data);
    }
    public function get_class_subject_course_maded_info(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_class_subject_course_maded_info($postData);
        echo json_encode($data);
    }
    public function get_class_amount_info(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_class_amount_info($postData);
        echo json_encode($data);
    }
    public function get_class_amount_info_after_over_class(){
        $postData   =   $this->input->post();
        $data       =   $this->teacher_model->get_class_amount_info_after_over_class($postData);
        echo json_encode($data);
    }


}
?>
