<?php
defined("BASEPATH")or exit("NO Direct Access is Allowed");

Class Teacher extends CI_Controller{
  protected $limit, $offset;
  public function __construct(){

    parent::__construct();
    $this->load->library(['form_validation','bcrypt','email','session','pagination']);
    $this->load->helper(['html','form','url','security','string','file','directory']);
    $this->load->model('CommonModel','common_model');
    $this->load->model('TeacherModel','teacher_model');
    //$this->load->model('admin/Adminltemodel','adminlte_model');
    if(!$this->session->userdata('ts_id') ){return redirect('teacher/signin');}
    if($this->session->userdata('ss_id') ){return redirect('student/signin');}
    if($this->session->userdata('ad_id') ){return redirect('teacher/signin');}
    $list_id					          =		$this->session->userdata('ts_id');
    //echo $list_id;die;
    $this->userid               =   substr($list_id, 16);
    $this->teacher_data	        =		$this->teacher_model->user_profile($list_id);
    $this->teacher_data1	      =		$this->teacher_model->basic_information();
    $this->faculty_ids          =   $this->teacher_model->v2_faculty_list();

   //date_default_timezone_set('Asia/Kolkata');
    if(isset($_COOKIE['timezone_get'])) {
       date_default_timezone_set(htmlspecialchars_decode($_COOKIE['timezone_get']));
       $this->session->set_userdata('user_timezone',htmlspecialchars_decode($_COOKIE['timezone_get']));
    } else {
      date_default_timezone_set("Asia/Calcutta");
      $this->session->set_userdata('user_timezone',htmlspecialchars_decode("Asia/Calcutta"));
    }
    error_reporting(0);
  }
  public function index(){
      return redirect("Teacher/recent-classes");
  }
  public function logout(){
  		$this->session->unset_userdata('ts_id');
  		$this->session->sess_destroy();
  		return redirect('teacher/signin');
  }
  public function  upcoming_classes(){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					   =>	site_url("Teacher/upcoming_classes"),
          'total_rows'					 =>	$this->teacher_model->upcoming_classes_num_row(),
          'per_page'					   =>	$perpage,
          'display_pages'				 =>	TRUE,
          'use_page_numbers'		 => 	TRUE,
          'uri_segment'					 =>	3,
          'num_links'					   =>	10,
          'full_tag_open'				 =>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'			 =>	"</ul>",
          'first_tag_open'			 =>	'<li>',
          'first_tag_close'			 =>	'</li>',
          'last_tag_open'				 =>	'<li>',
          'last_tag_close'			 =>	'</li>',
          'next_tag_open'				 =>	'<li>',
          'next_tag_close'			 =>	'</li>',
          'prev_tag_open'				 =>	'<li>',
          'prev_tag_close'			 =>	'</li>',
          'num_tag_open'				 =>	'<li>',
          'num_tag_close'				 =>	'</li>',
          'cur_tag_open'				 =>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'			 	 =>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      $list 		                =  $this->teacher_model->upcoming_classes_list($config['per_page'],$page);
      $links		                =  $this->pagination->create_links();
      //$category  =  $this->teacher_model->getcategory();
      //$subject_code  =  $this->teacher_model->subject_code_lists();
      $this->load->view('teacher/header',['title'=>'Recent Classes','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/upcoming_classes',[]);
      $this->load->view('teacher/footer');
  }
  public function  past_classes(){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					   =>	site_url("Teacher/past_classes"),
          'total_rows'					 =>	$this->teacher_model->past_classes_num_row(),
          'per_page'					   =>	$perpage,
          'display_pages'				 =>	TRUE,
          'use_page_numbers'		 => 	TRUE,
          'uri_segment'					 =>	3,
          'num_links'					   =>	10,
          'full_tag_open'				 =>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'			 =>	"</ul>",
          'first_tag_open'			 =>	'<li>',
          'first_tag_close'			 =>	'</li>',
          'last_tag_open'				 =>	'<li>',
          'last_tag_close'			 =>	'</li>',
          'next_tag_open'				 =>	'<li>',
          'next_tag_close'			 =>	'</li>',
          'prev_tag_open'				 =>	'<li>',
          'prev_tag_close'			 =>	'</li>',
          'num_tag_open'				 =>	'<li>',
          'num_tag_close'				 =>	'</li>',
          'cur_tag_open'				 =>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'			 	 =>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      $list 		                =  $this->teacher_model->past_classes_list($config['per_page'],$page);
      $links		                =  $this->pagination->create_links();
      //$category  =  $this->teacher_model->getcategory();
      //$subject_code  =  $this->teacher_model->subject_code_lists();
      $this->load->view('teacher/header',['title'=>'Recent Classes','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/past_classes',[]);
      $this->load->view('teacher/footer');
  }
  public function teacher_course_enrolled_list(){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url('Teacher/teacher_course_enrolled_list'),
          'total_rows'					=>	$this->teacher_model->teacher_crs_enrld_list_num_row(),
          'per_page'					=>	$perpage,
          'display_pages'				=>	TRUE,
          'use_page_numbers'				=> 	TRUE,
          'uri_segment'					=>	3,
          'num_links'					=>	10,
          'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'				=>	"</ul>",
          'first_tag_open'				=>	'<li>',
          'first_tag_close'				=>	'</li>',
          'last_tag_open'				=>	'<li>',
          'last_tag_close'				=>	'</li>',
          'next_tag_open'				=>	'<li>',
          'next_tag_close'				=>	'</li>',
          'prev_tag_open'				=>	'<li>',
          'prev_tag_close'				=>	'</li>',
          'num_tag_open'				=>	'<li>',
          'num_tag_close'				=>	'</li>',
          'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      $list 		                =  $this->teacher_model->teacher_crs_enrld_list($config['per_page'],$page);
      $links		                =  $this->pagination->create_links();
      //$category                     =  $this->teacher_model->getcategory();
    //  $subject_code  				=  $this->teacher_model->subject_code_lists();
      $this->load->view('teacher/header',['title'=>'Course Enrolled','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/teacher_course_enrolled_list',[]);
      $this->load->view('teacher/footer');
  }

  public function teacher_course_enrolled_class_list($course_id){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url("Teacher/teacher_course_enrolled_class_list/$course_id"),
          'total_rows'					=>	$this->teacher_model->course_class_list_by_courseid_num_rows($course_id),
          'per_page'					=>	$perpage,
          'display_pages'				=>	TRUE,
          'use_page_numbers'			=> 	TRUE,
          'uri_segment'					=>	4,
          'num_links'					=>	10,
          'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'				=>	"</ul>",
          'first_tag_open'				=>	'<li>',
          'first_tag_close'				=>	'</li>',
          'last_tag_open'				=>	'<li>',
          'last_tag_close'				=>	'</li>',
          'next_tag_open'				=>	'<li>',
          'next_tag_close'				=>	'</li>',
          'prev_tag_open'				=>	'<li>',
          'prev_tag_close'				=>	'</li>',
          'num_tag_open'				=>	'<li>',
          'num_tag_close'				=>	'</li>',
          'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(4)) ? $this->uri->segment(4) : 1;
      $list 		                =  $this->teacher_model->course_class_list_by_courseid($config['per_page'],$page,$course_id);
      $links		                =  $this->pagination->create_links();

      $this->load->view('teacher/header',['title'=>'Class List','list'=>$list,'link'=>$links]);
      $this->load->view('teacher/teacher_course_enrolled_class_list');
      $this->load->view('teacher/footer');
  }

    public function subject_approved_list(){

        $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
        if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
        $config = [
            'base_url'					=>	site_url("Teacher/subject_approved_list"),
            'total_rows'					=>	$this->teacher_model->subject_approved_list_num_row($this->userid),
            'per_page'					=>	$perpage,
            'display_pages'				=>	TRUE,
            'use_page_numbers'			=> 	TRUE,
            'uri_segment'					=>	3,
            'num_links'					=>	10,
            'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
            'full_tag_close'				=>	"</ul>",
            'first_tag_open'				=>	'<li>',
            'first_tag_close'				=>	'</li>',
            'last_tag_open'				=>	'<li>',
            'last_tag_close'				=>	'</li>',
            'next_tag_open'				=>	'<li>',
            'next_tag_close'				=>	'</li>',
            'prev_tag_open'				=>	'<li>',
            'prev_tag_close'				=>	'</li>',
            'num_tag_open'				=>	'<li>',
            'num_tag_close'				=>	'</li>',
            'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
            'cur_tag_close'				=>	'</a></li>',
        ];
        $this->pagination->initialize($config);
        $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
        $list 		                =  $this->teacher_model->subject_approved_list($config['per_page'],$page,$this->userid);
        $links		                =  $this->pagination->create_links();
        //$category  =  $this->teacher_model->getcategory();
        //$subject_code  =  $this->teacher_model->subject_code_lists();
        $this->load->view('teacher/header',['title'=>'Subject List','list'=>$list,'link'=>$links,
            "request_made"=>$test3]);
        $this->load->view('teacher/subject_approved_list', []);
        $this->load->view('teacher/footer');
    }
    public function account_status(){
      $this->load->view('teacher/header',[]);
      $this->load->view('teacher/account_status');
      $this->load->view('teacher/footer');
    }
    public function basic_edit(){

          $this->load->view('teacher/header',['title'=>'Edit Teacher']);
          $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
          $this->form_validation->set_rules('first_name'      , 'First Name'     , 'required|trim');
          $this->form_validation->set_rules('last_name'       , 'Last Name'      , 'required|trim');
          $this->form_validation->set_rules('mobile'          , 'Contact'        , 'required|trim|exact_length[10]|numeric');
          $this->form_validation->set_rules('date_of_birth'   , 'Date of Birth'  , 'required|trim');
          $this->form_validation->set_rules('gender'          , 'Gender'         , 'required|trim');
          $this->form_validation->set_rules('country_id'      , 'Country'        , 'required|trim');
          $this->form_validation->set_rules('state_id'        , 'State'          , 'required|trim');
          $this->form_validation->set_rules('city_id'         , 'City'           , 'required|trim');
          $this->form_validation->set_rules('zip_code'        , 'Zip Code'       , 'required|trim');
          $this->form_validation->set_rules('aadhar_id'       , 'Aadhar Id'      , 'required|trim');
          $this->form_validation->set_rules('pan_id'          , 'Pan Card'       , 'required|trim');

          $country1           =   $this->common_model->getCountry();

          $qualification_li   =   $this->teacher_model->qualification_listing();
          $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
          $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");
          $list               =   $this->teacher_model->basic_information();
          $list1              =   $this->teacher_model->qualification_details();
          $list2              =   $this->teacher_model->preferred_classes();
          $list3              =   $this->teacher_model->bank_details();
          $list4              =   $this->teacher_model->network_info();

          if($this->form_validation->run()==false){
              //echo form_error();echo validation_errors(); echo "false";echo "<pre>";print_r($_POST);die;
              $this->load->view('teacher/teacher_edit',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,
              'country45'=>$country1,'qualification_li'=>$qualification_li,'subject_primary'=>$subject_primary,'subject_secondary'=>$subject_secondary]);
          }
          else{  //echo "<pre>";print_r($_POST);die;
              $dt                     =   new DateTime();
              $first_name             =   strtolower(trim($this->input->post('first_name')));
              $last_name              =   strtolower(trim($this->input->post('last_name')));
              $mobile                 =   strtolower(trim($this->input->post('mobile')));
              $date_of_birth          =   strtolower(trim($this->input->post('date_of_birth')));
              $gender                 =   strtolower(trim($this->input->post('gender')));
              $zip_code               =   strtolower(trim($this->input->post('zip_code')));
              $aadhar_id              =   strtolower(trim($this->input->post('aadhar_id')));
              $pan_id                 =   strtolower(trim($this->input->post('pan_id')));
              $country_id             =   strtolower(trim($this->input->post('country_id')));
              $state_id               =   strtolower(trim($this->input->post('state_id')));
              $city_id                =   strtolower(trim($this->input->post('city_id')));
              $data_teacher_master    =   array('first_name'=>$first_name,'last_name'=>$last_name,'mobile'=>$mobile,'gender'=>$gender );
              $data_teacher_basic     =   array('dob'=>$date_of_birth,'country_id'=>$country_id,'state_id'=>$state_id,'city_id'=>$city_id,
                                                  'zip_code'=>$zip_code,'aadhar_id'=>$aadhar_id,'pan_id'=>$pan_id);

              $this->teacher_model->update_teacher_master($data_teacher_master);
              $this->teacher_model->update_teacher_basic($data_teacher_basic);
              $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
              return redirect("teacher/basic_edit");
          }
          $this->load->view('teacher/footer3');
      }
      public function basic_edit2(){
         $this->load->view('teacher/header',['title'=>'Edit Teacher']);
         $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
         $this->form_validation->set_rules('qualid[]'           , 'Qualification id'   , 'required|trim');
          // $this->form_validation->set_rules('qualification[]'           , 'Qualification'   , 'required|trim');
          //$this->form_validation->set_rules('university[]'              , 'University'      , 'required|trim');
          // $this->form_validation->set_rules('passing_year[]'            , 'Passing year'    , 'required|trim');
          // $this->form_validation->set_rules('grade[]'                   , 'Grade'           , 'required|trim');
         $country1           =   $this->common_model->getCountry();
         $qualification_li   =   $this->teacher_model->qualification_listing();
         $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
         $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");
         $list               =   $this->teacher_model->basic_information();
         $list1              =   $this->teacher_model->qualification_details();
         $list2              =   $this->teacher_model->preferred_classes();
         $list3              =   $this->teacher_model->bank_details();
         $list4              =   $this->teacher_model->network_info();

         if($this->form_validation->run()==false){
           return redirect("teacher/basic_edit");
         }
         else{    // echo "<pre>";print_r($_POST);die;
             $i=0;
             foreach($_POST['qualid'] as $qualid){
               $data_teacher_qualfication = array('qualification'=>$_POST['qualification'][$i],'university'=>$_POST['university'][$i],
               'passing_year'=>$_POST['passing_year'][$i],'grade'=>$_POST['grade'][$i]);
               $this->teacher_model->update_teacher_qualfication($data_teacher_qualfication,$qualid);
               $i++;
             }
             $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
             return redirect("teacher/basic_edit");
         }
         $this->load->view('teacher/footer3');
     }
      public function basic_edit1(){
            $this->load->view('teacher/header',['title'=>'Edit Teacher']);
            $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
            $this->form_validation->set_rules('preferid[]'            , 'preferid'             , 'required|trim');
            //$this->form_validation->set_rules('class[]'            , 'Class'             , 'required|trim');
            //$this->form_validation->set_rules('primary_sub[]'      , 'Primary Subject'   , 'required|trim');
            //$this->form_validation->set_rules('secondary_sub[]'    , 'Secondary Subject' , 'required|trim');
            //$this->form_validation->set_rules('other'            , 'Other'             , 'required|trim');

            $country1           =   $this->common_model->getCountry();
            $qualification_li   =   $this->teacher_model->qualification_listing();
            $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
            $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");
            $list               =   $this->teacher_model->basic_information();
            $list1              =   $this->teacher_model->qualification_details();
            $list2              =   $this->teacher_model->preferred_classes();
            $list3              =   $this->teacher_model->bank_details();
            $list4              =   $this->teacher_model->network_info();

            if($this->form_validation->run()==false){
                return redirect("teacher/basic_edit");
            }
            else{   //echo "<pre>";print_r($_POST);die;
              $i=0;
              foreach($_POST['preferid'] as $pfid){
                $data_teacher_pf_class   =   array('class'=>$_POST['class'][$i],'primary_sub'=>$_POST['primary_sub'][$i],
                'secondary_sub'=>$_POST['secondary_sub'][$i],'other'=>$_POST['other'][$i] );
                  $this->teacher_model->update_teacher_pf_class($data_teacher_pf_class,$pfid);
                $i++;
              }
                $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
                return redirect("teacher/basic_edit");
            }
            $this->load->view('teacher/footer3');
        }


        public function basic_edit3(){

            $this->load->view('teacher/header',['title'=>'Edit Teacher']);

           $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
            $this->form_validation->set_rules('bank_name'               , 'Bank Name'               , 'trim');
            $this->form_validation->set_rules('branch_name'             , 'Branch Name'             , 'trim');
            $this->form_validation->set_rules('account_holder_name'     , 'Account Holder Name'     , 'trim');
            $this->form_validation->set_rules('ifsc_code'               , 'Ifsc Code'               , 'trim');
            $this->form_validation->set_rules('micr_code'               , 'Micr Code'               , 'trim');

            //echo "<pre>";print_r($country1);die;
             $country1 = $this->common_model->getCountry();
             $qualification_li   =   $this->teacher_model->qualification_listing();
             $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
             $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");

             $list             =  $this->teacher_model->basic_information();
             $list1            =  $this->teacher_model->qualification_details();
             $list2            =  $this->teacher_model->preferred_classes();
             $list3            =  $this->teacher_model->bank_details();
             $list4            =  $this->teacher_model->network_info();

            if($this->form_validation->run()==false){
              return redirect("teacher/basic_edit");
            }
            else{  //echo "<pre>";print_r($_POST);die;
                $bank_name                  = strtolower(trim($this->input->post('bank_name')));
                $branch_name                = strtolower(trim($this->input->post('branch_name')));
                $account_holder_name        = strtolower(trim($this->input->post('account_holder_name')));
                $ifsc_code                  = strtolower(trim($this->input->post('ifsc_code')));
                $micr_code                  = strtolower(trim($this->input->post('micr_code')));
                $data_teacher_bank_detail = array('bank_name'=>$bank_name,'branch_name'=>$branch_name,'account_holder_name'=>$account_holder_name,
                                                'ifsc_code'=>$ifsc_code,'micr_code'=>$micr_code );
                $this->teacher_model->update_teacher_bank_detail($data_teacher_bank_detail);

                $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
                return redirect("teacher/basic_edit");
            }
            $this->load->view('teacher/footer3');
        }
        public function basic_edit4(){
            $this->load->view('teacher/header',['title'=>'Edit Teacher']);

           $this->form_validation->set_error_delimiters('<p class="text-red">', '</p>');
            $this->form_validation->set_rules('current_occupation'          , 'Current Occupation'                    , 'required|trim');
            $this->form_validation->set_rules('days_available[]'            , 'Days Available'                          , 'required|trim');
            $this->form_validation->set_rules('hours_week_ends_available'   , 'Hours Daily Available'                 , 'required|trim');
            $this->form_validation->set_rules('available_timings[]'         , 'Preferred Time for Teaching'             , 'required|trim');
            $this->form_validation->set_rules('total_teaching_experience'   , 'Total Teaching Experience'              , 'required|trim');
            $this->form_validation->set_rules('type_of_connection'          , 'Type of Connection'                       , 'required|trim');
            $this->form_validation->set_rules('down_internet_conn_speed'    , 'Download Speed of Internet Connection'   , 'required|trim');
            $this->form_validation->set_rules('upload_internet_conn_speed'      , 'Upload Speed of Internet Connection'       , 'required|trim');
            $this->form_validation->set_rules('association_with_gurukul'    , 'Association with gurukul is'                  , 'required|trim');
           // $this->form_validation->set_rules('come_to_know_tog_status'     , 'How you come to know with theonlinegurukul'    , 'required|trim');

            $country1 = $this->common_model->getCountry();
            $qualification_li   =   $this->teacher_model->qualification_listing();
            $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
            $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");

            $list             =  $this->teacher_model->basic_information();
            $list1            =  $this->teacher_model->qualification_details();
            $list2            =  $this->teacher_model->preferred_classes();
            $list3            =  $this->teacher_model->bank_details();
            $list4            =  $this->teacher_model->network_info();

            if($this->form_validation->run()==false){
                return redirect("teacher/basic_edit");
            }
            else{ // echo "<pre>";print_r($_POST);die;
                $current_occupation             =   strtolower(trim($this->input->post('current_occupation')));
                $days_available                 =   strtolower(implode(",",$this->input->post('days_available')));
                $hours_week_ends_available      =   strtolower(trim($this->input->post('hours_week_ends_available')));
                $available_timings              =   strtolower(implode(",",$this->input->post('available_timings')));
                $total_teaching_experience      =   strtolower(trim($this->input->post('total_teaching_experience')));
                $type_of_connection             =   strtolower(trim($this->input->post('type_of_connection')));
                $down_internet_conn_speed       =   strtolower(trim($this->input->post('down_internet_conn_speed')));
                $up_internet_conn_speed         =   strtolower(trim($this->input->post('upload_internet_conn_speed')));
                $association_with_gurukul       =   strtolower(trim($this->input->post('association_with_gurukul')));
                $come_to_know_tog_status        =   strtolower(trim($this->input->post('come_to_know_tog_status')));
                $data_teacher_network_info      =   array('current_occupation'=>$current_occupation,'days_available'=>$days_available,'hours_week_ends_available'=>$hours_week_ends_available,
                                                    'available_timings'=>$available_timings,'total_teaching_experience'=>$total_teaching_experience,'type_of_connection'=>$type_of_connection,
                                                    'down_internet_conn_speed'=>$down_internet_conn_speed,'up_internet_conn_speed'=>$up_internet_conn_speed,'association_with_gurukul'=>$association_with_gurukul,
                                                    'come_to_know_tog_status'=>$come_to_know_tog_status
                                                    );

                $this->teacher_model->update_teacher_extra_info23($data_teacher_network_info);

                $this->session->set_flashdata('message', "<i class='icon fa fa-check'></i>Teacher updated successfully");
                return redirect("teacher/basic_edit");
            }
            $this->load->view('teacher/footer3');
        }

        public function change_password(){
        //  print_r($_POST);die;
        $this->load->library('bcrypt');
            $current_password =  $this->input->post('current_password');
            $password         =  $this->input->post('password');
            $confirm_password =  $this->input->post('confirm_password');

            if($password==$confirm_password){
              $login      =  $this->teacher_model->check_password($this->userid);
              if($this->bcrypt->check_password($current_password, $login->password)){

                    $hash =  $this->bcrypt->hash_password($password);
                    $this->teacher_model->update_password($this->userid,$hash);
                    echo "Password  Change Succesfully";
                  //  $this->logout();
                  //  $this->session->set_flashdata('success',"Password  Change Succesfully");
                    //return redirect('Student/signin');
              }else{
                echo "Current Password is wrong";
              }
            }else{
                echo "Confirm Password Mismatch";
            }
        }
        public function profile(){
          $qualification_li   =   $this->teacher_model->qualification_listing();
        //  $subject_primary    =   $this->teacher_model->subjectshow_listing("Primary");
        //  $subject_secondary  =   $this->teacher_model->subjectshow_listing("Secondary");

          $list             =  $this->teacher_model->basic_information();
          $list1            =  $this->teacher_model->qualification_details();
          $list2            =  $this->teacher_model->preferred_classes();
          $list3            =  $this->teacher_model->bank_details();
          $list4            =  $this->teacher_model->network_info();
          $this->load->view('teacher/header-new');
          $this->load->view('teacher/profile',['list'=>$list,'list1'=>$list1,'list2'=>$list2,'list3'=>$list3,'list4'=>$list4,'qual'=>$qualification_li]);
          $this->load->view('teacher/footer3');
        }

        public function upload_profile(){

          $this->load->view("student/header_profile",[]);
          $this->load->view("student/sidebar");
          $country1          =  $this->common_model->getCountry();
          $data              =  array();
          if($this->input->post('fileSubmit') && !empty($_FILES['userFiles']['name'])){
            $filesCount = count($_FILES['userFiles']['name']);
            //echo $_FILES['userFiles']['name'];echo $filesCount;die;
            for($i = 0; $i < $filesCount; $i++){
              $_FILES['userFile']['name'] 	   = 	$_FILES['userFiles']['name'][$i];
              $_FILES['userFile']['type'] 	   = 	$_FILES['userFiles']['type'][$i];
              $_FILES['userFile']['tmp_name']  = 	$_FILES['userFiles']['tmp_name'][$i];
              $_FILES['userFile']['error'] 	   = 	$_FILES['userFiles']['error'][$i];
              $_FILES['userFile']['size'] 	   = 	$_FILES['userFiles']['size'][$i];
              $uploadPath 					           = 	"./uploads/user/images/$this->userid/profile/";
              if(!is_dir($uploadPath )){mkdir($uploadPath, 0777, TRUE );}
              $config['upload_path'] 			     = 	$uploadPath;
              $config['allowed_types'] 		     = 	'jpg|png|gif|jpeg|JPG|PNG|GIF';
              $config['overwrite'] 			       = 	'1';
              //$config['max_size']	           =  '100';
              //$config['max_width']           =  '1024';
              //$config['max_height']          =  '768';
              $this->load->library('upload', $config);
              $this->upload->initialize($config);
              if($this->upload->do_upload('userFile')){
                $fileData = $this->upload->data();
                $config1['image_library']      =   'gd2';
                $config1['source_image']       =   $fileData['full_path'];
                $config1['create_thumb']       =   TRUE;
                $config1['maintain_ratio']     =   TRUE;
                $config1['width']              =   62;
                $config1['height']             =   58;
                $this->load->library('image_lib', $config1);
                if (!$this->image_lib->resize()) {
                    $this->handle_error($this->image_lib->display_errors());
                }
                $this->teacher_model->update_profile_pic($this->userid,$config['upload_path'].$fileData['file_name']);
                //print_r($fileData);die;//  $this->student_model->update_profile_pic($id,$path);
              }
            }
               $this->session->set_flashdata('success', 'Profile Added Succesfully');
               return redirect("Teacher/upload_profile");
          }
          else{
                  $data['error'] = "Error occured";
                  $this->load->view('teacher/upload_profile', $data);
            }
             // $this->load->view('student/upload_profile', $data);
               $this->load->view("teacher/footer3");
        }




}
?>
