<?php
defined("BASEPATH")or exit("NO Direct Access is Allowed");

Class Student extends CI_Controller{
    protected $limit, $offset;
  public function __construct(){

    parent::__construct();
    $this->load->library(['form_validation','bcrypt','email','session','pagination','user_agent']);
    $this->load->helper(['html','form','url','security','string','file','directory']);
    $this->load->model('CommonModel','common_model');
    $this->load->model('StudentModel','student_model');
    $ss_id                      =   $this->session->userdata('ss_id');
    $this->userid               =   substr($ss_id, 16);
    if(!$this->session->userdata('ss_id')){return redirect('student/signin');}
    if($this->session->userdata('ts_id')){return redirect('teacher/signin');}
    if($this->session->userdata('ad_id')){return redirect('teacher/signin');}
    $this->student_data	        =	   $this->student_model->user_profile($ss_id);

    if(isset($_COOKIE['timezone_get'])) {
       date_default_timezone_set(htmlspecialchars_decode($_COOKIE['timezone_get']));
       $this->session->set_userdata('user_timezone',htmlspecialchars_decode($_COOKIE['timezone_get']));
    } else {
      date_default_timezone_set("Asia/Calcutta");
      $this->session->set_userdata('user_timezone',htmlspecialchars_decode("Asia/Calcutta"));
    }
   error_reporting(0);


  }
  public function index(){
      return redirect('Student/upcoming-classes');
  }
 public function grade(){
		if(!empty($_POST))
		{
			$ids = '';
			$anss = '';
		foreach($_POST as $id => $ans)
		{
			$ids .='"'.$id.'",';
			$anss .= '"'.$ans.'",';
		}
		$idd = rtrim($ids,",");
		$answer = rtrim($anss,",");
		$result = $this->student_model->dataforgrade($idd,$answer);
		$data['result'] = $result;
		$totq = $_POST['totq'];
		$data['totq'] = $totq;
		$this->load->view('quiz/grade',$data);
		}
		else
		{
			$this->load->view('quiz/grade');
		}
	}
	public function add_records(){
		$this->form_validation->set_rules('question', 'Question', 'required');
		$this->form_validation->set_rules('option_first', 'Option 1', 'required');
		$this->form_validation->set_rules('option_second', 'Option 2', 'required');
		$this->form_validation->set_rules('option_third', 'Option 3', 'required');
		$this->form_validation->set_rules('option_four', 'Option 4', 'required');
		$this->form_validation->set_rules('myanswer', 'Answer', 'required');
		if($this->form_validation->run() == false)
		{
			$this->load->view('quiz/add_records');
		}
		else
		{
			$dataarr = array(
				'que'           => $this->input->post('question'),
				'option_1'  => $this->input->post('option_first'),
				'option_2' => $this->input->post('option_second'),
				'option_3'  => $this->input->post('option_third'),
				'option_4	'   => $this->input->post('option_four'),
				'ans'      => $this->input->post('myanswer')
			);
			$this->student_model->add_question_answer($dataarr);
			redirect('quiz/add_records');
			//$this->load->view('quiz/add_records');
		}
	}
  public function logout(){
    $this->session->unset_userdata('ss_id');
    $this->session->sess_destroy();

    return redirect('student/signin');
  }
  public function change_password(){
  //  print_r($_POST);die;
  $this->load->library('bcrypt');
      $current_password =  $this->input->post('current_password');
      $password         =  $this->input->post('password');
      $confirm_password =  $this->input->post('confirm_password');

      if($password==$confirm_password){
        $login      =  $this->student_model->check_password($this->userid);
        if($this->bcrypt->check_password($current_password, $login->password)){

              $hash =  $this->bcrypt->hash_password($password);
              $this->student_model->update_password($this->userid,$hash);
              echo "Password  Change Succesfully";
            //  $this->logout();
            //  $this->session->set_flashdata('success',"Password  Change Succesfully");
              //return redirect('Student/signin');
        }else{
          echo "Current Password is wrong";
        }
      }else{
          echo "Confirm Password Mismatch";
      }
  }
  public function quiz_iframe(){
	$result = $this->student_model->selectrecordsforview();
		//$this->load->view('quiz/quiz', $qdata);
    $this->load->view("student/header-quiz");
	
	if(!empty($_POST))
		{
			$ids = '';
			$anss = '';
		foreach($_POST as $id => $ans)
		{
			$ids .='"'.$id.'",';
			$anss .= '"'.$ans.'",';
		}
		$idd = rtrim($ids,",");
		$answer = rtrim($anss,",");
		$result = $this->student_model->dataforgrade($idd,$answer);
		$data['result'] = $result;
		$totq = $_POST['totq'];
		$data['totq'] = $totq;
		//$this->load->view('quiz/grade',$data);
		$this->load->view("student/quiz_test",['list'=>$data]);
		}
		else
		{
			$this->load->view("student/quiz_test",['list'=>$result]);
		}
    //$this->load->view("student/quiz_test",['list'=>$result]);
    $this->load->view("student/footer-quiz");
  }
  public function  quiz(){
    $this->load->view('student/header',['title'=>'Passed Classes']);
    $this->load->view('student/moblie-app',[]);
    $this->load->view('student/footer3');
  }

  public function  upcoming_classes(){
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					   =>	 site_url("Student/upcoming_classes"),
          'total_rows'					 =>	 $this->student_model->upcoming_classes_num_row(),
          'per_page'					   =>	 $perpage,
          'display_pages'				 =>	 TRUE,
          'use_page_numbers'		 =>  TRUE,
          'uri_segment'					 =>	 3,
          'num_links'					   =>	10,
          'full_tag_open'				 =>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'			 =>	"</ul>",
          'first_tag_open'			 =>	'<li>',
          'first_tag_close'			 =>	'</li>',
          'last_tag_open'				 =>	'<li>',
          'last_tag_close'			 =>	'</li>',
          'next_tag_open'				 =>	'<li>',
          'next_tag_close'			 =>	'</li>',
          'prev_tag_open'				 =>	'<li>',
          'prev_tag_close'			 =>	'</li>',
          'num_tag_open'				 =>	'<li>',
          'num_tag_close'				 =>	'</li>',
          'cur_tag_open'				 =>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				 =>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      if($_POST){
        $dateddd   =  explode("-",trim($this->input->post('dates')));
        $begin     = date("Y-m-d",strtotime($dateddd[0])) ;
        $end       =  date("Y-m-d",strtotime($dateddd[1])) ;

        $daterange = date_range($begin,$end);
        $data_taskpo=array(
              'subject'	=>strtolower(trim($this->input->post('subject'))),'date'=>$daterange,
              'order_by'	=>strtolower(trim($this->input->post('order_by'))),'seach_term'	=>strtolower(trim($this->input->post('seach_term')))
              );
        if(((isset($data_taskpo['subject'])&& !empty($data_taskpo['subject'])) 	||
        (isset($data_taskpo['date'])	&& !empty($data_taskpo['date'])))&&(
        (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	||
        (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))))
        {
          $list=$this->student_model->upcoming_classes_search($data_taskpo);
          $links='';
        }
      }else{
        $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
        $list 		                =  $this->student_model->upcoming_classes($config['per_page'],$page);
        $links		                =  $this->pagination->create_links();
      }

      $subject_array            =  $this->student_model->get_subject_array();
      $this->load->view('student/header',['title'=>'Upcoming Classes','list'=>$list,'link'=>$links]);
      $this->load->view('student/upcoming_classes',['subject'=>$subject_array]);
      $this->load->view('student/footer');
  }

  public function past_classes(){
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					   =>	 site_url("Student/past_classes"),
          'total_rows'					 =>	 $this->student_model->past_classes_num_row(),
          'per_page'					   =>	 $perpage,
          'display_pages'				 =>	 TRUE,
          'use_page_numbers'		 =>  TRUE,
          'uri_segment'					 =>	 3,
          'num_links'					   =>	10,
          'full_tag_open'				 =>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'			 =>	"</ul>",
          'first_tag_open'			 =>	'<li>',
          'first_tag_close'			 =>	'</li>',
          'last_tag_open'				 =>	'<li>',
          'last_tag_close'			 =>	'</li>',
          'next_tag_open'				 =>	'<li>',
          'next_tag_close'			 =>	'</li>',
          'prev_tag_open'				 =>	'<li>',
          'prev_tag_close'			 =>	'</li>',
          'num_tag_open'				 =>	'<li>',
          'num_tag_close'				 =>	'</li>',
          'cur_tag_open'				 =>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'				 =>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      if($_POST){
        $dateddd   =  explode("-",trim($this->input->post('dates')));
        $begin     = date("Y-m-d",strtotime($dateddd[0])) ;
        $end       =  date("Y-m-d",strtotime($dateddd[1])) ;

        $daterange = date_range($begin,$end);
        $data_taskpo=array(
              'subject'	=>strtolower(trim($this->input->post('subject'))),'date'=>$daterange,
              'order_by'	=>strtolower(trim($this->input->post('order_by'))),'seach_term'	=>strtolower(trim($this->input->post('seach_term')))
              );
        if(((isset($data_taskpo['subject'])&& !empty($data_taskpo['subject'])) 	||
        (isset($data_taskpo['date'])	&& !empty($data_taskpo['date'])))&&(
        (isset($data_taskpo['seach_term'])	&& !empty($data_taskpo['seach_term'])) 	||
        (isset($data_taskpo['order_by'])&& !empty($data_taskpo['order_by']))))
        {
          $list=$this->student_model->past_classes_search($data_taskpo);
          $links='';
        }
      }else{
        $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
        $list 		                =  $this->student_model->past_classes($config['per_page'],$page);
        $links		                =  $this->pagination->create_links();
      }

      $subject_array            =  $this->student_model->get_subject_array();
      $this->load->view('student/header',['title'=>'Past Classes','list'=>$list,'link'=>$links]);
      $this->load->view('student/past_classes',['subject'=>$subject_array]);
      $this->load->view('student/footer');
  }

  public function update_class_remarks(){
    //print_r($_POST);die;
      $class_topic               =  $this->input->post('class_topic');
      $class_description         =  $this->input->post('class_description');
      $class_id                  =  $this->input->post('class_id');
      $st_cls_id                 =  $this->input->post('st_cls_id');
      $st_cls_clid               =  $this->input->post('st_cls_clid');
      $remarks                   =  array("remarks"=>array('topic'=>strtolower($class_topic),
      'description'=>strtolower($class_description)));
      $new_remarks               =  json_encode($remarks,true);
      $this->student_model->class_remarks_update($st_cls_id,$st_cls_clid,$new_remarks);
      return redirect('Student/past-classes');

  }

  public function course_enrolled_list(){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url('Student/course_enrolled_list'),
          'total_rows'				=>	$this->student_model->course_enrolled_list_num_rows(),
          'per_page'					=>	$perpage,
          'display_pages'			=>	TRUE,
          'use_page_numbers'	=> 	TRUE,
          'uri_segment'				=>	3,
          'num_links'					=>	10,
          'full_tag_open'			=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'		=>	"</ul>",
          'first_tag_open'		=>	'<li>',
          'first_tag_close'		=>	'</li>',
          'last_tag_open'			=>	'<li>',
          'last_tag_close'		=>	'</li>',
          'next_tag_open'			=>	'<li>',
          'next_tag_close'		=>	'</li>',
          'prev_tag_open'			=>	'<li>',
          'prev_tag_close'		=>	'</li>',
          'num_tag_open'		  =>	'<li>',
          'num_tag_close'			=>	'</li>',
          'cur_tag_open'			=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'			=>	'</a></li>',
      ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
      //$list 		                =  $this->student_model->class_list($config['per_page'],$page,$search);
      $list 		                =  $this->student_model->course_enrolled_list($config['per_page'],$page);
      $links		                =  $this->pagination->create_links();

      $this->load->view('student/header',['title'=>'Course Enrolled','list'=>$list,
          'link'=>$links,'course_total'=>$this->course_total,'class_total'=>$this->class_total]);
      $this->load->view('student/course_enrolled',['category'=>$category,'subject_code'=>$subject_code]);
      $this->load->view('student/footer',['upcoming_class'=>$this->upcoming_class,]);

  }

  public function course_enrolled_detail($course_id){
      $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
      if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
      $config = [
          'base_url'					=>	site_url("Student/course_enrolled_detail/{$course_id}"),
          'total_rows'				=>	$this->student_model->course_class_list_by_courseid_num_rows($course_id),
          'per_page'					=>	$perpage,
          'display_pages'			=>	TRUE,
          'use_page_numbers'	=> 	TRUE,
          'uri_segment'				=>	4,
          'num_links'					=>	10,
          'full_tag_open'			=>	"<ul class='pagination pagination-sm no-margin'>",
          'full_tag_close'		=>	"</ul>",
          'first_tag_open'		=>	'<li>',
          'first_tag_close'		=>	'</li>',
          'last_tag_open'			=>	'<li>',
          'last_tag_close'		=>	'</li>',
          'next_tag_open'			=>	'<li>',
          'next_tag_close'		=>	'</li>',
          'prev_tag_open'			=>	'<li>',
          'prev_tag_close'		=>	'</li>',
          'num_tag_open'			=>	'<li>',
          'num_tag_close'			=>	'</li>',
          'cur_tag_open'			=>	'<li class="page-item active"><a class="page-link">',
          'cur_tag_close'			=>	'</a></li>',
          ];
      $this->pagination->initialize($config);
      $page 		                =  ($this->uri->segment(4)) ? $this->uri->segment(4) : 1;
      $list 		                =  $this->student_model->course_class_list_by_courseid($config['per_page'],$page,$course_id);
      $links		                =  $this->pagination->create_links();

      $this->load->view('student/header',['title'=>'Course Enrolled List','list'=>$list,'link'=>$links]);
      $this->load->view('student/sidebar');
      $this->load->view('student/course_enrolled_detail');
      $this->load->view('student/footer');

  }


    public function requested_course_status_list(){
        $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
        if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
        $config = [
            'base_url'					=>	site_url('Student/requested_course_status_list'),
            'total_rows'					=>	$this->student_model->v2_student_request_program_chat_num_rows(),
            'per_page'					=>	$perpage,
            'display_pages'				=>	TRUE,
            'use_page_numbers'			=> 	TRUE,
            'uri_segment'					=>	4,
            'num_links'					=>	10,
            'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
            'full_tag_close'				=>	"</ul>",
            'first_tag_open'				=>	'<li>',
            'first_tag_close'				=>	'</li>',
            'last_tag_open'				=>	'<li>',
            'last_tag_close'				=>	'</li>',
            'next_tag_open'				=>	'<li>',
            'next_tag_close'				=>	'</li>',
            'prev_tag_open'				=>	'<li>',
            'prev_tag_close'				=>	'</li>',
            'num_tag_open'				=>	'<li>',
            'num_tag_close'				=>	'</li>',
            'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
            'cur_tag_close'				=>	'</a></li>',
        ];
        $this->pagination->initialize($config);
        $page 		     =       ($this->uri->segment(4)) ? $this->uri->segment(4) : 1;
        $list 		     =       $this->student_model->v2_student_request_program_chat_list($config['per_page'],$page);
        $links		     =	     $this->pagination->create_links();
        $category      =    	 $this->student_model->getcategory();
        $subject_code  =       $this->student_model->subject_code_lists();

        $this->load->view('student/header',['title'=>'Course Listing','list'=>$list,'link'=>$links,]);
        $this->load->view('student/sidebar');
        $this->load->view('student/requested_course_status_list',['category'=>$category,'subject_code'=>$subject_code]);
        $this->load->view('student/footer');
    }
    public function request_for_course_submit(){

        $program_id       =   $this->input->post('class_id');

        $data	            =   array('user_id'=>$this->userid,'category_id'=>$this->input->post('category_id'),
            'class_id'=>$this->input->post('class_id'),'subject_id'=>$this->input->post('subject_id'),
            //'subject_code'=>strtolower($this->input->post('subject_code')),
            'month'=>date("M"),'year'=>date("Y"));
        $insert_id        =   $this->student_model->insert_v2_student_request_program($data);
        if($insert_id!=""){
            $data1	    = 	array('request_program_id'=>$insert_id,'user_message'=>$this->input->post('user_message'),
                'user_msg_date'=>date('Y-m-d'));
            $this->student_model->insert_v2_student_request_program_chat($data1);
        }
        //$this->session->set_flashdata('success', "<i class='icon fa fa-check'></i> Request For Class Create Sucessfully ! Admin will contact you soon");
      //return redirect("Student/program/request-status");
      echo "<i class='icon fa fa-check'></i> Request For Class Create Sucessfully ! Admin will contact you soon";

    }
    public function get_category_class(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_category_class($postData);
        echo json_encode($data);
    }
    public function get_class_subject(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_class_subject($postData);
        echo json_encode($data);
    }
    public function get_subject_chapter(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_subject_chapter($postData);
        echo json_encode($data);
    }
    public function get_chapter_topic(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_chapter_topic($postData);
        echo json_encode($data);
    }

    public function get_class_subject_faculty(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_class_subject_faculty($postData);
        echo json_encode($data);
    }
    public function get_class_subject_course_maded_list(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_class_subject_course_maded_list($postData);
        echo json_encode($data);
    }
    public function get_class_subject_course_classid_list(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_class_subject_course_classid_list($postData);
        echo json_encode($data);
    }
    public function get_class_subject_course_maded_info(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_class_subject_course_maded_info($postData);
        echo json_encode($data);
    }
    public function get_class_amount_info(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_class_amount_info($postData);
        echo json_encode($data);
    }
    public function get_class_amount_info_after_over_class(){
        $postData   =   $this->input->post();
        $data       =   $this->student_model->get_class_amount_info_after_over_class($postData);
        echo json_encode($data);
    }
    public function request_for_couse_chat_submit(){

        $data1	    = 	array('request_program_id'=>$this->input->post('request_program_id'),'user_message'=>$this->input->post('user_message'),
                          'user_msg_date'=>date('Y-m-d'));
        $this->student_model->insert_v2_student_request_program_chat($data1);

        $this->session->set_flashdata('success', "<i class='icon fa fa-check'></i> Request For Class Create Sucessfully ! Admin will contact you soon");
        return redirect("Student/program/request-status");

    }

      public function request_class_chat_history($request_program_id){
         $data 		      = 	$this->student_model->chat_list_subject_($this->userid,$request_program_id);
         $category      =   strtoupper($data[0]->category);
         $class         =   strtoupper($data[0]->class);
         $subject       =   strtoupper($data[0]->subject);
         $subject_code  =   strtoupper($data[0]->subject_code);
         $month         =   strtoupper($data[0]->month);
         $year          =   strtoupper($data[0]->year);

        // echo "<pre>";print_r($data);die;
         // $data2						=		json_decode($data->remarks,true);
          $html	= "<button type='button' class='close close_student' data-dismiss='modal' aria-label='Close' onclick='close_students()'>
                        <span aria-hidden='true' class='fadeandscale_close fand-clase'><img src='https://theonlinegurukul.com/assets/web/images/close-pop.png' alt='close-pop.png'>
						</span>
                    </button>
					<h2>Chat History |     {$category} | {$class} | {$subject} | {$subject_code} | {$month} | {$year}</h2>
    						<table id='example2' class='table table-bordered table-hover  table-responsive' style='font-family: sans-serif;font-size: 12px;'>
    							<thead>
    								<tr style='background-color: #428bca99 !important;color: #fff !important;'>
    									<th>Query</th>
    									<th>Query Date</th>
    									<th>Admin Reply</th>
    									<th>Reply date</th>
    								</tr>
    							</thead>
    							<tbody style='height:50px;'>";
          foreach($data as $data1){
              $date1    =   date("d-M-Y",strtotime($data1->user_msg_date));
              if($data1->admin_reply_date!=""){$date2    =   date("d-M-Y",strtotime($data1->admin_reply_date));}
              $html.="
    							<tr>
    								<td>{$data1->user_message}</td>
    								<td>{$date1}</td>
    								<td>{$data1->admin_reply}</td>
    								<td>{$date2}</td>
    							</tr>
                  ";
          }
          $html	.= "		</tbody>
    						</table>
    					";

          echo $html;
      }
      public function program_offered(){

          $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
          if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
          $config = [
              'base_url'					=>	site_url('Student/program_offered'),
              'total_rows'					=>	$this->student_model->program_offered_list_num_rows(),
              'per_page'					=>	$perpage,
              'display_pages'				=>	TRUE,
              'use_page_numbers'			=> 	TRUE,
              'uri_segment'					=>	3,
              'num_links'					=>	10,
              'full_tag_open'				=>	"<ul class='pagination pagination-sm no-margin'>",
              'full_tag_close'				=>	"</ul>",
              'first_tag_open'				=>	'<li>',
              'first_tag_close'				=>	'</li>',
              'last_tag_open'				=>	'<li>',
              'last_tag_close'				=>	'</li>',
              'next_tag_open'				=>	'<li>',
              'next_tag_close'				=>	'</li>',
              'prev_tag_open'				=>	'<li>',
              'prev_tag_close'				=>	'</li>',
              'num_tag_open'				=>	'<li>',
              'num_tag_close'				=>	'</li>',
              'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
              'cur_tag_close'				=>	'</a></li>',
          ];
          $this->pagination->initialize($config);
          $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
          $list 		                =  $this->student_model->program_offered_list($config['per_page'],$page,$search);
          $links		                =  $this->pagination->create_links();
          $category                     =  $this->student_model->getcategory();
          //echo "pre"; print_r($category);

          $this->load->view('student/header',['title'=>'Program Offered','list'=>$list,'link'=>$links]);
          $this->load->view('student/sidebar');
          $this->load->view('student/program_offered',['category'=>$category]);
          $this->load->view('student/footer');
      }

        public function program_offered_subject_list_byid($program_id){

            $list 		                  = 	$this->student_model->program_offered_subject_list_byid($program_id);
            $num_row                    =   $this->student_model->program_offered_subject_list_num_rows($program_id);

            $category                   =   $this->student_model->getcategory();
            $subject_code               =   $this->student_model->subject_code_lists();
            $main_cat                   =   $list[0]->category;
            $main_class                 =   $list[0]->class;

            $html	= "<button type='button' class='close close_student' data-dismiss='modal' aria-label='Close' onclick='close_students()'>
                        <span aria-hidden='true' class='fadeandscale_close fand-clase'><img src='https://theonlinegurukul.com/assets/web/images/close-pop.png' alt='close-pop.png'>
						</span>
                    </button>
			<h2>Subject List | {$main_cat} | {$main_class}
            <!--<button type='button' class='close-change close' aria-hidden='true'>
                   <img src='https://theonlinegurukul.com/assets/web/images/close-pop.png' alt='close-pop.png' onclick='hide()'>
            </button>-->
            </h2>
			

                  <table id='example2' class='table table-bordered table-hover  table-responsive' style='font-family: sans-serif;font-size: 12px;'>
                    <thead>
                      <tr style='background-color: #428bca99 !important;color: #fff !important;'>
                        <th>#</th>
                        <th>Program</th>
                        <th>Class</th>
                        <th>Subject</th>
                        <th>Subject Code</th>
                      </tr>
                    </thead>
                    <tbody style='height:50px;'>";
                    $i=1;
                    foreach($list as $lists){
                      $category     = strtoupper($lists->category);
                      $class        = strtoupper($lists->class);
                      $subject      = strtoupper($lists->subject);
                      $subject_code = strtoupper($lists->category_code.$lists->class_code.$lists->subject_code);
                        $html.="
                            <tr>
                              <td>{$i}</td>
                              <td>{$category}</td>
                              <td>{$class}</td>
                              <td>{$subject}</td>
                              <td>{$subject_code}</td>
                            </tr>
                            ";
                            $i++;
                    }
                    $html	.= "		</tbody>
                    </table>
                    ";

            echo $html;

        }
        public function account(){
            $this->form_validation->set_rules('perpage_search', 'ALL', 'required');
            if($this->input->post('perpage')==""){$perpage=15;}		else{$perpage		=	$this->input->post('perpage');}
            $config = [
                'base_url'					   =>	site_url('Student/account'),
                'total_rows'					 =>	$this->student_model->account_wallet_num_rows(),
                'per_page'					   =>	$perpage,
                'display_pages'				 =>	TRUE,
                'use_page_numbers'		 => TRUE,
                'uri_segment'					 =>	3,
                'num_links'					   =>	10,
                'full_tag_open'				 =>	"<ul class='pagination pagination-sm no-margin'>",
                'full_tag_close'			 =>	"</ul>",
                'first_tag_open'				=>	'<li>',
                'first_tag_close'				=>	'</li>',
                'last_tag_open'				=>	'<li>',
                'last_tag_close'				=>	'</li>',
                'next_tag_open'				=>	'<li>',
                'next_tag_close'				=>	'</li>',
                'prev_tag_open'				=>	'<li>',
                'prev_tag_close'				=>	'</li>',
                'num_tag_open'				=>	'<li>',
                'num_tag_close'				=>	'</li>',
                'cur_tag_open'				=>	'<li class="page-item active"><a class="page-link">',
                'cur_tag_close'				=>	'</a></li>',
            ];
            $this->pagination->initialize($config);
            $page 		                =  ($this->uri->segment(3)) ? $this->uri->segment(3) : 1;
            $list 		                =  $this->student_model->account_wallet($config['per_page'],$page);
            $links		                =  $this->pagination->create_links();

            //echo "pre"; print_r($category);

            $this->load->view('student/header',['title'=>'Current ballance Rs '.$list[0]->wallet_amount,'list'=>$list,'link'=>$links]);
            //$this->load->view('student/sidebar');
            $this->load->view('student/account_status');
            $this->load->view('student/footer');
        }

        	public function complete_profile(){
          	$this->load->view('student/header_profile',['title'=>'Add Student']);
            $this->load->view('student/sidebar');
          	$this->form_validation->set_error_delimiters('<br><span style="color:red;">', '</span>');
            $this->form_validation->set_rules('first_name','First Name', 			'required|xss_clean');
            $this->form_validation->set_rules('last_name','Last Name', 'required|xss_clean');
            $this->form_validation->set_rules('mobile','Mobile','required|xss_clean|max_length[20]|trim');
            $this->form_validation->set_rules('dob','Date of Birth','required|xss_clean|trim');
            $this->form_validation->set_rules('gender','Gender', 'required|xss_clean');
            $this->form_validation->set_rules('country_id','Country','required|xss_clean');
            $this->form_validation->set_rules('state_id','State','required|xss_clean');
            $this->form_validation->set_rules('city_id','City','required|xss_clean');
            $this->form_validation->set_rules('pin_code','Pin Code','required|xss_clean|numeric');
            $this->form_validation->set_rules('parent_fname','Parent First Name','required|xss_clean');
            $this->form_validation->set_rules('parent_lname', 'Parent Last Name','required|xss_clean');
            $this->form_validation->set_rules('parent_email','Parent Email Address', 'required|xss_clean|valid_email');
            $this->form_validation->set_rules('parent_mobile','Parent Mobile','required|xss_clean|max_length[20]|trim');
            $this->form_validation->set_rules('school_name','School Name', 'required|xss_clean');
            $this->form_validation->set_rules('school_address','School Address','required|xss_clean|trim|max_length[255]');
            $this->form_validation->set_rules('address','Address','required|xss_clean');
            //$this->form_validation->set_rules('current_class','Current Class','required|xss_clean');
            $country_list      =  $this->common_model->country_list();
            $list              =  $this->student_model->student_info($this->userid);
        		if($this->form_validation->run()==false){
              $this->session->set_flashdata('danger',"<i class='icn glyphicon glyphicon-remove'></i>Profile Not Completed");
        			$this->load->view('student/student_edit',['country'=>$country_list,'list'=>$list]);
        		}
        		else{
        		//echo "<pre>";print_r($_POST);die;
        			$primary_detail 			   =  array(
              'first_name'=>strtolower($this->input->post('first_name')),
              'last_name'=>strtolower($this->input->post('last_name')),
              'gender'=>strtolower($this->input->post('gender')),
        			'mobile'=>strtolower($this->input->post('mobile'))	);
              $secondary = array(
                'school_name'=>strtolower($this->input->post('school_name')),
                "school_address"=>strtolower($this->input->post('school_address')),
                "parent_fname"=>strtolower($this->input->post('parent_fname')),
                "parent_lname"=>strtolower($this->input->post('parent_lname')),
                "parent_email"=>strtolower($this->input->post('parent_email')),
                "parent_mobile"=>strtolower($this->input->post('parent_mobile')),
                "current_class"=>strtolower($this->input->post('current_class')),
                "dob"=>strtolower(date("d-m-Y",strtotime($this->input->post('dob')))),
                "country"=>strtolower($this->input->post('country_id')),
                "state"=>strtolower($this->input->post('state_id')),
                "city"=>strtolower($this->input->post('city_id')),
                'address'=>strtolower($this->input->post('address')),
          			'pin_code'=>strtolower($this->input->post('pin_code'))
              );
            $this->student_model->update_master_user($this->userid,$primary_detail);
            $count  =  $this->student_model->find_duplicate_student_info($this->userid);
            //echo $count;die;
            if($count==0){
                $this->student_model->insert_extra_info(array(
                  'user_id'=>$this->userid,
                  'school_name'=>strtolower($this->input->post('school_name')),
                  "school_address"=>strtolower($this->input->post('school_address')),
                  "parent_fname"=>strtolower($this->input->post('parent_fname')),
                  "parent_lname"=>strtolower($this->input->post('parent_lname')),
                  "parent_email"=>strtolower($this->input->post('parent_email')),
                  "parent_mobile"=>strtolower($this->input->post('parent_mobile')),
                  "current_class"=>strtolower($this->input->post('current_class')),
                  "dob"=>strtolower(date("d-m-Y",strtotime($this->input->post('dob')))),
                  "country"=>strtolower($this->input->post('country_id')),
                  "state"=>strtolower($this->input->post('state_id')),
                  "city"=>strtolower($this->input->post('city_id')),
                  'address'=>strtolower($this->input->post('address')),
            			'pin_code'=>strtolower($this->input->post('pin_code'))
                ));
            }else{
                $this->student_model->update_extra_info($this->userid,$secondary);
            }
        			$this->session->set_flashdata('success', "<i class='fa-check-circle'></i>  Profile Completed Successfully");
        			return redirect("student/profile");
        			//return redirect("master/Activity/edit/$insert_id");
        		}
            $this->load->view('student/footer3');
        	}

          public function upload_profile(){

            $this->load->view("student/header_profile",[]);
            $this->load->view("student/sidebar");
            $country1          =  $this->common_model->getCountry();
            $data              =  array();
            if($this->input->post('fileSubmit') && !empty($_FILES['userFiles']['name'])){
              $filesCount = count($_FILES['userFiles']['name']);
              //echo $_FILES['userFiles']['name'];echo $filesCount;die;
              for($i = 0; $i < $filesCount; $i++){
                $_FILES['userFile']['name'] 	   = 	$_FILES['userFiles']['name'][$i];
                $_FILES['userFile']['type'] 	   = 	$_FILES['userFiles']['type'][$i];
                $_FILES['userFile']['tmp_name']  = 	$_FILES['userFiles']['tmp_name'][$i];
                $_FILES['userFile']['error'] 	   = 	$_FILES['userFiles']['error'][$i];
                $_FILES['userFile']['size'] 	   = 	$_FILES['userFiles']['size'][$i];
                $uploadPath 					           = 	"./uploads/user/images/$this->userid/profile/";
                if(!is_dir($uploadPath )){mkdir($uploadPath, 0777, TRUE );}
                $config['upload_path'] 			     = 	$uploadPath;
                $config['allowed_types'] 		     = 	'jpg|png|gif|jpeg|JPG|PNG|GIF';
                $config['overwrite'] 			       = 	'1';
                //$config['max_size']	           =  '100';
                //$config['max_width']           =  '1024';
                //$config['max_height']          =  '768';
                $this->load->library('upload', $config);
                $this->upload->initialize($config);
                if($this->upload->do_upload('userFile')){
                  $fileData = $this->upload->data();
                  $config1['image_library']      =   'gd2';
                  $config1['source_image']       =   $fileData['full_path'];
                  $config1['create_thumb']       =   TRUE;
                  $config1['maintain_ratio']     =   TRUE;
                  $config1['width']              =   62;
                  $config1['height']             =   58;
                  $this->load->library('image_lib', $config1);
                  if (!$this->image_lib->resize()) {
                      $this->handle_error($this->image_lib->display_errors());
                  }
                  $this->student_model->update_profile_pic($this->userid,$config['upload_path'].$fileData['file_name']);
                  //print_r($fileData);die;//  $this->student_model->update_profile_pic($id,$path);
                }
              }
                 $this->session->set_flashdata('success', 'Profile Added Succesfully');
                 return redirect("Student/upload_profile");
            }
            else{
                    $data['error'] = "Error occured";
                    $this->load->view('student/upload_profile', $data);
              }
               // $this->load->view('student/upload_profile', $data);
                 $this->load->view("student/footer3");
          }
          public function profile(){
              $country1        =  $this->common_model->getCountry();
              $list            =  $this->student_model->student_info($this->userid);
              $this->load->view('student/header_profile',['title'=>'View Profile']);
              $this->load->view('student/sidebar');
              $this->load->view('student/profile',['list'=>$list]);
              $this->load->view('student/footer3');
        	}




}
