<?php defined('BASEPATH') or exit (' No direct Access is Allowed');?>

<?php

class Cron extends CI_Controller{

    public function __construct(){
        parent::__construct();
        $this->load->library(['form_validation','bcrypt','email','session','pagination']);
        $this->load->helper(['html','form','url','security','string','file','directory']);
        $this->load->model('CommonModel','common_model');
        $this->load->model('StudentModel','student_model');
		$this->load->model('TeacherModel','teacher_model');
    }
    function check_user() {

        $email 			= 	strtolower(trim($this->input->post('email')));// get fiest name
        $category 		= 	"2";
        $query			=	$this->db->select('email')->from('master_user')->where('email', $email)
        ->where('category', $category)->get();
        $num 			= 	$query->num_rows();
        $query2			=	$this->db->select('category')->from('user_category')->where('id', $category)->get();
        $query2			=	$query2->row();
        $category_name	=	strtoupper($query2->category);
        if ($num > 0) {
            //$this->form_validation->set_message('check_user',"The {field} field you are already registerd with us as{$category_name} => {$email}");
            $this->form_validation->set_message('check_user',"This email already registered with us as a Student");
            return FALSE;
        }
        else {
            return TRUE;
        }
    }
    function check_teacher() {

        $email 			= 	strtolower(trim($this->input->post('email')));// get fiest name

        $query			=	$this->db->select('email')->from('master_user')->where('email', $email)
        ->where('category', '1')->get();
        $num 			= 	$query->num_rows();
        $query2			=	$this->db->select('category')->from('user_category')->where('id', $category)->get();
        $query2			=	$query2->row();
        $category_name	=	strtoupper($query2->category);
        if ($num > 0) {
            //$this->form_validation->set_message('check_teacher',"The {field} field you are already registerd with us as{$category_name} => {$email}");
            $this->form_validation->set_message('check_teacher',"This email already registered with us as a Teacher");
            return FALSE;
        }
        else {
            return TRUE;
        }
    }
    function check_teacher2() {

        $email 			= 	strtolower(trim($this->input->post('email')));// get fiest name

        $query			=	$this->db->select('email')->from('master_user')->where('email', $email)
        ->where('category', '1')->get();
        $num 			= 	$query->num_rows();

        if ($num > 0) {
            echo "Email already exist as teacher profile";
            //echo "<script>alert('User Name Already Exist');</script>";
        }
        else {
            //echo "<script>alert('OK');</script>";
            //echo "OK";
        }
        exit();
    }
    public function teacher_signup(){

      $this->form_validation->set_rules('first_name','First Name','required|trim|xss_clean|max_length[15]');
      $this->form_validation->set_rules('last_name','Last Name','required|trim|xss_clean|max_length[15]');
      $this->form_validation->set_rules('email','Email Address','required|trim|xss_clean|callback_check_teacher');
      $this->form_validation->set_rules('mobile','Mobile no','required|trim|xss_clean|numeric|exact_length[10]');
      $this->form_validation->set_rules('password','Password','required|trim|xss_clean|max_length[15]|min_length[8]');
      $this->form_validation->set_rules('confirm_password','Confirm Password','required|trim|xss_clean|max_length[15]|min_length[8]|matches[password]');
      $this->form_validation->set_rules('gender','Gender','required|trim|xss_clean');
      $this->form_validation->set_rules('zipcode','Zip Code','required|trim|xss_clean');

        if($this->form_validation->run()){

            $first_name                             =		strtolower($this->input->post('first_name'));
            $last_name		                          =		strtolower($this->input->post('last_name'));
            $gender		                              =		strtolower($this->input->post('gender'));
            $email		                              =		strtolower($this->input->post('email'));
            $mobile		                              =		strtolower($this->input->post('mobile'));
            $password			                          =		strtolower($this->input->post('password'));
            // $last_name		                        =		strtolower($this->input->post('conf_password'));
            $zip_code			                          =		strtolower($this->input->post('zip_code'));
            $hash 			                            =   $this->bcrypt->hash_password($password);
            $hashtag		                            =		random_string('alnum', 16);
            $data			                              =		array('first_name'=> strtolower($first_name),'last_name'=> strtolower($last_name),
                'mobile'=>strtolower($mobile),'email'=>strtolower($email),'password'=>$hash,'category'=>'1','hashtag'=>$hashtag,
                'gender'=>$gender
            );
            $insert_id	                            =		$this->common_model->insert_masteruser($data);


            if($insert_id!==""){
                $config['mailtype']     = 'html';
                $this->email->initialize($config);
                $this->email->from('helpdesk@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
                //$this->email->to(['narender.rathore@deconglobalsolutions.com','narender.rathore@theonlinegurukul.com']);
                $this->email->to($email);
                $this->email->subject('Email Account Verification - TOG  Teacher');
                $salthash		    =		random_string('alnum', 9);
                $link1          =   base_url("assets/web/images/bg-email.png");
                $link2          =   base_url("assets/web/images/bg-footer.png");

                $htmlContent = '
                   <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
                    <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                      <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                      <meta name="viewport" content="width=device-width, initial-scale=1" />
                      <title>TOG ACCOUNT ACTIVATION LINK</title>
                      <style type="text/css" media="screen">

                        /* Force Hotmail to display emails at full width */
                        .ExternalClass {
                          display: block !important;
                          width: 100%;
                        }

                        /* Force Hotmail to display normal line spacing */
                        .ExternalClass,
                        .ExternalClass p,
                        .ExternalClass span,
                        .ExternalClass font,
                        .ExternalClass td,
                        .ExternalClass div {
                          line-height: 100%;
                        }

                        body,
                        p,
                        h1,
                        h2,
                        h3,
                        h4,
                        h5,
                        h6 {
                          margin: 0;
                          padding: 0;
                        }

                        body,
                        p,
                        td {
                          font-family: Arial, Helvetica, sans-serif;
                          font-size: 15px;
                          color: #333333;
                          line-height: 1.5em;
                        }

                        h1 {
                            text-align: center;
                        font-size: 20px;
                        font-weight: bold;
                        line-height: 24px;
                        }

                        body,
                        p {
                          margin-bottom: 0;
                          -webkit-text-size-adjust: none;
                          -ms-text-size-adjust: none;
                        }

                        img {
                          outline: none;
                          text-decoration: none;
                          -ms-interpolation-mode: bicubic;
                        }

                        a img {
                          border: none;
                        }

                        .background {
                                    background-color: #eeeeee;
                    }


                        table.background {
                          margin: 0;
                          padding: 0;
                          width: 100% !important;
                        }

                        .block-img {
                          display: block;
                          line-height: 0;
                        }

                        a {
                          color: white;
                          text-decoration: none;
                        }

                        a,
                        a:link {
                          color: #2A5DB0;
                          text-decoration: underline;
                        }

                        table td {
                          border-collapse: collapse;
                        }

                        td {
                          vertical-align: top;
                          text-align: left;
                        }

                        .wrap {
                          margin-top: 0px;
                          width: 600px;
                        }

                        .wrap-cell {
                          padding-top: 30px;
                          padding-bottom: 30px;
                        }

                        .header-cell,
                        .body-cell,
                        .footer-cell {
                          padding-left: 20px;
                          padding-right: 20px;
                        }

                        .header-cell {


                          color: #ffffff;
                        }

                        .body-cell {
                          background-color: #ffffff;
                          padding-top:16px;
                          padding-bottom: 34px;
                        }

                        .footer-cell {

                          text-align: center;
                          font-size: 13px;
                          padding-top:13px;
                          padding-bottom: 30px;
                        }

                        .card {
                          width: 400px;
                          margin: 0 auto;
                        }

                        .data-heading {
                          text-align: right;
                          padding: 10px;
                          background-color: #ffffff;
                          font-weight: bold;
                        }

                        .data-value {
                          text-align: left;
                          padding: 10px;
                          background-color: #ffffff;
                        }

                        .force-full-width {
                          width: 100% !important;
                        }

                      </style>
                      <style type="text/css" media="only screen and (max-width: 600px)">
                        @media only screen and (max-width: 600px) {
                          body[class*="background"],
                          table[class*="background"],
                          td[class*="background"] {
                            background: #eeeeee !important;
                          }

                          table[class="card"] {
                            width: auto !important;
                          }

                          td[class="data-heading"],
                          td[class="data-value"] {
                            display: block !important;
                          }

                          td[class="data-heading"] {
                            text-align: left !important;
                            padding: 10px 10px 0;
                          }

                          table[class="wrap"] {
                            width: 100% !important;
                          }

                          td[class="wrap-cell"] {
                            padding-top: 0 !important;
                            padding-bottom: 0 !important;
                          }
                        }


                      </style>
                    </head>

            <body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" bgcolor="" class="background">
              <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="background">
                <tr>
                  <td align="center" valign="top" width="100%" class="background">
                    <center>
                      <table cellpadding="0" cellspacing="0" width="600" class="wrap">
                        <tr>
                          <td valign="top" class="wrap-cell" style="padding-top:30px; padding-bottom:30px;">
                            <table cellpadding="0" cellspacing="0" class="force-full-width">
                     <tr>
                                <td height="8" bgcolor="#ededed" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                              </tr>
                              <tr>
                               <td height="65" valign="top" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">
                               <a href="http://theonlinegurukul.com" target="_blank">
                               <img src="'.base_url("assets/web/images/20.png").'" width="150"  alt="" style="border-width:0; max-width:100px; display:block" /></a>
                               </td>
                               </tr>
                               <tr>
                               <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"><!--  border-top-left-radius:10px; --> <!-- border-top-right-radius:10px" --></td>
                                                      </tr>

                              <tr>
                                <td valign="top" class="body-cell">

                                  <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#ffffff">
                                  <tr>
                                  <td valign="top" style="padding-bottom:15px; background-color:#ffffff;">
                                  <h1>User Email Address verification link</h1>
                                  </td>
                                  </tr>
                                  <tr>
                                  <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
                                  <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">
                                  Your TOG Account activation link is as follows. Please click the link
                            below to Activation of your Account.<br>
                                  </p>
                                  <center>    <a href="'.site_url("user/email/verify/").$hashtag.$insert_id.$salthash.'"
                                  style="background-color:#ffa500;color:#ffffff;display:inline-block;font-family:sans-serif;font-size: 16px;line-height:37px;text-align:center;text-decoration:none;width:165px;-webkit-text-size-adjust:none;">Verify your Account</a>
                                  </center>
                                  <br>
                                  <p style="color:#5b5f65; font-size:14px; text-align:justify;font-family: Verdana, Geneva, sans-serif">

                                  Thank you for your patience. Please contact us for any inconvenience caused to you.<br>


                                  </p>
                                  </td>
                                  </tr>
                                  <tr>
                                  <td>
                                  <table cellspacing="0" cellpadding="0" width="100%" bgcolor="#ffffff">
                                  <tr>
                                  <td style="width:200px;background:#008000;">
                                  <div><!--[if mso]>
                                  <v:rect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:40px;v-text-anchor:middle;width:200px;" stroke="f" fillcolor="#008000">
                                  <w:anchorlock/>
                                  <center>
                                  <![endif]-->


                                  <!--[if mso]>
                                  </center>
                                  </v:rect>
                                  <![endif]--></div>
                                  </td>
                                  <td width="360" style="background-color:#ffffff; font-size:0; line-height:0;">&nbsp;</td>
                                  </tr>
                                  </table>
                                  </td>
                                  </tr>
                                  <tr>
                                  <td style="padding-top:20px;background-color:#ffffff;">
                                  <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">

                                  Regards.<br>
                                  The Online Gurukul
                                  </p>
                                  </td>
                                  </tr>
                                  </table>
                                  </td>
                                  </tr>
                                  <tr>
                                  <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                                  </tr>

                                  <tr>
                                   <td height="65" align="center" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">

                                  <center><span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Email :</span>
                                  <a class="txs" href="mailto:helpdesk@theonlinegurukul.com" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank">helpdesk@theonlinegurukul.com </a>
                                  <br>
                                  <span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Phone :-</span>
                                  <a class="txs" href="tel:+91-0124-4272441" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank"> 91-0124-4272441</a>
                                  </center>
                                  </td>
                                  <tr>

                                  </tr>



                                  </table>
                                  </td>
                                  </tr>
                                  </table>
                                  </center>
                                  </td>
                                  </tr>
                                  </table>

                                  </body>
                                  </html>

        ';

                $this->email->message($htmlContent);
                if ($this->email->send()) {
                    echo "Email verification mail sent to your account,Please verify";
                }
                else{
                    echo "Error in sending Verification Email,please contact Admin to verify your Email Address";
                }
            }
        }else{
            echo "Email already registerd or email is not proper";
     }
	}

    public function student_signup(){

        $this->load->library('email');

        $this->form_validation->set_rules('first_name','First Name','required|trim|xss_clean|max_length[15]');
        $this->form_validation->set_rules('last_name','Last Name','required|trim|xss_clean|max_length[15]');
        $this->form_validation->set_rules('mobile','Mobile no','required|trim|xss_clean|numeric|exact_length[10]');
        $this->form_validation->set_rules('email','Email','required|trim|valid_email|xss_clean|callback_check_user');
        $this->form_validation->set_rules('password','Password','required|trim|xss_clean|max_length[15]|min_length[8]');
        $this->form_validation->set_rules('confirm_password','Confirm Password','required|trim|xss_clean|max_length[15]|min_length[8]|matches[password]');
        $this->form_validation->set_rules('gender','Gender','required|trim|xss_clean');
        $this->form_validation->set_rules('zipcode','Zip Code','required|trim|xss_clean');
        $category			=		$this->common_model->category_list();
        if($this->form_validation->run()){
            $email			=		$this->input->post('email');
            $password		=		$this->input->post('password');
            $first_name		=		$this->input->post('first_name');
            $last_name		=		$this->input->post('last_name');
            $mobile			=		$this->input->post('mobile');
            $gender			=		$this->input->post('gender');
            $zipcode	    =		$this->input->post('zipcode');
            $hash 			= 		$this->bcrypt->hash_password($password);
            $hashtag		=		random_string('alnum', 16);

            $response 	    = 	    array("profile"=>array(
                'gender'=>$gender,
                'zipcode'=>$zipcode
                ));
            $remarks        =   json_encode($response);

            $data			=		array('first_name'=> strtolower($first_name),'last_name'=> strtolower($last_name),
                'mobile'=>strtolower($mobile),'email'=>strtolower($email),'password'=>$hash,
                'category'=>'2','hashtag'=>$hashtag,'info'=>"$remarks");
            $insert_id	    =		$this->common_model->insert_masteruser($data);
            if($insert_id!=""){

                $config['mailtype']     = 'html';
                $this->email->initialize($config);
                $this->email->from('helpdesk@theonlinegurukul.com', 'theOnlineGurukul Pvt. Ltd.');
                //$this->email->to(['narender.rathore@deconglobalsolutions.com','narender.rathore@theonlinegurukul.com']);
                $this->email->to($email);
                $this->email->subject('Email Account Verification - TOG  Admin');
                $salthash		=		random_string('alnum', 9);
                $link1          =  base_url("assets/web/images/bg-email.png");
                $link2          =  base_url("assets/web/images/bg-footer.png");

                $htmlContent = '
                   <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>TOG ACCOUNT ACTIVATION LINK</title>
  <style type="text/css" media="screen">

    /* Force Hotmail to display emails at full width */
    .ExternalClass {
      display: block !important;
      width: 100%;
    }

    /* Force Hotmail to display normal line spacing */
    .ExternalClass,
    .ExternalClass p,
    .ExternalClass span,
    .ExternalClass font,
    .ExternalClass td,
    .ExternalClass div {
      line-height: 100%;
    }

    body,
    p,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
      margin: 0;
      padding: 0;
    }

    body,
    p,
    td {
      font-family: Arial, Helvetica, sans-serif;
      font-size: 15px;
      color: #333333;
      line-height: 1.5em;
    }

    h1 {
        text-align: center;
    font-size: 20px;
    font-weight: bold;
    line-height: 24px;
    }

    body,
    p {
      margin-bottom: 0;
      -webkit-text-size-adjust: none;
      -ms-text-size-adjust: none;
    }

    img {
      outline: none;
      text-decoration: none;
      -ms-interpolation-mode: bicubic;
    }

    a img {
      border: none;
    }

    .background {
                background-color: #eeeeee;
}


    table.background {
      margin: 0;
      padding: 0;
      width: 100% !important;
    }

    .block-img {
      display: block;
      line-height: 0;
    }

    a {
      color: white;
      text-decoration: none;
    }

    a,
    a:link {
      color: #2A5DB0;
      text-decoration: underline;
    }

    table td {
      border-collapse: collapse;
    }

    td {
      vertical-align: top;
      text-align: left;
    }

    .wrap {
      margin-top: 0px;
      width: 600px;
    }

    .wrap-cell {
      padding-top: 30px;
      padding-bottom: 30px;
    }

    .header-cell,
    .body-cell,
    .footer-cell {
      padding-left: 20px;
      padding-right: 20px;
    }

    .header-cell {


      color: #ffffff;
    }

    .body-cell {
      background-color: #ffffff;
      padding-top:16px;
      padding-bottom: 34px;
    }

    .footer-cell {

      text-align: center;
      font-size: 13px;
      padding-top:13px;
      padding-bottom: 30px;
    }

    .card {
      width: 400px;
      margin: 0 auto;
    }

    .data-heading {
      text-align: right;
      padding: 10px;
      background-color: #ffffff;
      font-weight: bold;
    }

    .data-value {
      text-align: left;
      padding: 10px;
      background-color: #ffffff;
    }

    .force-full-width {
      width: 100% !important;
    }

  </style>
  <style type="text/css" media="only screen and (max-width: 600px)">
    @media only screen and (max-width: 600px) {
      body[class*="background"],
      table[class*="background"],
      td[class*="background"] {
        background: #eeeeee !important;
      }

      table[class="card"] {
        width: auto !important;
      }

      td[class="data-heading"],
      td[class="data-value"] {
        display: block !important;
      }

      td[class="data-heading"] {
        text-align: left !important;
        padding: 10px 10px 0;
      }

      table[class="wrap"] {
        width: 100% !important;
      }

      td[class="wrap-cell"] {
        padding-top: 0 !important;
        padding-bottom: 0 !important;
      }
    }


  </style>
</head>

<body leftmargin="0" marginwidth="0" topmargin="0" marginheight="0" offset="0" bgcolor="" class="background">
  <table align="center" border="0" cellpadding="0" cellspacing="0" height="100%" width="100%" class="background">
    <tr>
      <td align="center" valign="top" width="100%" class="background">
        <center>
          <table cellpadding="0" cellspacing="0" width="600" class="wrap">
            <tr>
              <td valign="top" class="wrap-cell" style="padding-top:30px; padding-bottom:30px;">
                <table cellpadding="0" cellspacing="0" class="force-full-width">
         <tr>
                    <td height="8" bgcolor="#ededed" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                  </tr>
                  <tr>
                   <td height="65" valign="top" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">
                   <a href="http://theonlinegurukul.com" target="_blank">
                   <img src="'.base_url("assets/web/images/20.png").'" width="150"  alt="" style="border-width:0; max-width:100px; display:block" /></a>
                   </td>
                   </tr>
                   <tr>
                   <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"><!--  border-top-left-radius:10px; --> <!-- border-top-right-radius:10px" --></td>
                                          </tr>

                  <tr>
                    <td valign="top" class="body-cell">

                      <table cellpadding="0" cellspacing="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td valign="top" style="padding-bottom:15px; background-color:#ffffff;">
                      <h1>User Email Address verification link</h1>
                      </td>
                      </tr>
                      <tr>
                      <td valign="top" style="padding-bottom:20px; background-color:#ffffff;">
                      <p style="color:#5b5f65; font-size:14px; text-align:justify; font-family: Verdana, Geneva, sans-serif">
                      Your TOG Account activation link is as follows. Please click the link
                below to Activation of your Account.<br>
                      </p>
                      <center>    <a href="'.site_url("user/email/verify/").$hashtag.$insert_id.$salthash.'"
                      style="background-color:#ffa500;color:#ffffff;display:inline-block;font-family:sans-serif;font-size: 16px;line-height:37px;text-align:center;text-decoration:none;width:165px;-webkit-text-size-adjust:none;">Verify your Account</a>
                      </center>
                      <br>
                      <p style="color:#5b5f65; font-size:14px; text-align:justify;font-family: Verdana, Geneva, sans-serif">

                      Thank you for your patience. Please contact us for any inconvenience caused to you.<br>


                      </p>
                      </td>
                      </tr>
                      <tr>
                      <td>
                      <table cellspacing="0" cellpadding="0" width="100%" bgcolor="#ffffff">
                      <tr>
                      <td style="width:200px;background:#008000;">
                      <div><!--[if mso]>
                      <v:rect xmlns:v="urn:schemas-microsoft-com:vml" xmlns:w="urn:schemas-microsoft-com:office:word" href="#" style="height:40px;v-text-anchor:middle;width:200px;" stroke="f" fillcolor="#008000">
                      <w:anchorlock/>
                      <center>
                      <![endif]-->


                      <!--[if mso]>
                      </center>
                      </v:rect>
                      <![endif]--></div>
                      </td>
                      <td width="360" style="background-color:#ffffff; font-size:0; line-height:0;">&nbsp;</td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td style="padding-top:20px;background-color:#ffffff;">
                      <p style="color:black;  font-family: Comic Sans MS, Textile, cursive; font-weight: bold;">

                      Regards.<br>
                      The Online Gurukul
                      </p>
                      </td>
                      </tr>
                      </table>
                      </td>
                      </tr>
                      <tr>
                      <td height="4" bgcolor="#ffa50070" class="contents" style="width:100%; border-top-left-radius:0px; border-top-right-radius:0px"></td>
                      </tr>

                      <tr>
                       <td height="65" align="center" class="header-cell" style="padding-top:7px; padding-bottom:7px; background-image:url('.$link1.')">

                      <center><span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Email :</span>
                      <a class="txs" href="mailto:helpdesk@theonlinegurukul.com" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank">helpdesk@theonlinegurukul.com </a>
                      <br>
                      <span class="email-cos" style="font-size: 14px; color: #ffa500; font-weight: bolder;">Phone :-</span>
                      <a class="txs" href="tel:+91-0124-4272441" style="color:#000;  font-size:17px;text-decoration:none;" target="_blank"> 91-0124-4272441</a>
                      </center>
                      </td>
                      <tr>

                      </tr>



                      </table>
                      </td>
                      </tr>
                      </table>
                      </center>
                      </td>
                      </tr>
                      </table>

                      </body>
                      </html>

        ';

                $this->email->message($htmlContent);

                if ($this->email->send()) {
                    echo " Email verification mail sent to your account,Please verify  ";

                }
                else{
                    //show_error($this->email->print_debugger());
                  echo " Error in sending Verification Email,please contact Admin to verify your Email Address";

                }
            }

        }
        else{
              echo "Email already registerd or email is not proper";
        }

    }


    public function student_login(){

        $this->form_validation->set_rules('email','Email','required|trim|xss_clean|valid_email');
        $this->form_validation->set_rules('password','Password','required|xss_clean|trim');
        $category			=		$this->common_model->category_list();
        if($this->form_validation->run()){
            $email			=		$this->input->post('email');
            $password		=		$this->input->post('password');
            $login			=		$this->common_model->login_valid($email,'2');
            //$hash 	    = 	    $this->bcrypt->hash_password($password);
            $counta  =    $this->common_model->login_valid_count($email,'2');
           if($counta>0){
                if($login->is_confirmed==1){
                    if($this->bcrypt->check_password($password, $login->password)){
                       $result = $this->student_model->course_enrolled_detail_api($login->id);
                        $result1         = array("data"=>$result);
                        $encoded_result = json_encode($result1);
                        echo $encoded_result;
                    }
                    else{
                        $result         = array("error"=>"Invalid Username or Password");
                        $encoded_result = json_encode($result);
                        echo $encoded_result;
                    }
                }else{
                    $result         = array("error"=>"Email is not verified,please verify by clicking on link at your email Address");
                    $encoded_result = json_encode($result);
                    echo $encoded_result;
                }
            }
            else{
                $result         = array("error"=>"Email is not registerd yet");
                $encoded_result = json_encode($result);
                echo $encoded_result;
            }
        }
        else{
            $result         = array("error"=>"Email or Password is not valid format");
            $encoded_result = json_encode($result);
            echo $encoded_result;
        }

    }

	public function teacher_login(){

        $this->form_validation->set_rules('email','Email','required|trim|xss_clean|valid_email');
        $this->form_validation->set_rules('password','Password','required|xss_clean|trim');
        $category			=		$this->common_model->category_list();
        if($this->form_validation->run()){
            $email			=		$this->input->post('email');
            $password		=		$this->input->post('password');
            $login			=		$this->common_model->login_valid($email,'1');
            //$hash 	    = 	    $this->bcrypt->hash_password($password);
            $counta  =    $this->common_model->login_valid_count($email,'1');
           if($counta>0){
                if($login->is_confirmed==1){
                    if($this->bcrypt->check_password($password, $login->password)){
                        //$this->load->library('session');
                       // $this->session->set_userdata('ss_id',$login->hashtag.$login->id);
                        //echo $this->session->userdata('ss_id');die;
                       // return redirect('Student');
					   $faculty_ids          	=   $this->teacher_model->v2_faculty_list($login->id);
                       $result 					= 	$this->teacher_model->recent_classes_15_days_list_api($faculty_ids);

                        $result1         = array("data"=>$result);
                        $encoded_result = json_encode($result1);
                        echo $encoded_result;
                    }
                    else{
                        $result         = array("error"=>"Invalid Username or Password");
                        $encoded_result = json_encode($result);
                        echo $encoded_result;
                    }
                }else{
                    $result         = array("error"=>"Email is not verified,please verify by clicking on link at your email Address");
                    $encoded_result = json_encode($result);
                    echo $encoded_result;
                }
            }
            else{
                $result         = array("error"=>"Email is not registerd yet");
                $encoded_result = json_encode($result);
                echo $encoded_result;
            }
        }
        else{
            $result         = array("error"=>"Email or Password is not valid format");
            $encoded_result = json_encode($result);
            echo $encoded_result;
        }

    }
}
